## RabbitMQ 3.13.4

RabbitMQ `3.13.4` is a maintenance release in the `3.13.x` [release series](https://www.rabbitmq.com/release-information).

**Please skip this release and upgrade straight to `3.13.6`** or a later version (if available).

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

Please refer to the upgrade section from the [3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0)
if upgrading from a version prior to 3.13.0.

This release requires Erlang 26 and supports Erlang versions up to `26.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.13.0, RabbitMQ requires Erlang 26. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.12.x (or older releases) on Erlang 25 to 3.13.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) and [v3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.13.x/release-notes).


### Core Broker

#### Bug Fixes

 * A rolling upgrade from `3.12.14` to `3.13.x` could run into an exception.

   GitHub issue: [#11380](https://github.com/rabbitmq/rabbitmq-server/issues/11380)

 * When an existing virtual host was re-imported from a definitions file,
   its default queue type (DQT) was cleared (reset) if that field was missing in the imported
   definitions.

   Now the existing DQT is preserved.

   GitHub issue: [#11457](https://github.com/rabbitmq/rabbitmq-server/pull/11457)

 * When a queue was declared without an explicitly provided `x-queue-type` but a default
   queue type (DQT) set (for its virtual host), its redeclaration did not consider
   the DQT during the [property equivalence check](https://www.rabbitmq.com/docs/queues#property-equivalence) stage.

   GitHub issue: [#11541](https://github.com/rabbitmq/rabbitmq-server/pull/11541)

 * Feature flag controller could run into a deadlock in some upgrade scenarios.

   GitHub issue: [#11414](https://github.com/rabbitmq/rabbitmq-server/pull/11414)

 * In mixed `3.13.x` and `3.12.x` clusters, when a [Direct Reply-to](https://www.rabbitmq.com/docs/direct-reply-to) client (the app that initiates requests)
   was connected to the `3.13` node and the server (the app that responds) was connected to the `3.12` node,
   the response was lost due to a message format conversion exception.

   GitHub issue: [#11401](https://github.com/rabbitmq/rabbitmq-server/pull/11401)

#### Enhancements

 * In some parallel cluster formation scenarios where definitions were [imported on node boot](https://www.rabbitmq.com/docs/definitions#import-on-boot),
   the virtual hosts created by the import can only be started on a subset of nodes. This is so
   because not all cluster peers are known at virtual host creation time.

   To reconcile (repair) this state, nodes will periodically check that all virtual hosts are initialized
   on all cluster nodes. This happens every thirty seconds for the first five minutes
   since node boot. As long as the cluster is fully formed within that amount of time,
   all nodes will have performed initialization for all virtual hosts that exist.

   GitHub issue: [#11408](https://github.com/rabbitmq/rabbitmq-server/pull/11408)

 * Quorum queue leader replicas now initiate reconciliation (repair) of their
   replicas, if there are any missing, more frequently, making quorum queues
   more defensive in the case of (**highly discouraged**) [grow-then-shrink upgrades](https://www.rabbitmq.com/docs/upgrade#grow-then-shrink).

   As part of this change, the CPU cost of reconciliation was reduced, now accounting
   for less than 1% of the CPU with 10K quorum queues in some test environments.

   Contributed by @SimonUnge.

   GitHub issue: [#11029](https://github.com/rabbitmq/rabbitmq-server/discussions/11029)

 * In the case where the `vhost_max` node limit is reached, the node will log specific errors
   when a new virtual host is (unsuccessfully) added.

   Contributed by @SimonUnge.

   GitHub issue: [#11589](https://github.com/rabbitmq/rabbitmq-server/pull/11589)

 * Elapsed time in the logs is now measured using [monotonic time](https://www.erlang.org/doc/apps/erts/time_correction.html).

   GitHub issue: [#11396](https://github.com/rabbitmq/rabbitmq-server/pull/11396)


### CLI Tools

#### Bug Fixes

 * `rabbitmq-diagnostics check_if_node_is_quorum_critical` could report a false positive
   when some quorum queue replcas where very recently added or very recently restarted.

   GitHub issue: [#11524](https://github.com/rabbitmq/rabbitmq-server/pull/11524)

 * `rabbitmqctl list_unresponsive_queues` ran into an exception if there were connected MQTT clients
   with QoS 0 subscriptions.

   Partially contributed by @gomoripeti.

   GitHub issue: [#11434](https://github.com/rabbitmq/rabbitmq-server/issues/11434)

#### Enhancements

 * CLI tools now can be built with Elixir 1.17.x.

   Contributed by @VlkrS.

   GitHub issue: [#11529](https://github.com/rabbitmq/rabbitmq-server/pull/11529)


### OAuth 2 Plugin

#### Enhancements

 * OpenID Connect discovery endpoint now can be overridden for identity providers with
   non-standard configurations.

   GitHub issue: [#11103](https://github.com/rabbitmq/rabbitmq-server/issues/11103)


### Management Plugin

#### Bug Fixes

 * Virtual host metadata was not included into definition files exported via the HTTP API.

   GitHub issue: [#10515](https://github.com/rabbitmq/rabbitmq-server/issues/10515)

 * When Khepri was enabled and a majority of cluster members were down, adding a virtual host
   failed with an unhelpful exception.

   GitHub issue: [#11590](https://github.com/rabbitmq/rabbitmq-server/pull/11590)

#### Enhancements

 * When default queue type is set on a virtual host but not for individual queues,
   the exported queues will have `x-queue-type` set to the default type in the
   exported definitions document.

   GitHub issue: [#10515](https://github.com/rabbitmq/rabbitmq-server/issues/10515)

 * Management UI will now display the number of cores available to the node.

   GitHub issue: [#11382](https://github.com/rabbitmq/rabbitmq-server/pull/11382)

 * OAuth 2-specific JavaScript files are now only loaded if the OAuth 2 plugin is enabled
   on the node.

   GitHub issue: [#11421](https://github.com/rabbitmq/rabbitmq-server/issues/11421)


### HTTP AuthN/AuthZ Backend Plugin

#### Enhancements

 * TLS-related settings, in particular related to [peer certificate chain verification](https://www.rabbitmq.com/docs/ssl#peer-verification), now can be
   configured for this plugin:

   ``` ini
   auth_http.ssl_options.verify = verify_none
   auth_http.ssl_options.fail_if_no_peer_cert = false
   ```

   Please remember that disabling peer certificate chain verification makes the system
   less secure and susceptible to [Man-in-the-Middle attacks](https://en.wikipedia.org/wiki/Man-in-the-middle_attack).
   Consider enabling the verification in production systems when possible.

   GitHub issue: [#10281](https://github.com/rabbitmq/rabbitmq-server/issues/10281)


### etcd Peer Discovery Plugin

#### Bug Fixes

 * The plugin failed to extract discovered nodes name correctly in earlier `3.13.x`
   releases.

   GitHub issue: [#11445](https://github.com/rabbitmq/rabbitmq-server/pull/11445)


### Tracing Plugin

#### Enhancements

 * `tracing.dir`, `tracing.username` and `tracing.password` are the three Tracing plugin
   settings that can be set via `rabbitmq.conf`.

   GitHub issue: [#11554](https://github.com/rabbitmq/rabbitmq-server/issues/11554)


### Dependency Changes

 * Ra was [upgraded to `2.11.0`](https://github.com/rabbitmq/ra/releases)
 * Osiris was [upgraded to `1.8.2`](https://github.com/rabbitmq/osiris/releases)
 * Jose was [upgraded to `1.11.10`](https://github.com/potatosalad/erlang-jose/releases)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.13.4.tar.xz`
instead of the source tarball produced by GitHub.
