package adhybridhealthservice

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ServiceClient is the REST APIs for Azure Active Directory Connect Health
type ServiceClient struct {
	BaseClient
}

// NewServiceClient creates an instance of the ServiceClient client.
func NewServiceClient() ServiceClient {
	return NewServiceClientWithBaseURI(DefaultBaseURI)
}

// NewServiceClientWithBaseURI creates an instance of the ServiceClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewServiceClientWithBaseURI(baseURI string) ServiceClient {
	return ServiceClient{NewWithBaseURI(baseURI)}
}

// GetMetrics gets the server related metrics for a given metric and group combination.
// Parameters:
// serviceName - the name of the service.
// metricName - the metric name
// groupName - the group name
// groupKey - the group key
// fromDate - the start date.
// toDate - the end date.
func (client ServiceClient) GetMetrics(ctx context.Context, serviceName string, metricName string, groupName string, groupKey string, fromDate *date.Time, toDate *date.Time) (result MetricSets, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceClient.GetMetrics")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetMetricsPreparer(ctx, serviceName, metricName, groupName, groupKey, fromDate, toDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceClient", "GetMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceClient", "GetMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.GetMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceClient", "GetMetrics", resp, "Failure responding to request")
		return
	}

	return
}

// GetMetricsPreparer prepares the GetMetrics request.
func (client ServiceClient) GetMetricsPreparer(ctx context.Context, serviceName string, metricName string, groupName string, groupKey string, fromDate *date.Time, toDate *date.Time) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"groupName":   autorest.Encode("path", groupName),
		"metricName":  autorest.Encode("path", metricName),
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(groupKey) > 0 {
		queryParameters["groupKey"] = autorest.Encode("query", groupKey)
	}
	if fromDate != nil {
		queryParameters["fromDate"] = autorest.Encode("query", *fromDate)
	}
	if toDate != nil {
		queryParameters["toDate"] = autorest.Encode("query", *toDate)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/metrics/{metricName}/groups/{groupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMetricsSender sends the GetMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceClient) GetMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetMetricsResponder handles the response to the GetMetrics request. The method always
// closes the http.Response Body.
func (client ServiceClient) GetMetricsResponder(resp *http.Response) (result MetricSets, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
