package avs

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ClusterProvisioningState enumerates the values for cluster provisioning state.
type ClusterProvisioningState string

const (
	// Cancelled ...
	Cancelled ClusterProvisioningState = "Cancelled"
	// Deleting ...
	Deleting ClusterProvisioningState = "Deleting"
	// Failed ...
	Failed ClusterProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ClusterProvisioningState = "Succeeded"
	// Updating ...
	Updating ClusterProvisioningState = "Updating"
)

// PossibleClusterProvisioningStateValues returns an array of possible values for the ClusterProvisioningState const type.
func PossibleClusterProvisioningStateValues() []ClusterProvisioningState {
	return []ClusterProvisioningState{Cancelled, Deleting, Failed, Succeeded, Updating}
}

// ExpressRouteAuthorizationProvisioningState enumerates the values for express route authorization
// provisioning state.
type ExpressRouteAuthorizationProvisioningState string

const (
	// ExpressRouteAuthorizationProvisioningStateFailed ...
	ExpressRouteAuthorizationProvisioningStateFailed ExpressRouteAuthorizationProvisioningState = "Failed"
	// ExpressRouteAuthorizationProvisioningStateSucceeded ...
	ExpressRouteAuthorizationProvisioningStateSucceeded ExpressRouteAuthorizationProvisioningState = "Succeeded"
	// ExpressRouteAuthorizationProvisioningStateUpdating ...
	ExpressRouteAuthorizationProvisioningStateUpdating ExpressRouteAuthorizationProvisioningState = "Updating"
)

// PossibleExpressRouteAuthorizationProvisioningStateValues returns an array of possible values for the ExpressRouteAuthorizationProvisioningState const type.
func PossibleExpressRouteAuthorizationProvisioningStateValues() []ExpressRouteAuthorizationProvisioningState {
	return []ExpressRouteAuthorizationProvisioningState{ExpressRouteAuthorizationProvisioningStateFailed, ExpressRouteAuthorizationProvisioningStateSucceeded, ExpressRouteAuthorizationProvisioningStateUpdating}
}

// HcxEnterpriseSiteStatus enumerates the values for hcx enterprise site status.
type HcxEnterpriseSiteStatus string

const (
	// Available ...
	Available HcxEnterpriseSiteStatus = "Available"
	// Consumed ...
	Consumed HcxEnterpriseSiteStatus = "Consumed"
	// Deactivated ...
	Deactivated HcxEnterpriseSiteStatus = "Deactivated"
	// Deleted ...
	Deleted HcxEnterpriseSiteStatus = "Deleted"
)

// PossibleHcxEnterpriseSiteStatusValues returns an array of possible values for the HcxEnterpriseSiteStatus const type.
func PossibleHcxEnterpriseSiteStatusValues() []HcxEnterpriseSiteStatus {
	return []HcxEnterpriseSiteStatus{Available, Consumed, Deactivated, Deleted}
}

// InternetEnum enumerates the values for internet enum.
type InternetEnum string

const (
	// Disabled ...
	Disabled InternetEnum = "Disabled"
	// Enabled ...
	Enabled InternetEnum = "Enabled"
)

// PossibleInternetEnumValues returns an array of possible values for the InternetEnum const type.
func PossibleInternetEnumValues() []InternetEnum {
	return []InternetEnum{Disabled, Enabled}
}

// PrivateCloudProvisioningState enumerates the values for private cloud provisioning state.
type PrivateCloudProvisioningState string

const (
	// PrivateCloudProvisioningStateBuilding ...
	PrivateCloudProvisioningStateBuilding PrivateCloudProvisioningState = "Building"
	// PrivateCloudProvisioningStateCancelled ...
	PrivateCloudProvisioningStateCancelled PrivateCloudProvisioningState = "Cancelled"
	// PrivateCloudProvisioningStateDeleting ...
	PrivateCloudProvisioningStateDeleting PrivateCloudProvisioningState = "Deleting"
	// PrivateCloudProvisioningStateFailed ...
	PrivateCloudProvisioningStateFailed PrivateCloudProvisioningState = "Failed"
	// PrivateCloudProvisioningStatePending ...
	PrivateCloudProvisioningStatePending PrivateCloudProvisioningState = "Pending"
	// PrivateCloudProvisioningStateSucceeded ...
	PrivateCloudProvisioningStateSucceeded PrivateCloudProvisioningState = "Succeeded"
	// PrivateCloudProvisioningStateUpdating ...
	PrivateCloudProvisioningStateUpdating PrivateCloudProvisioningState = "Updating"
)

// PossiblePrivateCloudProvisioningStateValues returns an array of possible values for the PrivateCloudProvisioningState const type.
func PossiblePrivateCloudProvisioningStateValues() []PrivateCloudProvisioningState {
	return []PrivateCloudProvisioningState{PrivateCloudProvisioningStateBuilding, PrivateCloudProvisioningStateCancelled, PrivateCloudProvisioningStateDeleting, PrivateCloudProvisioningStateFailed, PrivateCloudProvisioningStatePending, PrivateCloudProvisioningStateSucceeded, PrivateCloudProvisioningStateUpdating}
}

// QuotaEnabled enumerates the values for quota enabled.
type QuotaEnabled string

const (
	// QuotaEnabledDisabled ...
	QuotaEnabledDisabled QuotaEnabled = "Disabled"
	// QuotaEnabledEnabled ...
	QuotaEnabledEnabled QuotaEnabled = "Enabled"
)

// PossibleQuotaEnabledValues returns an array of possible values for the QuotaEnabled const type.
func PossibleQuotaEnabledValues() []QuotaEnabled {
	return []QuotaEnabled{QuotaEnabledDisabled, QuotaEnabledEnabled}
}

// SslEnum enumerates the values for ssl enum.
type SslEnum string

const (
	// SslEnumDisabled ...
	SslEnumDisabled SslEnum = "Disabled"
	// SslEnumEnabled ...
	SslEnumEnabled SslEnum = "Enabled"
)

// PossibleSslEnumValues returns an array of possible values for the SslEnum const type.
func PossibleSslEnumValues() []SslEnum {
	return []SslEnum{SslEnumDisabled, SslEnumEnabled}
}

// TrialStatus enumerates the values for trial status.
type TrialStatus string

const (
	// TrialAvailable ...
	TrialAvailable TrialStatus = "TrialAvailable"
	// TrialDisabled ...
	TrialDisabled TrialStatus = "TrialDisabled"
	// TrialUsed ...
	TrialUsed TrialStatus = "TrialUsed"
)

// PossibleTrialStatusValues returns an array of possible values for the TrialStatus const type.
func PossibleTrialStatusValues() []TrialStatus {
	return []TrialStatus{TrialAvailable, TrialDisabled, TrialUsed}
}
