import yoda

# FSR corrections coefficients to be applied as sigma / fsr
z_y_fsr    = [ 1.05, 1.032, 1.027, 1.026, 1.025, 1.026, 1.026, 1.025, 1.026, 1.028, 1.026, 1.027, 1.026, 1.021, 1.025, 1.011, 1.018 ]
z_pt_fsr   = [ 1.09, 1.08, 1.063, 1.049, 1.034, 1.021, 1.002, 0.996, 0.984, 0.978, 0.985, 1.013, 1.038, 1.06 ]
z_phi_fsr  = [ 1.034, 1.035, 1.034, 1.029, 1.026, 1.021, 1.020, 1.018, 1.019, 1.022, 1.024, 1.029, 1.025, 1.03, 1.031 ]
wp_eta_fsr = [ 1.016, 1.018, 1.025, 1.015, 1.021, 1.015, 1.024, 1.021 ]
wm_eta_fsr = [ 1.019, 1.015, 1.010, 1.007, 1.009, 1.017, 1.012, 1.000 ]

# Placeholders for W bosons cross-sections without FSR corrections to be used in ratio and assymetries calculations
h_wp_eta_fsr = None
h_wm_eta_fsr = None

needs_patching_fsr_bw = {
 'd01-x01-y01' : (3, z_y_fsr),
 'd02-x01-y01' : (3, z_pt_fsr),
 'd03-x01-y01' : (3, z_phi_fsr),
 'd04-x01-y01' : (5, wp_eta_fsr),
 'd04-x01-y03' : (6, wm_eta_fsr),
}

needs_patching_ratio = {
 'd05-x01-y01' : (2),
}

needs_patching_asymm = {
 'd06-x01-y01' : (2),
}

def patch(path, ao):
    hname = path.split('/')[-1]
    ident = hname.split('-')[0]
    global h_wp_eta_fsr, h_wm_eta_fsr
    # Undo FSR corrections and save into new object, devide cross-sections bins by bin width
    if hname in needs_patching_fsr_bw:
        nbin = 1
        yid, fsr = needs_patching_fsr_bw[hname]
        aos = [ ao ]
        newName ='%s-x01-y0%i' % (ident, yid)
        newPath = path.replace(hname, newName)
        newAo = yoda.Estimate1D(ao.xEdges(), newPath)
        for newBin in newAo.bins():
            oldBin = ao.bin(nbin)
            newBin.setVal( oldBin.val() / fsr[nbin-1] / (ao.xEdges()[nbin]-ao.xEdges()[nbin-1]) )
            oldBin.setVal( oldBin.val() / (ao.xEdges()[nbin]-ao.xEdges()[nbin-1]) )
            sources = oldBin.sources()
            errs = [ (s, oldBin.err(s)) for s in sources ]
            for label, epair in errs:
                newBin.setErr(epair, label)
            nbin = nbin + 1
        if newName == "d04-x01-y05" : h_wp_eta_fsr=newAo
        if newName == "d04-x01-y06" : h_wm_eta_fsr=newAo
        aos.append(newAo)
        return aos
    # Calculate ratios for new cross-sections without FSR corrections
    if hname in needs_patching_ratio:
        nbin = 1
        yid = needs_patching_ratio[hname]
        aos = [ ao ]
        newName ='%s-x01-y0%i' % (ident, yid)
        newPath = path.replace(hname, newName)
        newAo = yoda.Estimate1D(ao.xEdges(), newPath)
        for newBin in newAo.bins():
            oldBin = ao.bin(nbin)
            if (h_wp_eta_fsr and h_wm_eta_fsr): newBin.setVal( h_wp_eta_fsr.bin(nbin).val() / h_wm_eta_fsr.bin(nbin).val() )
            else: newBin.setVal( oldBin.val() )
            sources = oldBin.sources()
            errs = [ (s, oldBin.err(s)) for s in sources ]
            for label, epair in errs:
                newBin.setErr(epair, label)
            nbin = nbin + 1
        aos.append(newAo)
        return aos
    # Calculate asymmetries for new cross-sections without FSR corrections
    if hname in needs_patching_asymm:
        nbin = 1
        yid = needs_patching_asymm[hname]
        aos = [ ao ]
        newName ='%s-x01-y0%i' % (ident, yid)
        newPath = path.replace(hname, newName)
        newAo = yoda.Estimate1D(ao.xEdges(), newPath)
        for newBin in newAo.bins():
            oldBin = ao.bin(nbin)
            if (h_wp_eta_fsr and h_wm_eta_fsr): newBin.setVal( (h_wp_eta_fsr.bin(nbin).val() - h_wm_eta_fsr.bin(nbin).val()) / (h_wp_eta_fsr.bin(nbin).val() + h_wm_eta_fsr.bin(nbin).val()) )
            else: newBin.setVal( oldBin.val() )
            sources = oldBin.sources()
            errs = [ (s, oldBin.err(s)) for s in sources ]
            for label, epair in errs:
                newBin.setErr(epair, label)
            nbin = nbin + 1
        aos.append(newAo)
        return aos
    return [ ao ]
