// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn de_get_web_identity_token_http_error(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<
    crate::operation::get_web_identity_token::GetWebIdentityTokenOutput,
    crate::operation::get_web_identity_token::GetWebIdentityTokenError,
> {
    #[allow(unused_mut)]
    let mut generic_builder = crate::protocol_serde::parse_http_error_metadata(_response_status, _response_headers, _response_body)
        .map_err(crate::operation::get_web_identity_token::GetWebIdentityTokenError::unhandled)?;
    generic_builder = ::aws_types::request_id::apply_request_id(generic_builder, _response_headers);
    let generic = generic_builder.build();
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::operation::get_web_identity_token::GetWebIdentityTokenError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "JWTPayloadSizeExceededException" => crate::operation::get_web_identity_token::GetWebIdentityTokenError::JwtPayloadSizeExceededException({
            #[allow(unused_mut)]
            let mut tmp = {
                #[allow(unused_mut)]
                let mut output = crate::types::error::builders::JwtPayloadSizeExceededExceptionBuilder::default();
                output = crate::protocol_serde::shape_jwt_payload_size_exceeded_exception::de_jwt_payload_size_exceeded_exception_xml_err(
                    _response_body,
                    output,
                )
                .map_err(crate::operation::get_web_identity_token::GetWebIdentityTokenError::unhandled)?;
                let output = output.meta(generic);
                output.build()
            };
            if tmp.message.is_none() {
                tmp.message = _error_message;
            }
            tmp
        }),
        "OutboundWebIdentityFederationDisabledException" => {
            crate::operation::get_web_identity_token::GetWebIdentityTokenError::OutboundWebIdentityFederationDisabledException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::types::error::builders::OutboundWebIdentityFederationDisabledExceptionBuilder::default();
                    output = crate::protocol_serde::shape_outbound_web_identity_federation_disabled_exception::de_outbound_web_identity_federation_disabled_exception_xml_err(_response_body, output).map_err(crate::operation::get_web_identity_token::GetWebIdentityTokenError::unhandled)?;
                    let output = output.meta(generic);
                    output.build()
                };
                if tmp.message.is_none() {
                    tmp.message = _error_message;
                }
                tmp
            })
        }
        "SessionDurationEscalationException" => {
            crate::operation::get_web_identity_token::GetWebIdentityTokenError::SessionDurationEscalationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::types::error::builders::SessionDurationEscalationExceptionBuilder::default();
                    output = crate::protocol_serde::shape_session_duration_escalation_exception::de_session_duration_escalation_exception_xml_err(
                        _response_body,
                        output,
                    )
                    .map_err(crate::operation::get_web_identity_token::GetWebIdentityTokenError::unhandled)?;
                    let output = output.meta(generic);
                    output.build()
                };
                if tmp.message.is_none() {
                    tmp.message = _error_message;
                }
                tmp
            })
        }
        _ => crate::operation::get_web_identity_token::GetWebIdentityTokenError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn de_get_web_identity_token_http_response(
    _response_status: u16,
    _response_headers: &::aws_smithy_runtime_api::http::Headers,
    _response_body: &[u8],
) -> std::result::Result<
    crate::operation::get_web_identity_token::GetWebIdentityTokenOutput,
    crate::operation::get_web_identity_token::GetWebIdentityTokenError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::operation::get_web_identity_token::builders::GetWebIdentityTokenOutputBuilder::default();
        output = crate::protocol_serde::shape_get_web_identity_token::de_get_web_identity_token(_response_body, output)
            .map_err(crate::operation::get_web_identity_token::GetWebIdentityTokenError::unhandled)?;
        output._set_request_id(::aws_types::request_id::RequestId::request_id(_response_headers).map(str::to_string));
        output.build()
    })
}

#[allow(unused_mut)]
pub fn de_get_web_identity_token(
    inp: &[u8],
    mut builder: crate::operation::get_web_identity_token::builders::GetWebIdentityTokenOutputBuilder,
) -> std::result::Result<crate::operation::get_web_identity_token::builders::GetWebIdentityTokenOutputBuilder, ::aws_smithy_xml::decode::XmlDecodeError>
{
    let mut doc = ::aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    #[allow(unused_variables)]
    let start_el = decoder.start_el();
    if !(start_el.matches("GetWebIdentityTokenResponse")) {
        return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(format!(
            "invalid root, expected GetWebIdentityTokenResponse got {start_el:?}"
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetWebIdentityTokenResult")) {
            return Err(::aws_smithy_xml::decode::XmlDecodeError::custom(format!(
                "invalid result, expected GetWebIdentityTokenResult got {start_el:?}"
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("WebIdentityToken") /* WebIdentityToken com.amazonaws.sts.synthetic#GetWebIdentityTokenOutput$WebIdentityToken */ =>  {
                let var_1 =
                    Some(
                        Result::<::std::string::String, ::aws_smithy_xml::decode::XmlDecodeError>::Ok(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_web_identity_token(var_1);
            }
            ,
            s if s.matches("Expiration") /* Expiration com.amazonaws.sts.synthetic#GetWebIdentityTokenOutput$Expiration */ =>  {
                let var_2 =
                    Some(
                        ::aws_smithy_types::DateTime::from_str(
                            ::aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , ::aws_smithy_types::date_time::Format::DateTimeWithOffset
                        )
                        .map_err(|_|::aws_smithy_xml::decode::XmlDecodeError::custom("expected (timestamp: `com.amazonaws.sts#dateType`)"))
                        ?
                    )
                ;
                builder = builder.set_expiration(var_2);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(::aws_smithy_xml::decode::XmlDecodeError::custom("expected GetWebIdentityTokenResult tag"));
    };
    Ok(builder)
}
