//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfcontentstream?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct CGPDFContentStream {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPDFContentStream {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Encoding::Struct("CGPDFContentStream", &[]));
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpdfcontentstreamref?language=objc)
pub type CGPDFContentStreamRef = *mut CGPDFContentStream;

impl CGPDFContentStream {
    #[doc(alias = "CGPDFContentStreamCreateWithPage")]
    #[cfg(feature = "CGPDFPage")]
    #[inline]
    pub fn create_with_page(page: &CGPDFPage) -> CGPDFContentStreamRef {
        extern "C-unwind" {
            fn CGPDFContentStreamCreateWithPage(page: &CGPDFPage) -> CGPDFContentStreamRef;
        }
        unsafe { CGPDFContentStreamCreateWithPage(page) }
    }

    /// # Safety
    ///
    /// - `stream` must be a valid pointer.
    /// - `stream_resources` must be a valid pointer.
    /// - `parent` must be a valid pointer or null.
    #[doc(alias = "CGPDFContentStreamCreateWithStream")]
    #[cfg(all(feature = "CGPDFDictionary", feature = "CGPDFStream"))]
    #[inline]
    pub unsafe fn create_with_stream(
        stream: CGPDFStreamRef,
        stream_resources: CGPDFDictionaryRef,
        parent: CGPDFContentStreamRef,
    ) -> CGPDFContentStreamRef {
        extern "C-unwind" {
            fn CGPDFContentStreamCreateWithStream(
                stream: CGPDFStreamRef,
                stream_resources: CGPDFDictionaryRef,
                parent: CGPDFContentStreamRef,
            ) -> CGPDFContentStreamRef;
        }
        unsafe { CGPDFContentStreamCreateWithStream(stream, stream_resources, parent) }
    }

    /// # Safety
    ///
    /// `cs` must be a valid pointer.
    #[doc(alias = "CGPDFContentStreamRetain")]
    #[inline]
    pub unsafe fn retain(cs: CGPDFContentStreamRef) -> CGPDFContentStreamRef {
        extern "C-unwind" {
            fn CGPDFContentStreamRetain(cs: CGPDFContentStreamRef) -> CGPDFContentStreamRef;
        }
        unsafe { CGPDFContentStreamRetain(cs) }
    }

    /// # Safety
    ///
    /// `cs` must be a valid pointer.
    #[doc(alias = "CGPDFContentStreamRelease")]
    #[inline]
    pub unsafe fn release(cs: CGPDFContentStreamRef) {
        extern "C-unwind" {
            fn CGPDFContentStreamRelease(cs: CGPDFContentStreamRef);
        }
        unsafe { CGPDFContentStreamRelease(cs) }
    }

    /// # Safety
    ///
    /// `cs` must be a valid pointer.
    #[doc(alias = "CGPDFContentStreamGetStreams")]
    #[inline]
    pub unsafe fn streams(cs: CGPDFContentStreamRef) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CGPDFContentStreamGetStreams(cs: CGPDFContentStreamRef) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CGPDFContentStreamGetStreams(cs) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// # Safety
    ///
    /// - `cs` must be a valid pointer.
    /// - `category` must be a valid pointer.
    /// - `name` must be a valid pointer.
    #[doc(alias = "CGPDFContentStreamGetResource")]
    #[cfg(feature = "CGPDFObject")]
    #[inline]
    pub unsafe fn resource(
        cs: CGPDFContentStreamRef,
        category: NonNull<c_char>,
        name: NonNull<c_char>,
    ) -> CGPDFObjectRef {
        extern "C-unwind" {
            fn CGPDFContentStreamGetResource(
                cs: CGPDFContentStreamRef,
                category: NonNull<c_char>,
                name: NonNull<c_char>,
            ) -> CGPDFObjectRef;
        }
        unsafe { CGPDFContentStreamGetResource(cs, category, name) }
    }
}

#[cfg(feature = "CGPDFPage")]
#[deprecated = "renamed to `CGPDFContentStream::create_with_page`"]
#[inline]
pub extern "C-unwind" fn CGPDFContentStreamCreateWithPage(
    page: &CGPDFPage,
) -> CGPDFContentStreamRef {
    extern "C-unwind" {
        fn CGPDFContentStreamCreateWithPage(page: &CGPDFPage) -> CGPDFContentStreamRef;
    }
    unsafe { CGPDFContentStreamCreateWithPage(page) }
}

extern "C-unwind" {
    #[cfg(all(feature = "CGPDFDictionary", feature = "CGPDFStream"))]
    #[deprecated = "renamed to `CGPDFContentStream::create_with_stream`"]
    pub fn CGPDFContentStreamCreateWithStream(
        stream: CGPDFStreamRef,
        stream_resources: CGPDFDictionaryRef,
        parent: CGPDFContentStreamRef,
    ) -> CGPDFContentStreamRef;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFContentStream::retain`"]
    pub fn CGPDFContentStreamRetain(cs: CGPDFContentStreamRef) -> CGPDFContentStreamRef;
}

extern "C-unwind" {
    #[deprecated = "renamed to `CGPDFContentStream::release`"]
    pub fn CGPDFContentStreamRelease(cs: CGPDFContentStreamRef);
}

#[deprecated = "renamed to `CGPDFContentStream::streams`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPDFContentStreamGetStreams(
    cs: CGPDFContentStreamRef,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CGPDFContentStreamGetStreams(cs: CGPDFContentStreamRef) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CGPDFContentStreamGetStreams(cs) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CGPDFObject")]
    #[deprecated = "renamed to `CGPDFContentStream::resource`"]
    pub fn CGPDFContentStreamGetResource(
        cs: CGPDFContentStreamRef,
        category: NonNull<c_char>,
        name: NonNull<c_char>,
    ) -> CGPDFObjectRef;
}
