//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CXX03___TUPLE_SFINAE_HELPERS_H
#define _LIBCPP___CXX03___TUPLE_SFINAE_HELPERS_H

#include <__cxx03/__config>
#include <__cxx03/__fwd/tuple.h>
#include <__cxx03/__tuple/make_tuple_types.h>
#include <__cxx03/__tuple/tuple_element.h>
#include <__cxx03/__tuple/tuple_like_ext.h>
#include <__cxx03/__tuple/tuple_size.h>
#include <__cxx03/__tuple/tuple_types.h>
#include <__cxx03/__type_traits/conjunction.h>
#include <__cxx03/__type_traits/enable_if.h>
#include <__cxx03/__type_traits/integral_constant.h>
#include <__cxx03/__type_traits/is_constructible.h>
#include <__cxx03/__type_traits/is_same.h>
#include <__cxx03/__type_traits/remove_cvref.h>
#include <__cxx03/__type_traits/remove_reference.h>
#include <__cxx03/cstddef>

#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#  pragma GCC system_header
#endif

_LIBCPP_BEGIN_NAMESPACE_STD

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CXX03___TUPLE_SFINAE_HELPERS_H
