// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudNetwork20200907ListTGWAttachmentsResponse hashicorp cloud network 20200907 list t g w attachments response
//
// swagger:model hashicorp.cloud.network_20200907.ListTGWAttachmentsResponse
type HashicorpCloudNetwork20200907ListTGWAttachmentsResponse struct {

	// Pagination contains the pagination tokens for a subsequent request.
	Pagination *cloud.HashicorpCloudCommonPaginationResponse `json:"pagination,omitempty"`

	// transit_gateway_attachments is a list of found TGW Attachments
	TgwAttachments []*HashicorpCloudNetwork20200907TGWAttachment `json:"tgw_attachments"`
}

// Validate validates this hashicorp cloud network 20200907 list t g w attachments response
func (m *HashicorpCloudNetwork20200907ListTGWAttachmentsResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePagination(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTgwAttachments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudNetwork20200907ListTGWAttachmentsResponse) validatePagination(formats strfmt.Registry) error {
	if swag.IsZero(m.Pagination) { // not required
		return nil
	}

	if m.Pagination != nil {
		if err := m.Pagination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pagination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pagination")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907ListTGWAttachmentsResponse) validateTgwAttachments(formats strfmt.Registry) error {
	if swag.IsZero(m.TgwAttachments) { // not required
		return nil
	}

	for i := 0; i < len(m.TgwAttachments); i++ {
		if swag.IsZero(m.TgwAttachments[i]) { // not required
			continue
		}

		if m.TgwAttachments[i] != nil {
			if err := m.TgwAttachments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tgw_attachments" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("tgw_attachments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud network 20200907 list t g w attachments response based on the context it is used
func (m *HashicorpCloudNetwork20200907ListTGWAttachmentsResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePagination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTgwAttachments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudNetwork20200907ListTGWAttachmentsResponse) contextValidatePagination(ctx context.Context, formats strfmt.Registry) error {

	if m.Pagination != nil {

		if swag.IsZero(m.Pagination) { // not required
			return nil
		}

		if err := m.Pagination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pagination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pagination")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudNetwork20200907ListTGWAttachmentsResponse) contextValidateTgwAttachments(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.TgwAttachments); i++ {

		if m.TgwAttachments[i] != nil {

			if swag.IsZero(m.TgwAttachments[i]) { // not required
				return nil
			}

			if err := m.TgwAttachments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tgw_attachments" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("tgw_attachments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudNetwork20200907ListTGWAttachmentsResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudNetwork20200907ListTGWAttachmentsResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudNetwork20200907ListTGWAttachmentsResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
