// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// DeleteRegistryReader is a Reader for the DeleteRegistry structure.
type DeleteRegistryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteRegistryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteRegistryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeleteRegistryDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeleteRegistryOK creates a DeleteRegistryOK with default headers values
func NewDeleteRegistryOK() *DeleteRegistryOK {
	return &DeleteRegistryOK{}
}

/*
DeleteRegistryOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeleteRegistryOK struct {
	Payload *models.HashicorpCloudVagrant20220930DeleteRegistryResponse
}

// IsSuccess returns true when this delete registry o k response has a 2xx status code
func (o *DeleteRegistryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete registry o k response has a 3xx status code
func (o *DeleteRegistryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete registry o k response has a 4xx status code
func (o *DeleteRegistryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete registry o k response has a 5xx status code
func (o *DeleteRegistryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete registry o k response a status code equal to that given
func (o *DeleteRegistryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete registry o k response
func (o *DeleteRegistryOK) Code() int {
	return 200
}

func (o *DeleteRegistryOK) Error() string {
	return fmt.Sprintf("[DELETE /vagrant/2022-09-30/registry/{registry}][%d] deleteRegistryOK  %+v", 200, o.Payload)
}

func (o *DeleteRegistryOK) String() string {
	return fmt.Sprintf("[DELETE /vagrant/2022-09-30/registry/{registry}][%d] deleteRegistryOK  %+v", 200, o.Payload)
}

func (o *DeleteRegistryOK) GetPayload() *models.HashicorpCloudVagrant20220930DeleteRegistryResponse {
	return o.Payload
}

func (o *DeleteRegistryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930DeleteRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteRegistryDefault creates a DeleteRegistryDefault with default headers values
func NewDeleteRegistryDefault(code int) *DeleteRegistryDefault {
	return &DeleteRegistryDefault{
		_statusCode: code,
	}
}

/*
DeleteRegistryDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeleteRegistryDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this delete registry default response has a 2xx status code
func (o *DeleteRegistryDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this delete registry default response has a 3xx status code
func (o *DeleteRegistryDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this delete registry default response has a 4xx status code
func (o *DeleteRegistryDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this delete registry default response has a 5xx status code
func (o *DeleteRegistryDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this delete registry default response a status code equal to that given
func (o *DeleteRegistryDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the delete registry default response
func (o *DeleteRegistryDefault) Code() int {
	return o._statusCode
}

func (o *DeleteRegistryDefault) Error() string {
	return fmt.Sprintf("[DELETE /vagrant/2022-09-30/registry/{registry}][%d] DeleteRegistry default  %+v", o._statusCode, o.Payload)
}

func (o *DeleteRegistryDefault) String() string {
	return fmt.Sprintf("[DELETE /vagrant/2022-09-30/registry/{registry}][%d] DeleteRegistry default  %+v", o._statusCode, o.Payload)
}

func (o *DeleteRegistryDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *DeleteRegistryDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
