// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// DeleteAppSecretVersionReader is a Reader for the DeleteAppSecretVersion structure.
type DeleteAppSecretVersionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteAppSecretVersionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteAppSecretVersionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeleteAppSecretVersionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeleteAppSecretVersionOK creates a DeleteAppSecretVersionOK with default headers values
func NewDeleteAppSecretVersionOK() *DeleteAppSecretVersionOK {
	return &DeleteAppSecretVersionOK{}
}

/*
DeleteAppSecretVersionOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeleteAppSecretVersionOK struct {
	Payload models.Secrets20231128DeleteAppSecretVersionResponse
}

// IsSuccess returns true when this delete app secret version o k response has a 2xx status code
func (o *DeleteAppSecretVersionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete app secret version o k response has a 3xx status code
func (o *DeleteAppSecretVersionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete app secret version o k response has a 4xx status code
func (o *DeleteAppSecretVersionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete app secret version o k response has a 5xx status code
func (o *DeleteAppSecretVersionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete app secret version o k response a status code equal to that given
func (o *DeleteAppSecretVersionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete app secret version o k response
func (o *DeleteAppSecretVersionOK) Code() int {
	return 200
}

func (o *DeleteAppSecretVersionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{secret_name}/versions/{version}][%d] deleteAppSecretVersionOK %s", 200, payload)
}

func (o *DeleteAppSecretVersionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{secret_name}/versions/{version}][%d] deleteAppSecretVersionOK %s", 200, payload)
}

func (o *DeleteAppSecretVersionOK) GetPayload() models.Secrets20231128DeleteAppSecretVersionResponse {
	return o.Payload
}

func (o *DeleteAppSecretVersionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteAppSecretVersionDefault creates a DeleteAppSecretVersionDefault with default headers values
func NewDeleteAppSecretVersionDefault(code int) *DeleteAppSecretVersionDefault {
	return &DeleteAppSecretVersionDefault{
		_statusCode: code,
	}
}

/*
DeleteAppSecretVersionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeleteAppSecretVersionDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this delete app secret version default response has a 2xx status code
func (o *DeleteAppSecretVersionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this delete app secret version default response has a 3xx status code
func (o *DeleteAppSecretVersionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this delete app secret version default response has a 4xx status code
func (o *DeleteAppSecretVersionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this delete app secret version default response has a 5xx status code
func (o *DeleteAppSecretVersionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this delete app secret version default response a status code equal to that given
func (o *DeleteAppSecretVersionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the delete app secret version default response
func (o *DeleteAppSecretVersionDefault) Code() int {
	return o._statusCode
}

func (o *DeleteAppSecretVersionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{secret_name}/versions/{version}][%d] DeleteAppSecretVersion default %s", o._statusCode, payload)
}

func (o *DeleteAppSecretVersionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{secret_name}/versions/{version}][%d] DeleteAppSecretVersion default %s", o._statusCode, payload)
}

func (o *DeleteAppSecretVersionDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *DeleteAppSecretVersionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
