// Code generated by go-swagger; DO NOT EDIT.

package billing_account_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-billing/preview/2020-11-05/models"
)

// BillingAccountServiceGetByProjectReader is a Reader for the BillingAccountServiceGetByProject structure.
type BillingAccountServiceGetByProjectReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BillingAccountServiceGetByProjectReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBillingAccountServiceGetByProjectOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBillingAccountServiceGetByProjectDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBillingAccountServiceGetByProjectOK creates a BillingAccountServiceGetByProjectOK with default headers values
func NewBillingAccountServiceGetByProjectOK() *BillingAccountServiceGetByProjectOK {
	return &BillingAccountServiceGetByProjectOK{}
}

/*
BillingAccountServiceGetByProjectOK describes a response with status code 200, with default header values.

A successful response.
*/
type BillingAccountServiceGetByProjectOK struct {
	Payload *models.Billing20201105GetBillingAccountResponse
}

// IsSuccess returns true when this billing account service get by project o k response has a 2xx status code
func (o *BillingAccountServiceGetByProjectOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this billing account service get by project o k response has a 3xx status code
func (o *BillingAccountServiceGetByProjectOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this billing account service get by project o k response has a 4xx status code
func (o *BillingAccountServiceGetByProjectOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this billing account service get by project o k response has a 5xx status code
func (o *BillingAccountServiceGetByProjectOK) IsServerError() bool {
	return false
}

// IsCode returns true when this billing account service get by project o k response a status code equal to that given
func (o *BillingAccountServiceGetByProjectOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the billing account service get by project o k response
func (o *BillingAccountServiceGetByProjectOK) Code() int {
	return 200
}

func (o *BillingAccountServiceGetByProjectOK) Error() string {
	return fmt.Sprintf("[GET /billing/2020-11-05/organizations/{organization_id}/projects/{project_id}/account][%d] billingAccountServiceGetByProjectOK  %+v", 200, o.Payload)
}

func (o *BillingAccountServiceGetByProjectOK) String() string {
	return fmt.Sprintf("[GET /billing/2020-11-05/organizations/{organization_id}/projects/{project_id}/account][%d] billingAccountServiceGetByProjectOK  %+v", 200, o.Payload)
}

func (o *BillingAccountServiceGetByProjectOK) GetPayload() *models.Billing20201105GetBillingAccountResponse {
	return o.Payload
}

func (o *BillingAccountServiceGetByProjectOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Billing20201105GetBillingAccountResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBillingAccountServiceGetByProjectDefault creates a BillingAccountServiceGetByProjectDefault with default headers values
func NewBillingAccountServiceGetByProjectDefault(code int) *BillingAccountServiceGetByProjectDefault {
	return &BillingAccountServiceGetByProjectDefault{
		_statusCode: code,
	}
}

/*
BillingAccountServiceGetByProjectDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type BillingAccountServiceGetByProjectDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this billing account service get by project default response has a 2xx status code
func (o *BillingAccountServiceGetByProjectDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this billing account service get by project default response has a 3xx status code
func (o *BillingAccountServiceGetByProjectDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this billing account service get by project default response has a 4xx status code
func (o *BillingAccountServiceGetByProjectDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this billing account service get by project default response has a 5xx status code
func (o *BillingAccountServiceGetByProjectDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this billing account service get by project default response a status code equal to that given
func (o *BillingAccountServiceGetByProjectDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the billing account service get by project default response
func (o *BillingAccountServiceGetByProjectDefault) Code() int {
	return o._statusCode
}

func (o *BillingAccountServiceGetByProjectDefault) Error() string {
	return fmt.Sprintf("[GET /billing/2020-11-05/organizations/{organization_id}/projects/{project_id}/account][%d] BillingAccountService_GetByProject default  %+v", o._statusCode, o.Payload)
}

func (o *BillingAccountServiceGetByProjectDefault) String() string {
	return fmt.Sprintf("[GET /billing/2020-11-05/organizations/{organization_id}/projects/{project_id}/account][%d] BillingAccountService_GetByProject default  %+v", o._statusCode, o.Payload)
}

func (o *BillingAccountServiceGetByProjectDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *BillingAccountServiceGetByProjectDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
