// Code generated by go-swagger; DO NOT EDIT.

package service_instances

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new service instances API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for service instances API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	GetServiceInstance(params *GetServiceInstanceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetServiceInstanceOK, error)

	ListServiceInstances(params *ListServiceInstancesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListServiceInstancesOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
GetServiceInstance get service instance API
*/
func (a *Client) GetServiceInstance(params *GetServiceInstanceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetServiceInstanceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetServiceInstanceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Get Service Instance",
		Method:             "GET",
		PathPattern:        "/2023-10-10/{cluster_resource_name}/node/{node}/service/{service_name}/instance/{instance_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetServiceInstanceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetServiceInstanceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetServiceInstanceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListServiceInstances instances a p is
*/
func (a *Client) ListServiceInstances(params *ListServiceInstancesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListServiceInstancesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListServiceInstancesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "List Service Instances",
		Method:             "GET",
		PathPattern:        "/2023-10-10/{cluster_resource_name}/service/{service_name}/instances",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListServiceInstancesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListServiceInstancesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListServiceInstancesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
