// Code generated by go-swagger; DO NOT EDIT.

package network_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetPeeringParams creates a new GetPeeringParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetPeeringParams() *GetPeeringParams {
	return &GetPeeringParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetPeeringParamsWithTimeout creates a new GetPeeringParams object
// with the ability to set a timeout on a request.
func NewGetPeeringParamsWithTimeout(timeout time.Duration) *GetPeeringParams {
	return &GetPeeringParams{
		timeout: timeout,
	}
}

// NewGetPeeringParamsWithContext creates a new GetPeeringParams object
// with the ability to set a context for a request.
func NewGetPeeringParamsWithContext(ctx context.Context) *GetPeeringParams {
	return &GetPeeringParams{
		Context: ctx,
	}
}

// NewGetPeeringParamsWithHTTPClient creates a new GetPeeringParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetPeeringParamsWithHTTPClient(client *http.Client) *GetPeeringParams {
	return &GetPeeringParams{
		HTTPClient: client,
	}
}

/*
GetPeeringParams contains all the parameters to send to the API endpoint

	for the get peering operation.

	Typically these are written to a http.Request.
*/
type GetPeeringParams struct {

	/* HvnID.

	   HvnId is an ID of the HVN where the peering belongs to
	*/
	HvnID string

	/* ID.

	   Id is the ID of a peering to fetch
	*/
	ID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get peering params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetPeeringParams) WithDefaults() *GetPeeringParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get peering params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetPeeringParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get peering params
func (o *GetPeeringParams) WithTimeout(timeout time.Duration) *GetPeeringParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get peering params
func (o *GetPeeringParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get peering params
func (o *GetPeeringParams) WithContext(ctx context.Context) *GetPeeringParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get peering params
func (o *GetPeeringParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get peering params
func (o *GetPeeringParams) WithHTTPClient(client *http.Client) *GetPeeringParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get peering params
func (o *GetPeeringParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithHvnID adds the hvnID to the get peering params
func (o *GetPeeringParams) WithHvnID(hvnID string) *GetPeeringParams {
	o.SetHvnID(hvnID)
	return o
}

// SetHvnID adds the hvnId to the get peering params
func (o *GetPeeringParams) SetHvnID(hvnID string) {
	o.HvnID = hvnID
}

// WithID adds the id to the get peering params
func (o *GetPeeringParams) WithID(id string) *GetPeeringParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the get peering params
func (o *GetPeeringParams) SetID(id string) {
	o.ID = id
}

// WithLocationOrganizationID adds the locationOrganizationID to the get peering params
func (o *GetPeeringParams) WithLocationOrganizationID(locationOrganizationID string) *GetPeeringParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get peering params
func (o *GetPeeringParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get peering params
func (o *GetPeeringParams) WithLocationProjectID(locationProjectID string) *GetPeeringParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get peering params
func (o *GetPeeringParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get peering params
func (o *GetPeeringParams) WithLocationRegionProvider(locationRegionProvider *string) *GetPeeringParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get peering params
func (o *GetPeeringParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get peering params
func (o *GetPeeringParams) WithLocationRegionRegion(locationRegionRegion *string) *GetPeeringParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get peering params
func (o *GetPeeringParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *GetPeeringParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param hvn_id
	if err := r.SetPathParam("hvn_id", o.HvnID); err != nil {
		return err
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
