// Code generated by go-swagger; DO NOT EDIT.

package vault_link_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-link-service/preview/2022-11-07/models"
)

// AuthenticateUserToClusterReader is a Reader for the AuthenticateUserToCluster structure.
type AuthenticateUserToClusterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AuthenticateUserToClusterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAuthenticateUserToClusterOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAuthenticateUserToClusterDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAuthenticateUserToClusterOK creates a AuthenticateUserToClusterOK with default headers values
func NewAuthenticateUserToClusterOK() *AuthenticateUserToClusterOK {
	return &AuthenticateUserToClusterOK{}
}

/*
AuthenticateUserToClusterOK describes a response with status code 200, with default header values.

A successful response.
*/
type AuthenticateUserToClusterOK struct {
	Payload *models.HashicorpCloudVaultLink20221107AuthenticateUserResponse
}

// IsSuccess returns true when this authenticate user to cluster o k response has a 2xx status code
func (o *AuthenticateUserToClusterOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this authenticate user to cluster o k response has a 3xx status code
func (o *AuthenticateUserToClusterOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this authenticate user to cluster o k response has a 4xx status code
func (o *AuthenticateUserToClusterOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this authenticate user to cluster o k response has a 5xx status code
func (o *AuthenticateUserToClusterOK) IsServerError() bool {
	return false
}

// IsCode returns true when this authenticate user to cluster o k response a status code equal to that given
func (o *AuthenticateUserToClusterOK) IsCode(code int) bool {
	return code == 200
}

func (o *AuthenticateUserToClusterOK) Error() string {
	return fmt.Sprintf("[POST /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/authenticate-user/{cluster_id}][%d] authenticateUserToClusterOK  %+v", 200, o.Payload)
}

func (o *AuthenticateUserToClusterOK) String() string {
	return fmt.Sprintf("[POST /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/authenticate-user/{cluster_id}][%d] authenticateUserToClusterOK  %+v", 200, o.Payload)
}

func (o *AuthenticateUserToClusterOK) GetPayload() *models.HashicorpCloudVaultLink20221107AuthenticateUserResponse {
	return o.Payload
}

func (o *AuthenticateUserToClusterOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVaultLink20221107AuthenticateUserResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuthenticateUserToClusterDefault creates a AuthenticateUserToClusterDefault with default headers values
func NewAuthenticateUserToClusterDefault(code int) *AuthenticateUserToClusterDefault {
	return &AuthenticateUserToClusterDefault{
		_statusCode: code,
	}
}

/*
AuthenticateUserToClusterDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type AuthenticateUserToClusterDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// Code gets the status code for the authenticate user to cluster default response
func (o *AuthenticateUserToClusterDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this authenticate user to cluster default response has a 2xx status code
func (o *AuthenticateUserToClusterDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this authenticate user to cluster default response has a 3xx status code
func (o *AuthenticateUserToClusterDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this authenticate user to cluster default response has a 4xx status code
func (o *AuthenticateUserToClusterDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this authenticate user to cluster default response has a 5xx status code
func (o *AuthenticateUserToClusterDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this authenticate user to cluster default response a status code equal to that given
func (o *AuthenticateUserToClusterDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *AuthenticateUserToClusterDefault) Error() string {
	return fmt.Sprintf("[POST /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/authenticate-user/{cluster_id}][%d] AuthenticateUserToCluster default  %+v", o._statusCode, o.Payload)
}

func (o *AuthenticateUserToClusterDefault) String() string {
	return fmt.Sprintf("[POST /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/authenticate-user/{cluster_id}][%d] AuthenticateUserToCluster default  %+v", o._statusCode, o.Payload)
}

func (o *AuthenticateUserToClusterDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *AuthenticateUserToClusterDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AuthenticateUserToClusterBody authenticate user to cluster body
swagger:model AuthenticateUserToClusterBody
*/
type AuthenticateUserToClusterBody struct {

	// auth type
	AuthType *models.HashicorpCloudVaultLink20221107AuthenticateUserRequestAuthType `json:"auth_type,omitempty"`

	// For LDAP/USERPASS this credential is a password. For TOKEN, this is a token.
	Credential string `json:"credential,omitempty"`

	// location
	Location *AuthenticateUserToClusterParamsBodyLocation `json:"location,omitempty"`

	// Path where the auth mount is located
	MountPath string `json:"mount_path,omitempty"`

	// namespace
	Namespace string `json:"namespace,omitempty"`

	// Username is used for LDAP/USERPASS
	Username string `json:"username,omitempty"`
}

// Validate validates this authenticate user to cluster body
func (o *AuthenticateUserToClusterBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAuthType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AuthenticateUserToClusterBody) validateAuthType(formats strfmt.Registry) error {
	if swag.IsZero(o.AuthType) { // not required
		return nil
	}

	if o.AuthType != nil {
		if err := o.AuthType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "auth_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "auth_type")
			}
			return err
		}
	}

	return nil
}

func (o *AuthenticateUserToClusterBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this authenticate user to cluster body based on the context it is used
func (o *AuthenticateUserToClusterBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAuthType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AuthenticateUserToClusterBody) contextValidateAuthType(ctx context.Context, formats strfmt.Registry) error {

	if o.AuthType != nil {
		if err := o.AuthType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "auth_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "auth_type")
			}
			return err
		}
	}

	return nil
}

func (o *AuthenticateUserToClusterBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {
		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AuthenticateUserToClusterBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AuthenticateUserToClusterBody) UnmarshalBinary(b []byte) error {
	var res AuthenticateUserToClusterBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AuthenticateUserToClusterParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model AuthenticateUserToClusterParamsBodyLocation
*/
type AuthenticateUserToClusterParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *cloud.HashicorpCloudLocationRegion `json:"region,omitempty"`
}

// Validate validates this authenticate user to cluster params body location
func (o *AuthenticateUserToClusterParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AuthenticateUserToClusterParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this authenticate user to cluster params body location based on the context it is used
func (o *AuthenticateUserToClusterParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AuthenticateUserToClusterParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {
		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AuthenticateUserToClusterParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AuthenticateUserToClusterParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res AuthenticateUserToClusterParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
