// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewOpenAppSecretVersionParams creates a new OpenAppSecretVersionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewOpenAppSecretVersionParams() *OpenAppSecretVersionParams {
	return &OpenAppSecretVersionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewOpenAppSecretVersionParamsWithTimeout creates a new OpenAppSecretVersionParams object
// with the ability to set a timeout on a request.
func NewOpenAppSecretVersionParamsWithTimeout(timeout time.Duration) *OpenAppSecretVersionParams {
	return &OpenAppSecretVersionParams{
		timeout: timeout,
	}
}

// NewOpenAppSecretVersionParamsWithContext creates a new OpenAppSecretVersionParams object
// with the ability to set a context for a request.
func NewOpenAppSecretVersionParamsWithContext(ctx context.Context) *OpenAppSecretVersionParams {
	return &OpenAppSecretVersionParams{
		Context: ctx,
	}
}

// NewOpenAppSecretVersionParamsWithHTTPClient creates a new OpenAppSecretVersionParams object
// with the ability to set a custom HTTPClient for a request.
func NewOpenAppSecretVersionParamsWithHTTPClient(client *http.Client) *OpenAppSecretVersionParams {
	return &OpenAppSecretVersionParams{
		HTTPClient: client,
	}
}

/*
OpenAppSecretVersionParams contains all the parameters to send to the API endpoint

	for the open app secret version operation.

	Typically these are written to a http.Request.
*/
type OpenAppSecretVersionParams struct {

	// AppName.
	AppName string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	// SecretName.
	SecretName string

	// Version.
	//
	// Format: int64
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the open app secret version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OpenAppSecretVersionParams) WithDefaults() *OpenAppSecretVersionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the open app secret version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OpenAppSecretVersionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the open app secret version params
func (o *OpenAppSecretVersionParams) WithTimeout(timeout time.Duration) *OpenAppSecretVersionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the open app secret version params
func (o *OpenAppSecretVersionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the open app secret version params
func (o *OpenAppSecretVersionParams) WithContext(ctx context.Context) *OpenAppSecretVersionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the open app secret version params
func (o *OpenAppSecretVersionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the open app secret version params
func (o *OpenAppSecretVersionParams) WithHTTPClient(client *http.Client) *OpenAppSecretVersionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the open app secret version params
func (o *OpenAppSecretVersionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the open app secret version params
func (o *OpenAppSecretVersionParams) WithAppName(appName string) *OpenAppSecretVersionParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the open app secret version params
func (o *OpenAppSecretVersionParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithLocationOrganizationID adds the locationOrganizationID to the open app secret version params
func (o *OpenAppSecretVersionParams) WithLocationOrganizationID(locationOrganizationID string) *OpenAppSecretVersionParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the open app secret version params
func (o *OpenAppSecretVersionParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the open app secret version params
func (o *OpenAppSecretVersionParams) WithLocationProjectID(locationProjectID string) *OpenAppSecretVersionParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the open app secret version params
func (o *OpenAppSecretVersionParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the open app secret version params
func (o *OpenAppSecretVersionParams) WithLocationRegionProvider(locationRegionProvider *string) *OpenAppSecretVersionParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the open app secret version params
func (o *OpenAppSecretVersionParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the open app secret version params
func (o *OpenAppSecretVersionParams) WithLocationRegionRegion(locationRegionRegion *string) *OpenAppSecretVersionParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the open app secret version params
func (o *OpenAppSecretVersionParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithSecretName adds the secretName to the open app secret version params
func (o *OpenAppSecretVersionParams) WithSecretName(secretName string) *OpenAppSecretVersionParams {
	o.SetSecretName(secretName)
	return o
}

// SetSecretName adds the secretName to the open app secret version params
func (o *OpenAppSecretVersionParams) SetSecretName(secretName string) {
	o.SecretName = secretName
}

// WithVersion adds the version to the open app secret version params
func (o *OpenAppSecretVersionParams) WithVersion(version string) *OpenAppSecretVersionParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the open app secret version params
func (o *OpenAppSecretVersionParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *OpenAppSecretVersionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	// path param secret_name
	if err := r.SetPathParam("secret_name", o.SecretName); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
