// Code generated by go-swagger; DO NOT EDIT.

package webhook_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-webhook/stable/2023-05-31/models"
)

// NewWebhookServiceCreateWebhookParams creates a new WebhookServiceCreateWebhookParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWebhookServiceCreateWebhookParams() *WebhookServiceCreateWebhookParams {
	return &WebhookServiceCreateWebhookParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWebhookServiceCreateWebhookParamsWithTimeout creates a new WebhookServiceCreateWebhookParams object
// with the ability to set a timeout on a request.
func NewWebhookServiceCreateWebhookParamsWithTimeout(timeout time.Duration) *WebhookServiceCreateWebhookParams {
	return &WebhookServiceCreateWebhookParams{
		timeout: timeout,
	}
}

// NewWebhookServiceCreateWebhookParamsWithContext creates a new WebhookServiceCreateWebhookParams object
// with the ability to set a context for a request.
func NewWebhookServiceCreateWebhookParamsWithContext(ctx context.Context) *WebhookServiceCreateWebhookParams {
	return &WebhookServiceCreateWebhookParams{
		Context: ctx,
	}
}

// NewWebhookServiceCreateWebhookParamsWithHTTPClient creates a new WebhookServiceCreateWebhookParams object
// with the ability to set a custom HTTPClient for a request.
func NewWebhookServiceCreateWebhookParamsWithHTTPClient(client *http.Client) *WebhookServiceCreateWebhookParams {
	return &WebhookServiceCreateWebhookParams{
		HTTPClient: client,
	}
}

/*
WebhookServiceCreateWebhookParams contains all the parameters to send to the API endpoint

	for the webhook service create webhook operation.

	Typically these are written to a http.Request.
*/
type WebhookServiceCreateWebhookParams struct {

	/* Body.

	   The information to create a webhook.
	*/
	Body *models.HashicorpCloudWebhookCreateWebhookRequestBody

	/* ParentResourceName.

	   The parent resource of a webhook is an HCP project. A project's resource name format is `project/<project-id>`.
	*/
	ParentResourceName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the webhook service create webhook params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebhookServiceCreateWebhookParams) WithDefaults() *WebhookServiceCreateWebhookParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the webhook service create webhook params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebhookServiceCreateWebhookParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the webhook service create webhook params
func (o *WebhookServiceCreateWebhookParams) WithTimeout(timeout time.Duration) *WebhookServiceCreateWebhookParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the webhook service create webhook params
func (o *WebhookServiceCreateWebhookParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the webhook service create webhook params
func (o *WebhookServiceCreateWebhookParams) WithContext(ctx context.Context) *WebhookServiceCreateWebhookParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the webhook service create webhook params
func (o *WebhookServiceCreateWebhookParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the webhook service create webhook params
func (o *WebhookServiceCreateWebhookParams) WithHTTPClient(client *http.Client) *WebhookServiceCreateWebhookParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the webhook service create webhook params
func (o *WebhookServiceCreateWebhookParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the webhook service create webhook params
func (o *WebhookServiceCreateWebhookParams) WithBody(body *models.HashicorpCloudWebhookCreateWebhookRequestBody) *WebhookServiceCreateWebhookParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the webhook service create webhook params
func (o *WebhookServiceCreateWebhookParams) SetBody(body *models.HashicorpCloudWebhookCreateWebhookRequestBody) {
	o.Body = body
}

// WithParentResourceName adds the parentResourceName to the webhook service create webhook params
func (o *WebhookServiceCreateWebhookParams) WithParentResourceName(parentResourceName string) *WebhookServiceCreateWebhookParams {
	o.SetParentResourceName(parentResourceName)
	return o
}

// SetParentResourceName adds the parentResourceName to the webhook service create webhook params
func (o *WebhookServiceCreateWebhookParams) SetParentResourceName(parentResourceName string) {
	o.ParentResourceName = parentResourceName
}

// WriteToRequest writes these params to a swagger request
func (o *WebhookServiceCreateWebhookParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param parent_resource_name
	if err := r.SetPathParam("parent_resource_name", o.ParentResourceName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
