/*****************************************************************************
 * VLCMain.h: MacOS X interface module
 *****************************************************************************
 * Copyright (C) 2002-2019 VLC authors and VideoLAN
 *
 * Authors: Derk-Jan Hartman <hartman at videolan dot org>
 *          Felix Paul Kühne <fkuehne at videolan dot org>
 *          David Fuhrmann <david dot fuhrmann at googlemail dot com>
 *          Pierre d'Herbemont <pdherbemont # videolan org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

#ifdef HAVE_CONFIG_H
#   include "config.h"
#endif

#import <Cocoa/Cocoa.h>
#import <MetalKit/MetalKit.h>

#import <vlc_common.h>
#import <vlc_interface.h>

/*****************************************************************************
 * Local prototypes.
 *****************************************************************************/

typedef struct vlc_preparser_t vlc_preparser_t;

intf_thread_t *getIntf(void);
vlc_preparser_t *getNetworkPreparser();

extern NSString *VLCConfigurationChangedNotification;
extern NSString * const kVLCPreferencesVersion;

/*****************************************************************************
 * VLCMain interface
 *****************************************************************************/
@class VLCExtensionsManager;
@class VLCMainMenu;
@class VLCSimplePrefsController;
@class VLCPrefs;
@class VLCCoreDialogProvider;
@class VLCBookmarksWindowController;
@class VLCOpenWindowController;
@class VLCLogWindowController;
@class VLCLibraryWindow;
@class VLCLibraryWindowController;
@class VLCTrackSynchronizationWindowController;
@class VLCAudioEffectsWindowController;
@class VLCVideoEffectsWindowController;
@class VLCConvertAndSaveWindowController;
@class VLCLibraryController;
@class VLCPlayQueueController;
@class VLCVideoOutputProvider;
@class VLCDetachedAudioWindow;

@interface VLCMain : NSObject

@property (class, readonly) VLCMain *sharedInstance;
+ (void)relaunchApplication;

@property (readonly) BOOL isTerminating;

@property (readonly) VLCAudioEffectsWindowController *audioEffectsPanel;
@property (readonly) VLCBookmarksWindowController *bookmarks;
@property (readonly) VLCConvertAndSaveWindowController *convertAndSaveWindow;
@property (readonly) VLCCoreDialogProvider *coreDialogProvider;
@property (readonly) VLCExtensionsManager *extensionsManager;
@property (readonly) VLCLogWindowController *debugMsgPanel;
@property (readonly) VLCLibraryController *libraryController;
@property (readonly) VLCLibraryWindow *libraryWindow;
@property (readwrite) VLCLibraryWindowController *libraryWindowController;
@property (readonly) VLCMainMenu *mainMenu;
@property (readonly) VLCOpenWindowController *open;
@property (readonly) VLCPlayQueueController *playQueueController;
@property (readonly) VLCPrefs *preferences;
@property (readonly) VLCSimplePrefsController *simplePreferences;
@property (readonly) VLCTrackSynchronizationWindowController *trackSyncPanel;
@property (readonly) VLCVideoEffectsWindowController *videoEffectsPanel;
@property (readonly) VLCVideoOutputProvider *voutProvider;
@property (readonly) VLCDetachedAudioWindow *detachedAudioWindow;
@property (readonly) id<MTLDevice> metalDevice;
@property (readonly) id<MTLLibrary> metalLibrary;

@end
