/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CreateAuthMethodHuawei createAuthMethodHuawei is a command that creates a new auth method that will be able to authenticate using Huawei credentials.
type CreateAuthMethodHuawei struct {
	// Access expiration date in Unix timestamp (select 0 for access without expiry date)
	AccessExpires *int64 `json:"access-expires,omitempty"`
	// Subclaims to include in audit logs, e.g \"--audit-logs-claims email --audit-logs-claims username\"
	AuditLogsClaims *[]string `json:"audit-logs-claims,omitempty"`
	// sts URL
	AuthUrl *string `json:"auth-url,omitempty"`
	// A list of domain IDs that the access is restricted to
	BoundDomainId *[]string `json:"bound-domain-id,omitempty"`
	// A list of domain names that the access is restricted to
	BoundDomainName *[]string `json:"bound-domain-name,omitempty"`
	// A CIDR whitelist with the IPs that the access is restricted to
	BoundIps *[]string `json:"bound-ips,omitempty"`
	// A list of full tenant ids that the access is restricted to
	BoundTenantId *[]string `json:"bound-tenant-id,omitempty"`
	// A list of full tenant names that the access is restricted to
	BoundTenantName *[]string `json:"bound-tenant-name,omitempty"`
	// A list of full user ids that the access is restricted to
	BoundUserId *[]string `json:"bound-user-id,omitempty"`
	// A list of full user-name that the access is restricted to
	BoundUserName *[]string `json:"bound-user-name,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Auth Method description
	Description *string `json:"description,omitempty"`
	// if true: enforce role-association must include sub claims
	ForceSubClaims *bool `json:"force-sub-claims,omitempty"`
	// A CIDR whitelist with the GW IPs that the access is restricted to
	GwBoundIps *[]string `json:"gw-bound-ips,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Jwt TTL
	JwtTtl *int64 `json:"jwt-ttl,omitempty"`
	// Auth Method name
	Name string `json:"name"`
	// Choose the relevant product type for the auth method [sm, sra, pm, dp, ca]
	ProductType *[]string `json:"product-type,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewCreateAuthMethodHuawei instantiates a new CreateAuthMethodHuawei object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateAuthMethodHuawei(name string, ) *CreateAuthMethodHuawei {
	this := CreateAuthMethodHuawei{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	var authUrl string = "https://iam.myhwclouds.com:443/v3"
	this.AuthUrl = &authUrl
	var json bool = false
	this.Json = &json
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	this.Name = name
	return &this
}

// NewCreateAuthMethodHuaweiWithDefaults instantiates a new CreateAuthMethodHuawei object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateAuthMethodHuaweiWithDefaults() *CreateAuthMethodHuawei {
	this := CreateAuthMethodHuawei{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	var authUrl string = "https://iam.myhwclouds.com:443/v3"
	this.AuthUrl = &authUrl
	var json bool = false
	this.Json = &json
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	return &this
}

// GetAccessExpires returns the AccessExpires field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetAccessExpires() int64 {
	if o == nil || o.AccessExpires == nil {
		var ret int64
		return ret
	}
	return *o.AccessExpires
}

// GetAccessExpiresOk returns a tuple with the AccessExpires field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetAccessExpiresOk() (*int64, bool) {
	if o == nil || o.AccessExpires == nil {
		return nil, false
	}
	return o.AccessExpires, true
}

// HasAccessExpires returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasAccessExpires() bool {
	if o != nil && o.AccessExpires != nil {
		return true
	}

	return false
}

// SetAccessExpires gets a reference to the given int64 and assigns it to the AccessExpires field.
func (o *CreateAuthMethodHuawei) SetAccessExpires(v int64) {
	o.AccessExpires = &v
}

// GetAuditLogsClaims returns the AuditLogsClaims field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetAuditLogsClaims() []string {
	if o == nil || o.AuditLogsClaims == nil {
		var ret []string
		return ret
	}
	return *o.AuditLogsClaims
}

// GetAuditLogsClaimsOk returns a tuple with the AuditLogsClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetAuditLogsClaimsOk() (*[]string, bool) {
	if o == nil || o.AuditLogsClaims == nil {
		return nil, false
	}
	return o.AuditLogsClaims, true
}

// HasAuditLogsClaims returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasAuditLogsClaims() bool {
	if o != nil && o.AuditLogsClaims != nil {
		return true
	}

	return false
}

// SetAuditLogsClaims gets a reference to the given []string and assigns it to the AuditLogsClaims field.
func (o *CreateAuthMethodHuawei) SetAuditLogsClaims(v []string) {
	o.AuditLogsClaims = &v
}

// GetAuthUrl returns the AuthUrl field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetAuthUrl() string {
	if o == nil || o.AuthUrl == nil {
		var ret string
		return ret
	}
	return *o.AuthUrl
}

// GetAuthUrlOk returns a tuple with the AuthUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetAuthUrlOk() (*string, bool) {
	if o == nil || o.AuthUrl == nil {
		return nil, false
	}
	return o.AuthUrl, true
}

// HasAuthUrl returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasAuthUrl() bool {
	if o != nil && o.AuthUrl != nil {
		return true
	}

	return false
}

// SetAuthUrl gets a reference to the given string and assigns it to the AuthUrl field.
func (o *CreateAuthMethodHuawei) SetAuthUrl(v string) {
	o.AuthUrl = &v
}

// GetBoundDomainId returns the BoundDomainId field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetBoundDomainId() []string {
	if o == nil || o.BoundDomainId == nil {
		var ret []string
		return ret
	}
	return *o.BoundDomainId
}

// GetBoundDomainIdOk returns a tuple with the BoundDomainId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetBoundDomainIdOk() (*[]string, bool) {
	if o == nil || o.BoundDomainId == nil {
		return nil, false
	}
	return o.BoundDomainId, true
}

// HasBoundDomainId returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasBoundDomainId() bool {
	if o != nil && o.BoundDomainId != nil {
		return true
	}

	return false
}

// SetBoundDomainId gets a reference to the given []string and assigns it to the BoundDomainId field.
func (o *CreateAuthMethodHuawei) SetBoundDomainId(v []string) {
	o.BoundDomainId = &v
}

// GetBoundDomainName returns the BoundDomainName field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetBoundDomainName() []string {
	if o == nil || o.BoundDomainName == nil {
		var ret []string
		return ret
	}
	return *o.BoundDomainName
}

// GetBoundDomainNameOk returns a tuple with the BoundDomainName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetBoundDomainNameOk() (*[]string, bool) {
	if o == nil || o.BoundDomainName == nil {
		return nil, false
	}
	return o.BoundDomainName, true
}

// HasBoundDomainName returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasBoundDomainName() bool {
	if o != nil && o.BoundDomainName != nil {
		return true
	}

	return false
}

// SetBoundDomainName gets a reference to the given []string and assigns it to the BoundDomainName field.
func (o *CreateAuthMethodHuawei) SetBoundDomainName(v []string) {
	o.BoundDomainName = &v
}

// GetBoundIps returns the BoundIps field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetBoundIps() []string {
	if o == nil || o.BoundIps == nil {
		var ret []string
		return ret
	}
	return *o.BoundIps
}

// GetBoundIpsOk returns a tuple with the BoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetBoundIpsOk() (*[]string, bool) {
	if o == nil || o.BoundIps == nil {
		return nil, false
	}
	return o.BoundIps, true
}

// HasBoundIps returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasBoundIps() bool {
	if o != nil && o.BoundIps != nil {
		return true
	}

	return false
}

// SetBoundIps gets a reference to the given []string and assigns it to the BoundIps field.
func (o *CreateAuthMethodHuawei) SetBoundIps(v []string) {
	o.BoundIps = &v
}

// GetBoundTenantId returns the BoundTenantId field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetBoundTenantId() []string {
	if o == nil || o.BoundTenantId == nil {
		var ret []string
		return ret
	}
	return *o.BoundTenantId
}

// GetBoundTenantIdOk returns a tuple with the BoundTenantId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetBoundTenantIdOk() (*[]string, bool) {
	if o == nil || o.BoundTenantId == nil {
		return nil, false
	}
	return o.BoundTenantId, true
}

// HasBoundTenantId returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasBoundTenantId() bool {
	if o != nil && o.BoundTenantId != nil {
		return true
	}

	return false
}

// SetBoundTenantId gets a reference to the given []string and assigns it to the BoundTenantId field.
func (o *CreateAuthMethodHuawei) SetBoundTenantId(v []string) {
	o.BoundTenantId = &v
}

// GetBoundTenantName returns the BoundTenantName field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetBoundTenantName() []string {
	if o == nil || o.BoundTenantName == nil {
		var ret []string
		return ret
	}
	return *o.BoundTenantName
}

// GetBoundTenantNameOk returns a tuple with the BoundTenantName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetBoundTenantNameOk() (*[]string, bool) {
	if o == nil || o.BoundTenantName == nil {
		return nil, false
	}
	return o.BoundTenantName, true
}

// HasBoundTenantName returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasBoundTenantName() bool {
	if o != nil && o.BoundTenantName != nil {
		return true
	}

	return false
}

// SetBoundTenantName gets a reference to the given []string and assigns it to the BoundTenantName field.
func (o *CreateAuthMethodHuawei) SetBoundTenantName(v []string) {
	o.BoundTenantName = &v
}

// GetBoundUserId returns the BoundUserId field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetBoundUserId() []string {
	if o == nil || o.BoundUserId == nil {
		var ret []string
		return ret
	}
	return *o.BoundUserId
}

// GetBoundUserIdOk returns a tuple with the BoundUserId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetBoundUserIdOk() (*[]string, bool) {
	if o == nil || o.BoundUserId == nil {
		return nil, false
	}
	return o.BoundUserId, true
}

// HasBoundUserId returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasBoundUserId() bool {
	if o != nil && o.BoundUserId != nil {
		return true
	}

	return false
}

// SetBoundUserId gets a reference to the given []string and assigns it to the BoundUserId field.
func (o *CreateAuthMethodHuawei) SetBoundUserId(v []string) {
	o.BoundUserId = &v
}

// GetBoundUserName returns the BoundUserName field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetBoundUserName() []string {
	if o == nil || o.BoundUserName == nil {
		var ret []string
		return ret
	}
	return *o.BoundUserName
}

// GetBoundUserNameOk returns a tuple with the BoundUserName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetBoundUserNameOk() (*[]string, bool) {
	if o == nil || o.BoundUserName == nil {
		return nil, false
	}
	return o.BoundUserName, true
}

// HasBoundUserName returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasBoundUserName() bool {
	if o != nil && o.BoundUserName != nil {
		return true
	}

	return false
}

// SetBoundUserName gets a reference to the given []string and assigns it to the BoundUserName field.
func (o *CreateAuthMethodHuawei) SetBoundUserName(v []string) {
	o.BoundUserName = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *CreateAuthMethodHuawei) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *CreateAuthMethodHuawei) SetDescription(v string) {
	o.Description = &v
}

// GetForceSubClaims returns the ForceSubClaims field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetForceSubClaims() bool {
	if o == nil || o.ForceSubClaims == nil {
		var ret bool
		return ret
	}
	return *o.ForceSubClaims
}

// GetForceSubClaimsOk returns a tuple with the ForceSubClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetForceSubClaimsOk() (*bool, bool) {
	if o == nil || o.ForceSubClaims == nil {
		return nil, false
	}
	return o.ForceSubClaims, true
}

// HasForceSubClaims returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasForceSubClaims() bool {
	if o != nil && o.ForceSubClaims != nil {
		return true
	}

	return false
}

// SetForceSubClaims gets a reference to the given bool and assigns it to the ForceSubClaims field.
func (o *CreateAuthMethodHuawei) SetForceSubClaims(v bool) {
	o.ForceSubClaims = &v
}

// GetGwBoundIps returns the GwBoundIps field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetGwBoundIps() []string {
	if o == nil || o.GwBoundIps == nil {
		var ret []string
		return ret
	}
	return *o.GwBoundIps
}

// GetGwBoundIpsOk returns a tuple with the GwBoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetGwBoundIpsOk() (*[]string, bool) {
	if o == nil || o.GwBoundIps == nil {
		return nil, false
	}
	return o.GwBoundIps, true
}

// HasGwBoundIps returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasGwBoundIps() bool {
	if o != nil && o.GwBoundIps != nil {
		return true
	}

	return false
}

// SetGwBoundIps gets a reference to the given []string and assigns it to the GwBoundIps field.
func (o *CreateAuthMethodHuawei) SetGwBoundIps(v []string) {
	o.GwBoundIps = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *CreateAuthMethodHuawei) SetJson(v bool) {
	o.Json = &v
}

// GetJwtTtl returns the JwtTtl field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetJwtTtl() int64 {
	if o == nil || o.JwtTtl == nil {
		var ret int64
		return ret
	}
	return *o.JwtTtl
}

// GetJwtTtlOk returns a tuple with the JwtTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetJwtTtlOk() (*int64, bool) {
	if o == nil || o.JwtTtl == nil {
		return nil, false
	}
	return o.JwtTtl, true
}

// HasJwtTtl returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasJwtTtl() bool {
	if o != nil && o.JwtTtl != nil {
		return true
	}

	return false
}

// SetJwtTtl gets a reference to the given int64 and assigns it to the JwtTtl field.
func (o *CreateAuthMethodHuawei) SetJwtTtl(v int64) {
	o.JwtTtl = &v
}

// GetName returns the Name field value
func (o *CreateAuthMethodHuawei) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CreateAuthMethodHuawei) SetName(v string) {
	o.Name = v
}

// GetProductType returns the ProductType field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetProductType() []string {
	if o == nil || o.ProductType == nil {
		var ret []string
		return ret
	}
	return *o.ProductType
}

// GetProductTypeOk returns a tuple with the ProductType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetProductTypeOk() (*[]string, bool) {
	if o == nil || o.ProductType == nil {
		return nil, false
	}
	return o.ProductType, true
}

// HasProductType returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasProductType() bool {
	if o != nil && o.ProductType != nil {
		return true
	}

	return false
}

// SetProductType gets a reference to the given []string and assigns it to the ProductType field.
func (o *CreateAuthMethodHuawei) SetProductType(v []string) {
	o.ProductType = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *CreateAuthMethodHuawei) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *CreateAuthMethodHuawei) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodHuawei) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *CreateAuthMethodHuawei) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *CreateAuthMethodHuawei) SetUidToken(v string) {
	o.UidToken = &v
}

func (o CreateAuthMethodHuawei) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessExpires != nil {
		toSerialize["access-expires"] = o.AccessExpires
	}
	if o.AuditLogsClaims != nil {
		toSerialize["audit-logs-claims"] = o.AuditLogsClaims
	}
	if o.AuthUrl != nil {
		toSerialize["auth-url"] = o.AuthUrl
	}
	if o.BoundDomainId != nil {
		toSerialize["bound-domain-id"] = o.BoundDomainId
	}
	if o.BoundDomainName != nil {
		toSerialize["bound-domain-name"] = o.BoundDomainName
	}
	if o.BoundIps != nil {
		toSerialize["bound-ips"] = o.BoundIps
	}
	if o.BoundTenantId != nil {
		toSerialize["bound-tenant-id"] = o.BoundTenantId
	}
	if o.BoundTenantName != nil {
		toSerialize["bound-tenant-name"] = o.BoundTenantName
	}
	if o.BoundUserId != nil {
		toSerialize["bound-user-id"] = o.BoundUserId
	}
	if o.BoundUserName != nil {
		toSerialize["bound-user-name"] = o.BoundUserName
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.ForceSubClaims != nil {
		toSerialize["force-sub-claims"] = o.ForceSubClaims
	}
	if o.GwBoundIps != nil {
		toSerialize["gw-bound-ips"] = o.GwBoundIps
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.JwtTtl != nil {
		toSerialize["jwt-ttl"] = o.JwtTtl
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.ProductType != nil {
		toSerialize["product-type"] = o.ProductType
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableCreateAuthMethodHuawei struct {
	value *CreateAuthMethodHuawei
	isSet bool
}

func (v NullableCreateAuthMethodHuawei) Get() *CreateAuthMethodHuawei {
	return v.value
}

func (v *NullableCreateAuthMethodHuawei) Set(val *CreateAuthMethodHuawei) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateAuthMethodHuawei) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateAuthMethodHuawei) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateAuthMethodHuawei(val *CreateAuthMethodHuawei) *NullableCreateAuthMethodHuawei {
	return &NullableCreateAuthMethodHuawei{value: val, isSet: true}
}

func (v NullableCreateAuthMethodHuawei) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateAuthMethodHuawei) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


