/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// Decrypt decrypt is a command that decrypts ciphertext into plaintext by using an AES key.
type Decrypt struct {
	// Ciphertext to be decrypted in base64 encoded format
	Ciphertext *string `json:"ciphertext,omitempty"`
	// The display id of the key to use in the decryption process
	DisplayId *string `json:"display-id,omitempty"`
	// The encryption context. If this was specified in the encrypt command, it must be specified here or the decryption operation will fail
	EncryptionContext *map[string]string `json:"encryption-context,omitempty"`
	// The item id of the key to use in the decryption process
	ItemId *int64 `json:"item-id,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of the key to use in the decryption process
	KeyName string `json:"key-name"`
	// If specified, the output will be formatted accordingly. options: [base64]
	OutputFormat *string `json:"output-format,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// key version (relevant only for classic key)
	Version *int32 `json:"version,omitempty"`
}

// NewDecrypt instantiates a new Decrypt object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDecrypt(keyName string, ) *Decrypt {
	this := Decrypt{}
	var json bool = false
	this.Json = &json
	this.KeyName = keyName
	return &this
}

// NewDecryptWithDefaults instantiates a new Decrypt object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDecryptWithDefaults() *Decrypt {
	this := Decrypt{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetCiphertext returns the Ciphertext field value if set, zero value otherwise.
func (o *Decrypt) GetCiphertext() string {
	if o == nil || o.Ciphertext == nil {
		var ret string
		return ret
	}
	return *o.Ciphertext
}

// GetCiphertextOk returns a tuple with the Ciphertext field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Decrypt) GetCiphertextOk() (*string, bool) {
	if o == nil || o.Ciphertext == nil {
		return nil, false
	}
	return o.Ciphertext, true
}

// HasCiphertext returns a boolean if a field has been set.
func (o *Decrypt) HasCiphertext() bool {
	if o != nil && o.Ciphertext != nil {
		return true
	}

	return false
}

// SetCiphertext gets a reference to the given string and assigns it to the Ciphertext field.
func (o *Decrypt) SetCiphertext(v string) {
	o.Ciphertext = &v
}

// GetDisplayId returns the DisplayId field value if set, zero value otherwise.
func (o *Decrypt) GetDisplayId() string {
	if o == nil || o.DisplayId == nil {
		var ret string
		return ret
	}
	return *o.DisplayId
}

// GetDisplayIdOk returns a tuple with the DisplayId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Decrypt) GetDisplayIdOk() (*string, bool) {
	if o == nil || o.DisplayId == nil {
		return nil, false
	}
	return o.DisplayId, true
}

// HasDisplayId returns a boolean if a field has been set.
func (o *Decrypt) HasDisplayId() bool {
	if o != nil && o.DisplayId != nil {
		return true
	}

	return false
}

// SetDisplayId gets a reference to the given string and assigns it to the DisplayId field.
func (o *Decrypt) SetDisplayId(v string) {
	o.DisplayId = &v
}

// GetEncryptionContext returns the EncryptionContext field value if set, zero value otherwise.
func (o *Decrypt) GetEncryptionContext() map[string]string {
	if o == nil || o.EncryptionContext == nil {
		var ret map[string]string
		return ret
	}
	return *o.EncryptionContext
}

// GetEncryptionContextOk returns a tuple with the EncryptionContext field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Decrypt) GetEncryptionContextOk() (*map[string]string, bool) {
	if o == nil || o.EncryptionContext == nil {
		return nil, false
	}
	return o.EncryptionContext, true
}

// HasEncryptionContext returns a boolean if a field has been set.
func (o *Decrypt) HasEncryptionContext() bool {
	if o != nil && o.EncryptionContext != nil {
		return true
	}

	return false
}

// SetEncryptionContext gets a reference to the given map[string]string and assigns it to the EncryptionContext field.
func (o *Decrypt) SetEncryptionContext(v map[string]string) {
	o.EncryptionContext = &v
}

// GetItemId returns the ItemId field value if set, zero value otherwise.
func (o *Decrypt) GetItemId() int64 {
	if o == nil || o.ItemId == nil {
		var ret int64
		return ret
	}
	return *o.ItemId
}

// GetItemIdOk returns a tuple with the ItemId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Decrypt) GetItemIdOk() (*int64, bool) {
	if o == nil || o.ItemId == nil {
		return nil, false
	}
	return o.ItemId, true
}

// HasItemId returns a boolean if a field has been set.
func (o *Decrypt) HasItemId() bool {
	if o != nil && o.ItemId != nil {
		return true
	}

	return false
}

// SetItemId gets a reference to the given int64 and assigns it to the ItemId field.
func (o *Decrypt) SetItemId(v int64) {
	o.ItemId = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *Decrypt) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Decrypt) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *Decrypt) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *Decrypt) SetJson(v bool) {
	o.Json = &v
}

// GetKeyName returns the KeyName field value
func (o *Decrypt) GetKeyName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.KeyName
}

// GetKeyNameOk returns a tuple with the KeyName field value
// and a boolean to check if the value has been set.
func (o *Decrypt) GetKeyNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.KeyName, true
}

// SetKeyName sets field value
func (o *Decrypt) SetKeyName(v string) {
	o.KeyName = v
}

// GetOutputFormat returns the OutputFormat field value if set, zero value otherwise.
func (o *Decrypt) GetOutputFormat() string {
	if o == nil || o.OutputFormat == nil {
		var ret string
		return ret
	}
	return *o.OutputFormat
}

// GetOutputFormatOk returns a tuple with the OutputFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Decrypt) GetOutputFormatOk() (*string, bool) {
	if o == nil || o.OutputFormat == nil {
		return nil, false
	}
	return o.OutputFormat, true
}

// HasOutputFormat returns a boolean if a field has been set.
func (o *Decrypt) HasOutputFormat() bool {
	if o != nil && o.OutputFormat != nil {
		return true
	}

	return false
}

// SetOutputFormat gets a reference to the given string and assigns it to the OutputFormat field.
func (o *Decrypt) SetOutputFormat(v string) {
	o.OutputFormat = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *Decrypt) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Decrypt) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *Decrypt) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *Decrypt) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *Decrypt) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Decrypt) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *Decrypt) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *Decrypt) SetUidToken(v string) {
	o.UidToken = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *Decrypt) GetVersion() int32 {
	if o == nil || o.Version == nil {
		var ret int32
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Decrypt) GetVersionOk() (*int32, bool) {
	if o == nil || o.Version == nil {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *Decrypt) HasVersion() bool {
	if o != nil && o.Version != nil {
		return true
	}

	return false
}

// SetVersion gets a reference to the given int32 and assigns it to the Version field.
func (o *Decrypt) SetVersion(v int32) {
	o.Version = &v
}

func (o Decrypt) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Ciphertext != nil {
		toSerialize["ciphertext"] = o.Ciphertext
	}
	if o.DisplayId != nil {
		toSerialize["display-id"] = o.DisplayId
	}
	if o.EncryptionContext != nil {
		toSerialize["encryption-context"] = o.EncryptionContext
	}
	if o.ItemId != nil {
		toSerialize["item-id"] = o.ItemId
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["key-name"] = o.KeyName
	}
	if o.OutputFormat != nil {
		toSerialize["output-format"] = o.OutputFormat
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.Version != nil {
		toSerialize["version"] = o.Version
	}
	return json.Marshal(toSerialize)
}

type NullableDecrypt struct {
	value *Decrypt
	isSet bool
}

func (v NullableDecrypt) Get() *Decrypt {
	return v.value
}

func (v *NullableDecrypt) Set(val *Decrypt) {
	v.value = val
	v.isSet = true
}

func (v NullableDecrypt) IsSet() bool {
	return v.isSet
}

func (v *NullableDecrypt) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDecrypt(val *Decrypt) *NullableDecrypt {
	return &NullableDecrypt{value: val, isSet: true}
}

func (v NullableDecrypt) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDecrypt) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


