/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GwUpdateRemoteAccessSessionLogsDatadog gwUpdateRemoteAccessSessionLogsDatadog is a command that updates session log forwarding config (datadog target)
type GwUpdateRemoteAccessSessionLogsDatadog struct {
	// Datadog api key
	ApiKey *string `json:"api-key,omitempty"`
	// Enable Log Forwarding [true/false]
	Enable *string `json:"enable,omitempty"`
	// Datadog host
	Host *string `json:"host,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Datadog log service
	LogService *string `json:"log-service,omitempty"`
	// Datadog log source
	LogSource *string `json:"log-source,omitempty"`
	// A comma-separated list of Datadog log tags formatted as \"key:value\" strings
	LogTags *string `json:"log-tags,omitempty"`
	// Logs format [text/json]
	OutputFormat *string `json:"output-format,omitempty"`
	// Pull interval in seconds
	PullInterval *string `json:"pull-interval,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGwUpdateRemoteAccessSessionLogsDatadog instantiates a new GwUpdateRemoteAccessSessionLogsDatadog object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGwUpdateRemoteAccessSessionLogsDatadog() *GwUpdateRemoteAccessSessionLogsDatadog {
	this := GwUpdateRemoteAccessSessionLogsDatadog{}
	var enable string = "true"
	this.Enable = &enable
	var json bool = false
	this.Json = &json
	var logService string = "use-existing"
	this.LogService = &logService
	var logSource string = "use-existing"
	this.LogSource = &logSource
	var logTags string = "use-existing"
	this.LogTags = &logTags
	var outputFormat string = "text"
	this.OutputFormat = &outputFormat
	var pullInterval string = "10"
	this.PullInterval = &pullInterval
	return &this
}

// NewGwUpdateRemoteAccessSessionLogsDatadogWithDefaults instantiates a new GwUpdateRemoteAccessSessionLogsDatadog object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGwUpdateRemoteAccessSessionLogsDatadogWithDefaults() *GwUpdateRemoteAccessSessionLogsDatadog {
	this := GwUpdateRemoteAccessSessionLogsDatadog{}
	var enable string = "true"
	this.Enable = &enable
	var json bool = false
	this.Json = &json
	var logService string = "use-existing"
	this.LogService = &logService
	var logSource string = "use-existing"
	this.LogSource = &logSource
	var logTags string = "use-existing"
	this.LogTags = &logTags
	var outputFormat string = "text"
	this.OutputFormat = &outputFormat
	var pullInterval string = "10"
	this.PullInterval = &pullInterval
	return &this
}

// GetApiKey returns the ApiKey field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetApiKey() string {
	if o == nil || o.ApiKey == nil {
		var ret string
		return ret
	}
	return *o.ApiKey
}

// GetApiKeyOk returns a tuple with the ApiKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetApiKeyOk() (*string, bool) {
	if o == nil || o.ApiKey == nil {
		return nil, false
	}
	return o.ApiKey, true
}

// HasApiKey returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) HasApiKey() bool {
	if o != nil && o.ApiKey != nil {
		return true
	}

	return false
}

// SetApiKey gets a reference to the given string and assigns it to the ApiKey field.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) SetApiKey(v string) {
	o.ApiKey = &v
}

// GetEnable returns the Enable field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetEnable() string {
	if o == nil || o.Enable == nil {
		var ret string
		return ret
	}
	return *o.Enable
}

// GetEnableOk returns a tuple with the Enable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetEnableOk() (*string, bool) {
	if o == nil || o.Enable == nil {
		return nil, false
	}
	return o.Enable, true
}

// HasEnable returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) HasEnable() bool {
	if o != nil && o.Enable != nil {
		return true
	}

	return false
}

// SetEnable gets a reference to the given string and assigns it to the Enable field.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) SetEnable(v string) {
	o.Enable = &v
}

// GetHost returns the Host field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetHost() string {
	if o == nil || o.Host == nil {
		var ret string
		return ret
	}
	return *o.Host
}

// GetHostOk returns a tuple with the Host field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetHostOk() (*string, bool) {
	if o == nil || o.Host == nil {
		return nil, false
	}
	return o.Host, true
}

// HasHost returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) HasHost() bool {
	if o != nil && o.Host != nil {
		return true
	}

	return false
}

// SetHost gets a reference to the given string and assigns it to the Host field.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) SetHost(v string) {
	o.Host = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) SetJson(v bool) {
	o.Json = &v
}

// GetLogService returns the LogService field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetLogService() string {
	if o == nil || o.LogService == nil {
		var ret string
		return ret
	}
	return *o.LogService
}

// GetLogServiceOk returns a tuple with the LogService field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetLogServiceOk() (*string, bool) {
	if o == nil || o.LogService == nil {
		return nil, false
	}
	return o.LogService, true
}

// HasLogService returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) HasLogService() bool {
	if o != nil && o.LogService != nil {
		return true
	}

	return false
}

// SetLogService gets a reference to the given string and assigns it to the LogService field.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) SetLogService(v string) {
	o.LogService = &v
}

// GetLogSource returns the LogSource field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetLogSource() string {
	if o == nil || o.LogSource == nil {
		var ret string
		return ret
	}
	return *o.LogSource
}

// GetLogSourceOk returns a tuple with the LogSource field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetLogSourceOk() (*string, bool) {
	if o == nil || o.LogSource == nil {
		return nil, false
	}
	return o.LogSource, true
}

// HasLogSource returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) HasLogSource() bool {
	if o != nil && o.LogSource != nil {
		return true
	}

	return false
}

// SetLogSource gets a reference to the given string and assigns it to the LogSource field.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) SetLogSource(v string) {
	o.LogSource = &v
}

// GetLogTags returns the LogTags field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetLogTags() string {
	if o == nil || o.LogTags == nil {
		var ret string
		return ret
	}
	return *o.LogTags
}

// GetLogTagsOk returns a tuple with the LogTags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetLogTagsOk() (*string, bool) {
	if o == nil || o.LogTags == nil {
		return nil, false
	}
	return o.LogTags, true
}

// HasLogTags returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) HasLogTags() bool {
	if o != nil && o.LogTags != nil {
		return true
	}

	return false
}

// SetLogTags gets a reference to the given string and assigns it to the LogTags field.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) SetLogTags(v string) {
	o.LogTags = &v
}

// GetOutputFormat returns the OutputFormat field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetOutputFormat() string {
	if o == nil || o.OutputFormat == nil {
		var ret string
		return ret
	}
	return *o.OutputFormat
}

// GetOutputFormatOk returns a tuple with the OutputFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetOutputFormatOk() (*string, bool) {
	if o == nil || o.OutputFormat == nil {
		return nil, false
	}
	return o.OutputFormat, true
}

// HasOutputFormat returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) HasOutputFormat() bool {
	if o != nil && o.OutputFormat != nil {
		return true
	}

	return false
}

// SetOutputFormat gets a reference to the given string and assigns it to the OutputFormat field.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) SetOutputFormat(v string) {
	o.OutputFormat = &v
}

// GetPullInterval returns the PullInterval field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetPullInterval() string {
	if o == nil || o.PullInterval == nil {
		var ret string
		return ret
	}
	return *o.PullInterval
}

// GetPullIntervalOk returns a tuple with the PullInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetPullIntervalOk() (*string, bool) {
	if o == nil || o.PullInterval == nil {
		return nil, false
	}
	return o.PullInterval, true
}

// HasPullInterval returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) HasPullInterval() bool {
	if o != nil && o.PullInterval != nil {
		return true
	}

	return false
}

// SetPullInterval gets a reference to the given string and assigns it to the PullInterval field.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) SetPullInterval(v string) {
	o.PullInterval = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GwUpdateRemoteAccessSessionLogsDatadog) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GwUpdateRemoteAccessSessionLogsDatadog) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ApiKey != nil {
		toSerialize["api-key"] = o.ApiKey
	}
	if o.Enable != nil {
		toSerialize["enable"] = o.Enable
	}
	if o.Host != nil {
		toSerialize["host"] = o.Host
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.LogService != nil {
		toSerialize["log-service"] = o.LogService
	}
	if o.LogSource != nil {
		toSerialize["log-source"] = o.LogSource
	}
	if o.LogTags != nil {
		toSerialize["log-tags"] = o.LogTags
	}
	if o.OutputFormat != nil {
		toSerialize["output-format"] = o.OutputFormat
	}
	if o.PullInterval != nil {
		toSerialize["pull-interval"] = o.PullInterval
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGwUpdateRemoteAccessSessionLogsDatadog struct {
	value *GwUpdateRemoteAccessSessionLogsDatadog
	isSet bool
}

func (v NullableGwUpdateRemoteAccessSessionLogsDatadog) Get() *GwUpdateRemoteAccessSessionLogsDatadog {
	return v.value
}

func (v *NullableGwUpdateRemoteAccessSessionLogsDatadog) Set(val *GwUpdateRemoteAccessSessionLogsDatadog) {
	v.value = val
	v.isSet = true
}

func (v NullableGwUpdateRemoteAccessSessionLogsDatadog) IsSet() bool {
	return v.isSet
}

func (v *NullableGwUpdateRemoteAccessSessionLogsDatadog) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGwUpdateRemoteAccessSessionLogsDatadog(val *GwUpdateRemoteAccessSessionLogsDatadog) *NullableGwUpdateRemoteAccessSessionLogsDatadog {
	return &NullableGwUpdateRemoteAccessSessionLogsDatadog{value: val, isSet: true}
}

func (v NullableGwUpdateRemoteAccessSessionLogsDatadog) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGwUpdateRemoteAccessSessionLogsDatadog) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


