/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// KubeconfigCluster struct for KubeconfigCluster
type KubeconfigCluster struct {
	// CertificateAuthority is optional and can be omitted if not used.
	CertificateAuthority *string `json:"certificate-authority,omitempty"`
	CertificateAuthorityData *string `json:"certificate-authority-data,omitempty"`
	Server *string `json:"server,omitempty"`
}

// NewKubeconfigCluster instantiates a new KubeconfigCluster object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewKubeconfigCluster() *KubeconfigCluster {
	this := KubeconfigCluster{}
	return &this
}

// NewKubeconfigClusterWithDefaults instantiates a new KubeconfigCluster object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewKubeconfigClusterWithDefaults() *KubeconfigCluster {
	this := KubeconfigCluster{}
	return &this
}

// GetCertificateAuthority returns the CertificateAuthority field value if set, zero value otherwise.
func (o *KubeconfigCluster) GetCertificateAuthority() string {
	if o == nil || o.CertificateAuthority == nil {
		var ret string
		return ret
	}
	return *o.CertificateAuthority
}

// GetCertificateAuthorityOk returns a tuple with the CertificateAuthority field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KubeconfigCluster) GetCertificateAuthorityOk() (*string, bool) {
	if o == nil || o.CertificateAuthority == nil {
		return nil, false
	}
	return o.CertificateAuthority, true
}

// HasCertificateAuthority returns a boolean if a field has been set.
func (o *KubeconfigCluster) HasCertificateAuthority() bool {
	if o != nil && o.CertificateAuthority != nil {
		return true
	}

	return false
}

// SetCertificateAuthority gets a reference to the given string and assigns it to the CertificateAuthority field.
func (o *KubeconfigCluster) SetCertificateAuthority(v string) {
	o.CertificateAuthority = &v
}

// GetCertificateAuthorityData returns the CertificateAuthorityData field value if set, zero value otherwise.
func (o *KubeconfigCluster) GetCertificateAuthorityData() string {
	if o == nil || o.CertificateAuthorityData == nil {
		var ret string
		return ret
	}
	return *o.CertificateAuthorityData
}

// GetCertificateAuthorityDataOk returns a tuple with the CertificateAuthorityData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KubeconfigCluster) GetCertificateAuthorityDataOk() (*string, bool) {
	if o == nil || o.CertificateAuthorityData == nil {
		return nil, false
	}
	return o.CertificateAuthorityData, true
}

// HasCertificateAuthorityData returns a boolean if a field has been set.
func (o *KubeconfigCluster) HasCertificateAuthorityData() bool {
	if o != nil && o.CertificateAuthorityData != nil {
		return true
	}

	return false
}

// SetCertificateAuthorityData gets a reference to the given string and assigns it to the CertificateAuthorityData field.
func (o *KubeconfigCluster) SetCertificateAuthorityData(v string) {
	o.CertificateAuthorityData = &v
}

// GetServer returns the Server field value if set, zero value otherwise.
func (o *KubeconfigCluster) GetServer() string {
	if o == nil || o.Server == nil {
		var ret string
		return ret
	}
	return *o.Server
}

// GetServerOk returns a tuple with the Server field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KubeconfigCluster) GetServerOk() (*string, bool) {
	if o == nil || o.Server == nil {
		return nil, false
	}
	return o.Server, true
}

// HasServer returns a boolean if a field has been set.
func (o *KubeconfigCluster) HasServer() bool {
	if o != nil && o.Server != nil {
		return true
	}

	return false
}

// SetServer gets a reference to the given string and assigns it to the Server field.
func (o *KubeconfigCluster) SetServer(v string) {
	o.Server = &v
}

func (o KubeconfigCluster) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CertificateAuthority != nil {
		toSerialize["certificate-authority"] = o.CertificateAuthority
	}
	if o.CertificateAuthorityData != nil {
		toSerialize["certificate-authority-data"] = o.CertificateAuthorityData
	}
	if o.Server != nil {
		toSerialize["server"] = o.Server
	}
	return json.Marshal(toSerialize)
}

type NullableKubeconfigCluster struct {
	value *KubeconfigCluster
	isSet bool
}

func (v NullableKubeconfigCluster) Get() *KubeconfigCluster {
	return v.value
}

func (v *NullableKubeconfigCluster) Set(val *KubeconfigCluster) {
	v.value = val
	v.isSet = true
}

func (v NullableKubeconfigCluster) IsSet() bool {
	return v.isSet
}

func (v *NullableKubeconfigCluster) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableKubeconfigCluster(val *KubeconfigCluster) *NullableKubeconfigCluster {
	return &NullableKubeconfigCluster{value: val, isSet: true}
}

func (v NullableKubeconfigCluster) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableKubeconfigCluster) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


