/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveIndexedArgBase;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class ReceivePreReqdArgInstr
extends ReceiveIndexedArgBase
implements FixedArityInstr {
    public ReceivePreReqdArgInstr(Variable result2, Variable keywords, int argIndex) {
        super(Operation.RECV_PRE_REQD_ARG, result2, keywords, argIndex);
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new ReceivePreReqdArgInstr(info.getRenamedVariable(this.result), info.getRenamedVariable(this.getKeywords()), this.argIndex);
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.canMapArgsStatically()) {
            return new CopyInstr(ii.getRenamedVariable(this.result), ii.getArg(this.argIndex));
        }
        return new ReqdArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), this.argIndex, -1, -1);
    }

    public static ReceivePreReqdArgInstr decode(IRReaderDecoder d) {
        return new ReceivePreReqdArgInstr(d.decodeVariable(), d.decodeVariable(), d.decodeInt());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceivePreReqdArgInstr(this);
    }
}

