/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.asamk.signal.manager.api.AttachmentInvalidException;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.storage.AttachmentStore;
import org.asamk.signal.manager.util.AttachmentUtils;
import org.asamk.signal.manager.util.IOUtils;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.SignalServiceMessageSender;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherInputStream;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentPointer;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentStream;
import org.whispersystems.signalservice.api.push.exceptions.MissingConfigurationException;
import org.whispersystems.signalservice.api.util.StreamDetails;
import org.whispersystems.signalservice.internal.push.http.ResumableUploadSpec;

public class AttachmentHelper {
    private static final Logger logger = LoggerFactory.getLogger(AttachmentHelper.class);
    private final SignalDependencies dependencies;
    private final AttachmentStore attachmentStore;

    public AttachmentHelper(Context context) {
        this.dependencies = context.getDependencies();
        this.attachmentStore = context.getAttachmentStore();
    }

    public File getAttachmentFile(SignalServiceAttachmentPointer pointer) {
        return this.attachmentStore.getAttachmentFile(pointer);
    }

    public StreamDetails retrieveAttachment(String id) throws IOException {
        return this.attachmentStore.retrieveAttachment(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SignalServiceAttachment> uploadAttachments(List<String> attachments) throws AttachmentInvalidException, IOException {
        List<SignalServiceAttachmentStream> attachmentStreams = this.createAttachmentStreams(attachments);
        try {
            ArrayList<SignalServiceAttachmentPointer> attachmentPointers = new ArrayList<SignalServiceAttachmentPointer>(attachmentStreams.size());
            for (SignalServiceAttachmentStream attachmentStream : attachmentStreams) {
                attachmentPointers.add(this.uploadAttachment(attachmentStream));
            }
            ArrayList<SignalServiceAttachmentPointer> arrayList = attachmentPointers;
            return arrayList;
        }
        finally {
            for (SignalServiceAttachmentStream attachmentStream : attachmentStreams) {
                attachmentStream.close();
            }
        }
    }

    private List<SignalServiceAttachmentStream> createAttachmentStreams(List<String> attachments) throws AttachmentInvalidException, IOException {
        if (attachments == null) {
            return null;
        }
        ArrayList<SignalServiceAttachmentStream> signalServiceAttachments = new ArrayList<SignalServiceAttachmentStream>(attachments.size());
        for (String attachment : attachments) {
            ResumableUploadSpec uploadSpec = this.dependencies.getMessageSender().getResumableUploadSpec();
            signalServiceAttachments.add(AttachmentUtils.createAttachmentStream(attachment, uploadSpec));
        }
        return signalServiceAttachments;
    }

    public SignalServiceAttachmentPointer uploadAttachment(String attachment) throws IOException, AttachmentInvalidException {
        ResumableUploadSpec uploadSpec = this.dependencies.getMessageSender().getResumableUploadSpec();
        SignalServiceAttachmentStream attachmentStream = AttachmentUtils.createAttachmentStream(attachment, uploadSpec);
        return this.uploadAttachment(attachmentStream);
    }

    public SignalServiceAttachmentPointer uploadAttachment(SignalServiceAttachmentStream attachment) throws IOException {
        SignalServiceMessageSender messageSender = this.dependencies.getMessageSender();
        return messageSender.uploadAttachment(attachment);
    }

    public void downloadAttachment(SignalServiceAttachment attachment) {
        SignalServiceAttachmentPointer pointer;
        if (!attachment.isPointer()) {
            logger.warn("Invalid state, can't store an attachment stream.");
        }
        if ((pointer = attachment.asPointer()).getPreview().isPresent()) {
            byte[] preview = (byte[])pointer.getPreview().get();
            try {
                this.attachmentStore.storeAttachmentPreview(pointer, outputStream -> outputStream.write(preview, 0, preview.length));
            }
            catch (IOException e) {
                logger.warn("Failed to download attachment preview, ignoring: {}", (Object)e.getMessage());
            }
        }
        try {
            this.attachmentStore.storeAttachment(pointer, outputStream -> this.retrieveAttachment((SignalServiceAttachment)pointer, outputStream));
        }
        catch (IOException e) {
            logger.warn("Failed to download attachment ({}), ignoring: {}", (Object)pointer.getRemoteId(), (Object)e.getMessage());
        }
    }

    void retrieveAttachment(SignalServiceAttachment attachment, OutputStream outputStream) throws IOException {
        this.retrieveAttachment(attachment, (InputStream input) -> IOUtils.copyStream(input, outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveAttachment(SignalServiceAttachment attachment, AttachmentHandler consumer) throws IOException {
        if (attachment.isStream()) {
            InputStream input = attachment.asStream().getInputStream();
            consumer.handle(input);
            return;
        }
        SignalServiceAttachmentPointer pointer = attachment.asPointer();
        logger.debug("Retrieving attachment {} with size {}", (Object)pointer.getRemoteId(), (Object)pointer.getSize());
        File tmpFile = IOUtils.createTempFile();
        try (InputStream input = this.retrieveAttachmentAsStream(pointer, tmpFile);){
            consumer.handle(input);
        }
        finally {
            try {
                Files.delete(tmpFile.toPath());
            }
            catch (IOException e) {
                logger.warn("Failed to delete received attachment temp file \u201c{}\u201d, ignoring: {}", (Object)tmpFile, (Object)e.getMessage());
            }
        }
    }

    private InputStream retrieveAttachmentAsStream(SignalServiceAttachmentPointer pointer, File tmpFile) throws IOException {
        if (pointer.getDigest().isEmpty()) {
            throw new IOException("Attachment pointer has no digest.");
        }
        try {
            return this.dependencies.getMessageReceiver().retrieveAttachment(pointer, tmpFile, 0x9600000L, AttachmentCipherInputStream.IntegrityCheck.forEncryptedDigest((byte[])((byte[])pointer.getDigest().get())));
        }
        catch (InvalidMessageException | MissingConfigurationException e) {
            throw new IOException(e);
        }
    }

    @FunctionalInterface
    public static interface AttachmentHandler {
        public void handle(InputStream var1) throws IOException;
    }
}

