/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.internal;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.ProvisioningManager;
import org.asamk.signal.manager.Settings;
import org.asamk.signal.manager.api.DeviceLinkUrl;
import org.asamk.signal.manager.api.UserAlreadyExistsException;
import org.asamk.signal.manager.config.ServiceEnvironmentConfig;
import org.asamk.signal.manager.internal.AccountFileUpdaterImpl;
import org.asamk.signal.manager.internal.ManagerImpl;
import org.asamk.signal.manager.internal.PathConfig;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.accounts.AccountsStore;
import org.asamk.signal.manager.util.KeyUtils;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.account.PreKeyCollection;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.push.exceptions.AuthorizationFailedException;
import org.whispersystems.signalservice.api.registration.ProvisioningApi;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.api.util.DeviceNameUtil;
import org.whispersystems.signalservice.internal.push.ProvisioningSocket;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.util.DynamicCredentialsProvider;

public class ProvisioningManagerImpl
implements ProvisioningManager {
    private static final Logger logger = LoggerFactory.getLogger(ProvisioningManagerImpl.class);
    private final PathConfig pathConfig;
    private final ServiceEnvironmentConfig serviceEnvironmentConfig;
    private final String userAgent;
    private final Consumer<Manager> newManagerListener;
    private final AccountsStore accountsStore;
    private final ProvisioningApi provisioningApi;
    private final IdentityKeyPair tempIdentityKey;
    private final String password;

    public ProvisioningManagerImpl(PathConfig pathConfig, ServiceEnvironmentConfig serviceEnvironmentConfig, String userAgent, Consumer<Manager> newManagerListener, AccountsStore accountsStore) {
        this.pathConfig = pathConfig;
        this.serviceEnvironmentConfig = serviceEnvironmentConfig;
        this.userAgent = userAgent;
        this.newManagerListener = newManagerListener;
        this.accountsStore = accountsStore;
        this.tempIdentityKey = KeyUtils.generateIdentityKeyPair();
        this.password = KeyUtils.createPassword();
        DynamicCredentialsProvider credentialsProvider = new DynamicCredentialsProvider(null, null, null, this.password, 1);
        PushServiceSocket pushServiceSocket = new PushServiceSocket(serviceEnvironmentConfig.signalServiceConfiguration(), (CredentialsProvider)credentialsProvider, userAgent, true);
        ProvisioningSocket provisioningSocket = new ProvisioningSocket(serviceEnvironmentConfig.signalServiceConfiguration(), userAgent);
        this.provisioningApi = new ProvisioningApi(pushServiceSocket, provisioningSocket, (CredentialsProvider)credentialsProvider);
    }

    @Override
    public URI getDeviceLinkUri() throws TimeoutException, IOException {
        String deviceUuid = this.provisioningApi.getNewDeviceUuid();
        return new DeviceLinkUrl(deviceUuid, this.tempIdentityKey.getPublicKey().getPublicKey()).createDeviceLinkUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String finishDeviceLink(String deviceName) throws IOException, TimeoutException, UserAlreadyExistsException {
        boolean accountExists;
        ProvisioningApi.NewDeviceRegistrationReturn ret = this.provisioningApi.getNewDeviceRegistration(this.tempIdentityKey);
        String number = ret.getNumber();
        ServiceId.ACI aci = ret.getAci();
        ServiceId.PNI pni = ret.getPni();
        logger.info("Received link information from {}, linking in progress ...", (Object)number);
        String accountPath = this.accountsStore.getPathByAci(aci);
        if (accountPath == null) {
            accountPath = this.accountsStore.getPathByNumber(number);
        }
        boolean bl = accountExists = accountPath != null && SignalAccount.accountFileExists(this.pathConfig.dataPath(), accountPath);
        if (accountExists && !this.canRelinkExistingAccount(accountPath)) {
            throw new UserAlreadyExistsException(number, SignalAccount.getFileName(this.pathConfig.dataPath(), accountPath));
        }
        if (accountPath == null) {
            accountPath = this.accountsStore.addAccount(number, aci);
        } else {
            this.accountsStore.updateAccount(accountPath, number, aci);
        }
        String encryptedDeviceName = deviceName == null ? null : DeviceNameUtil.encryptDeviceName((String)deviceName, (ECPrivateKey)ret.getAciIdentity().getPrivateKey());
        ProfileKey profileKey = ret.getProfileKey() == null ? KeyUtils.createProfileKey() : ret.getProfileKey();
        try (SignalAccount account = null;){
            account = !accountExists ? SignalAccount.createLinkedAccount(this.pathConfig.dataPath(), accountPath, this.serviceEnvironmentConfig.type(), Settings.DEFAULT) : SignalAccount.load(this.pathConfig.dataPath(), accountPath, true, Settings.DEFAULT);
            account.setProvisioningData(number, aci, pni, this.password, encryptedDeviceName, ret.getAciIdentity(), ret.getPniIdentity(), profileKey, ret.getMasterKey(), ret.getAccountEntropyPool(), ret.getMediaRootBackupKey());
            account.getConfigurationStore().setReadReceipts(ret.isReadReceipts());
            PreKeyCollection aciPreKeys = KeyUtils.generatePreKeysForType(account.getAccountData(ServiceIdType.ACI));
            PreKeyCollection pniPreKeys = KeyUtils.generatePreKeysForType(account.getAccountData(ServiceIdType.PNI));
            logger.debug("Finishing new device registration");
            int deviceId = this.provisioningApi.finishNewDeviceRegistration(ret.getProvisioningCode(), account.getAccountAttributes(null), aciPreKeys, pniPreKeys);
            account.finishLinking(deviceId, aciPreKeys, pniPreKeys);
            ManagerImpl m = null;
            try {
                m = new ManagerImpl(account, this.pathConfig, new AccountFileUpdaterImpl(this.accountsStore, accountPath), this.serviceEnvironmentConfig, this.userAgent);
                account = null;
                logger.debug("Refreshing pre keys");
                try {
                    m.refreshPreKeys();
                }
                catch (Exception e) {
                    logger.error("Failed to refresh pre keys.", (Throwable)e);
                }
                logger.debug("Requesting sync data");
                try {
                    m.requestAllSyncData();
                }
                catch (Exception e) {
                    logger.error("Failed to request sync messages from linked device, data can be requested again with `sendSyncRequest`.", (Throwable)e);
                }
                if (this.newManagerListener != null) {
                    this.newManagerListener.accept(m);
                    m = null;
                }
                String string = number;
                if (m != null) {
                    m.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                if (m != null) {
                    m.close();
                }
                throw throwable;
            }
        }
    }

    private boolean canRelinkExistingAccount(String accountPath) throws IOException {
        SignalAccount signalAccount;
        try {
            signalAccount = SignalAccount.load(this.pathConfig.dataPath(), accountPath, false, Settings.DEFAULT);
        }
        catch (IOException e) {
            logger.debug("Account in use or failed to load.", (Throwable)e);
            return false;
        }
        catch (OverlappingFileLockException e) {
            logger.debug("Account in use.", (Throwable)e);
            return false;
        }
        try (SignalAccount signalAccount2 = signalAccount;){
            if (signalAccount.isPrimaryDevice()) {
                logger.debug("Account is a primary device.");
                boolean bl = false;
                return bl;
            }
            if (signalAccount.isRegistered() && signalAccount.getServiceEnvironment() != null && signalAccount.getServiceEnvironment() != this.serviceEnvironmentConfig.type()) {
                logger.debug("Account is registered in another environment: {}.", (Object)signalAccount.getServiceEnvironment());
                boolean bl = false;
                return bl;
            }
            ManagerImpl m = new ManagerImpl(signalAccount, this.pathConfig, new AccountFileUpdaterImpl(this.accountsStore, accountPath), this.serviceEnvironmentConfig, this.userAgent);
            try (ManagerImpl managerImpl = m;){
                m.checkAccountState();
            }
            catch (AuthorizationFailedException ignored) {
                boolean bl = true;
                if (signalAccount2 != null) {
                    signalAccount2.close();
                }
                return bl;
            }
            logger.debug("Account is still successfully linked.");
            boolean bl = false;
            return bl;
        }
    }
}

