/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.prekeys;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.asamk.signal.manager.storage.prekeys.SignedPreKeyStore;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.state.SignedPreKeyRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacySignedPreKeyStore {
    private static final Logger logger = LoggerFactory.getLogger(LegacySignedPreKeyStore.class);
    static final Pattern signedPreKeyFileNamePattern = Pattern.compile("(\\d+)");

    public static void migrate(File signedPreKeysPath, SignedPreKeyStore signedPreKeyStore) {
        File[] files = signedPreKeysPath.listFiles();
        if (files == null) {
            return;
        }
        List<SignedPreKeyRecord> signedPreKeyRecords = Arrays.stream(files).filter(f -> signedPreKeyFileNamePattern.matcher(f.getName()).matches()).map(LegacySignedPreKeyStore::loadSignedPreKeyRecord).toList();
        signedPreKeyStore.addLegacySignedPreKeys(signedPreKeyRecords);
        LegacySignedPreKeyStore.removeAllSignedPreKeys(signedPreKeysPath);
    }

    private static void removeAllSignedPreKeys(File signedPreKeysPath) {
        File[] files = signedPreKeysPath.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                logger.error("Failed to delete signed pre key file {}: {}", (Object)file, (Object)e.getMessage());
            }
        }
        try {
            Files.delete(signedPreKeysPath.toPath());
        }
        catch (IOException e) {
            logger.error("Failed to delete signed pre key directory {}: {}", (Object)signedPreKeysPath, (Object)e.getMessage());
        }
    }

    private static SignedPreKeyRecord loadSignedPreKeyRecord(File file) {
        SignedPreKeyRecord signedPreKeyRecord;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            signedPreKeyRecord = new SignedPreKeyRecord(inputStream.readAllBytes());
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InvalidMessageException e) {
                logger.error("Failed to load signed pre key: {}", (Object)e.getMessage());
                throw new AssertionError((Object)e);
            }
        }
        inputStream.close();
        return signedPreKeyRecord;
    }
}

