/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.whispersystems.signalservice.api.crypto.DigestingOutputStream;
import org.whispersystems.signalservice.internal.util.Util;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/whispersystems/signalservice/api/crypto/AttachmentCipherOutputStream;", "Lorg/whispersystems/signalservice/api/crypto/DigestingOutputStream;", "combinedKeyMaterial", "", "iv", "outputStream", "Ljava/io/OutputStream;", "<init>", "([B[BLjava/io/OutputStream;)V", "cipher", "Ljavax/crypto/Cipher;", "mac", "Ljavax/crypto/Mac;", "write", "", "buffer", "offset", "", "length", "b", "close", "signal-service-java"})
public final class AttachmentCipherOutputStream
extends DigestingOutputStream {
    @NotNull
    private final Cipher cipher;
    @NotNull
    private final Mac mac;

    public AttachmentCipherOutputStream(@NotNull byte[] combinedKeyMaterial, @Nullable byte[] iv, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)combinedKeyMaterial, (String)"combinedKeyMaterial");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        super(outputStream);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        Intrinsics.checkNotNullExpressionValue((Object)cipher, (String)"getInstance(...)");
        this.cipher = cipher;
        Mac mac = Mac.getInstance("HmacSHA256");
        Intrinsics.checkNotNullExpressionValue((Object)mac, (String)"getInstance(...)");
        this.mac = mac;
        byte[][] keyParts = Util.split(combinedKeyMaterial, 32, 32);
        if (iv == null) {
            this.cipher.init(1, new SecretKeySpec(keyParts[0], "AES"));
        } else {
            this.cipher.init(1, (Key)new SecretKeySpec(keyParts[0], "AES"), new IvParameterSpec(iv));
        }
        this.mac.init(new SecretKeySpec(keyParts[1], "HmacSHA256"));
        this.mac.update(this.cipher.getIV());
        super.write(this.cipher.getIV());
    }

    @Override
    public void write(@NotNull byte[] buffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(@NotNull byte[] buffer, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        byte[] ciphertext = this.cipher.update(buffer, offset, length);
        if (ciphertext != null) {
            this.mac.update(ciphertext);
            super.write(ciphertext);
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] input = new byte[]{(byte)b};
        this.write(input, 0, 1);
    }

    @Override
    public void close() throws IOException {
        try {
            byte[] ciphertext = this.cipher.doFinal();
            byte[] auth = this.mac.doFinal(ciphertext);
            super.write(ciphertext);
            super.write(auth);
            super.close();
        }
        catch (IllegalBlockSizeException e) {
            throw new AssertionError((Object)e);
        }
        catch (BadPaddingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

