/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages.multidevice;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import okio.ByteString;
import org.whispersystems.signalservice.api.messages.multidevice.ChunkedOutputStream;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceGroup;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.push.GroupDetails;

public class DeviceGroupsOutputStream
extends ChunkedOutputStream {
    public DeviceGroupsOutputStream(OutputStream out) {
        super(out);
    }

    public void write(DeviceGroup group) throws IOException {
        this.writeGroupDetails(group);
        this.writeAvatarImage(group);
    }

    public void close() throws IOException {
        this.out.close();
    }

    private void writeAvatarImage(DeviceGroup contact) throws IOException {
        if (contact.getAvatar().isPresent()) {
            this.writeStream(contact.getAvatar().get().getInputStream());
        }
    }

    private void writeGroupDetails(DeviceGroup group) throws IOException {
        GroupDetails.Builder groupDetails = new GroupDetails.Builder();
        groupDetails.id(ByteString.of((byte[])group.getId()));
        if (group.getName().isPresent()) {
            groupDetails.name(group.getName().get());
        }
        if (group.getAvatar().isPresent()) {
            GroupDetails.Avatar.Builder avatarBuilder = new GroupDetails.Avatar.Builder();
            avatarBuilder.contentType(group.getAvatar().get().getContentType());
            avatarBuilder.length((int)group.getAvatar().get().getLength());
            groupDetails.avatar(avatarBuilder.build());
        }
        if (group.getExpirationTimer().isPresent()) {
            groupDetails.expireTimer(group.getExpirationTimer().get());
        }
        if (group.getColor().isPresent()) {
            groupDetails.color(group.getColor().get());
        }
        ArrayList<GroupDetails.Member> members = new ArrayList<GroupDetails.Member>(group.getMembers().size());
        ArrayList<String> membersE164 = new ArrayList<String>(group.getMembers().size());
        for (SignalServiceAddress address : group.getMembers()) {
            if (!address.getNumber().isPresent()) continue;
            membersE164.add(address.getNumber().get());
            GroupDetails.Member.Builder builder = new GroupDetails.Member.Builder();
            builder.e164(address.getNumber().get());
            members.add(builder.build());
        }
        groupDetails.members(members);
        groupDetails.membersE164(membersE164);
        groupDetails.active(group.isActive());
        groupDetails.blocked(group.isBlocked());
        groupDetails.archived(group.isArchived());
        if (group.getInboxPosition().isPresent()) {
            groupDetails.inboxPosition(group.getInboxPosition().get());
        }
        byte[] serializedContactDetails = groupDetails.build().encode();
        this.writeVarint32(serializedContactDetails.length);
        this.out.write(serializedContactDetails);
    }
}

