/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.registration;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.IdentityKeyPair;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.util.ByteUtil;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.AccountEntropyPool;
import org.whispersystems.signalservice.api.account.AccountAttributes;
import org.whispersystems.signalservice.api.account.PreKeyCollection;
import org.whispersystems.signalservice.api.backup.MediaRootBackupKey;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.internal.push.ProvisionMessage;
import org.whispersystems.signalservice.internal.push.ProvisioningSocket;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.util.DynamicCredentialsProvider;

public class ProvisioningApi {
    private final PushServiceSocket pushServiceSocket;
    private final ProvisioningSocket provisioningSocket;
    private final CredentialsProvider credentials;

    public ProvisioningApi(PushServiceSocket pushServiceSocket, ProvisioningSocket provisioningSocket, CredentialsProvider credentials) {
        this.pushServiceSocket = pushServiceSocket;
        this.provisioningSocket = provisioningSocket;
        this.credentials = credentials;
    }

    public String getNewDeviceUuid() throws TimeoutException, IOException {
        return this.provisioningSocket.getProvisioningUuid().address;
    }

    public NewDeviceRegistrationReturn getNewDeviceRegistration(IdentityKeyPair tempIdentity) throws TimeoutException, IOException {
        MasterKey masterKey;
        ProfileKey profileKey;
        ProvisionMessage msg = this.provisioningSocket.getProvisioningMessage(tempIdentity);
        String number = msg.number;
        ServiceId.ACI aci = ServiceId.ACI.parseOrThrow(msg.aci);
        ServiceId.PNI pni = ServiceId.PNI.parseOrThrow(msg.pni);
        if (this.credentials instanceof DynamicCredentialsProvider) {
            ((DynamicCredentialsProvider)this.credentials).setE164(number);
        }
        IdentityKeyPair aciIdentity = this.getIdentityKeyPair(msg.aciIdentityKeyPublic.toByteArray(), msg.aciIdentityKeyPrivate.toByteArray());
        IdentityKeyPair pniIdentity = msg.pniIdentityKeyPublic != null && msg.pniIdentityKeyPrivate != null ? this.getIdentityKeyPair(msg.pniIdentityKeyPublic.toByteArray(), msg.pniIdentityKeyPrivate.toByteArray()) : null;
        try {
            profileKey = msg.profileKey != null ? new ProfileKey(msg.profileKey.toByteArray()) : null;
        }
        catch (InvalidInputException e) {
            throw new IOException("Failed to decrypt profile key", e);
        }
        try {
            masterKey = msg.masterKey != null ? new MasterKey(msg.masterKey.toByteArray()) : null;
        }
        catch (AssertionError e) {
            throw new IOException("Failed to decrypt master key", (Throwable)((Object)e));
        }
        AccountEntropyPool accountEntropyPool = msg.accountEntropyPool != null ? new AccountEntropyPool(msg.accountEntropyPool) : null;
        MediaRootBackupKey mediaRootBackupKey = msg.mediaRootBackupKey != null && msg.mediaRootBackupKey.size() == 32 ? new MediaRootBackupKey(msg.mediaRootBackupKey.toByteArray()) : null;
        String provisioningCode = msg.provisioningCode;
        boolean readReceipts = msg.readReceipts != null && msg.readReceipts != false;
        return new NewDeviceRegistrationReturn(provisioningCode, aciIdentity, pniIdentity, number, aci, pni, profileKey, masterKey, accountEntropyPool, mediaRootBackupKey, readReceipts);
    }

    private IdentityKeyPair getIdentityKeyPair(byte[] publicKeyBytes, byte[] privateKeyBytes) throws IOException {
        ECPrivateKey privateKey;
        ECPublicKey publicKey;
        if (publicKeyBytes.length == 32) {
            int DJB_TYPE = 5;
            byte[] type = new byte[]{5};
            publicKeyBytes = ByteUtil.combine((byte[][])new byte[][]{type, publicKeyBytes});
        }
        try {
            publicKey = new ECPublicKey(publicKeyBytes);
            privateKey = new ECPrivateKey(privateKeyBytes);
        }
        catch (InvalidKeyException e) {
            throw new IOException("Failed to decrypt key", e);
        }
        return new IdentityKeyPair(new IdentityKey(publicKey), privateKey);
    }

    public int finishNewDeviceRegistration(String provisioningCode, AccountAttributes accountAttributes, PreKeyCollection aciPreKeys, PreKeyCollection pniPreKeys) throws IOException {
        int deviceId = this.pushServiceSocket.finishNewDeviceRegistration(provisioningCode, accountAttributes, aciPreKeys, pniPreKeys);
        if (this.credentials instanceof DynamicCredentialsProvider) {
            ((DynamicCredentialsProvider)this.credentials).setDeviceId(deviceId);
        }
        return deviceId;
    }

    public static class NewDeviceRegistrationReturn {
        private final String provisioningCode;
        private final IdentityKeyPair aciIdentity;
        private final IdentityKeyPair pniIdentity;
        private final String number;
        private final ServiceId.ACI aci;
        private final ServiceId.PNI pni;
        private final ProfileKey profileKey;
        private final MasterKey masterKey;
        private final AccountEntropyPool accountEntropyPool;
        private final MediaRootBackupKey mediaRootBackupKey;
        private final boolean readReceipts;

        NewDeviceRegistrationReturn(String provisioningCode, IdentityKeyPair aciIdentity, IdentityKeyPair pniIdentity, String number, ServiceId.ACI aci, ServiceId.PNI pni, ProfileKey profileKey, MasterKey masterKey, AccountEntropyPool accountEntropyPool, MediaRootBackupKey mediaRootBackupKey, boolean readReceipts) {
            this.provisioningCode = provisioningCode;
            this.aciIdentity = aciIdentity;
            this.pniIdentity = pniIdentity;
            this.number = number;
            this.aci = aci;
            this.pni = pni;
            this.profileKey = profileKey;
            this.masterKey = masterKey;
            this.accountEntropyPool = accountEntropyPool;
            this.mediaRootBackupKey = mediaRootBackupKey;
            this.readReceipts = readReceipts;
        }

        public String getProvisioningCode() {
            return this.provisioningCode;
        }

        public IdentityKeyPair getAciIdentity() {
            return this.aciIdentity;
        }

        public IdentityKeyPair getPniIdentity() {
            return this.pniIdentity;
        }

        public String getNumber() {
            return this.number;
        }

        public ServiceId.ACI getAci() {
            return this.aci;
        }

        public ServiceId.PNI getPni() {
            return this.pni;
        }

        public ProfileKey getProfileKey() {
            return this.profileKey;
        }

        public MasterKey getMasterKey() {
            return this.masterKey;
        }

        public AccountEntropyPool getAccountEntropyPool() {
            return this.accountEntropyPool;
        }

        public MediaRootBackupKey getMediaRootBackupKey() {
            return this.mediaRootBackupKey;
        }

        public boolean isReadReceipts() {
            return this.readReceipts;
        }
    }
}

