/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.factory;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.UnsupportedCommOperationException;
import gnu.io.factory.SerialPortCreator;

public class RxTxPortCreator
implements SerialPortCreator<RXTXPort> {
    @Override
    public boolean isApplicable(String portName, Class<RXTXPort> expectedClass) {
        return expectedClass.isAssignableFrom(RXTXPort.class);
    }

    @Override
    public RXTXPort createPort(String port) throws NoSuchPortException, UnsupportedCommOperationException, PortInUseException {
        RXTXPort comm = null;
        CommPortIdentifier ident = null;
        if (System.getProperty("os.name").toLowerCase().indexOf("linux") != -1) {
            System.setProperty("gnu.io.rxtx.SerialPorts", port);
        }
        if (!((comm = (ident = CommPortIdentifier.getPortIdentifier(port)).open("NRSerialPort", 2000)) instanceof RXTXPort)) {
            throw new UnsupportedCommOperationException("Non-serial connections are unsupported.");
        }
        comm.enableReceiveTimeout(100);
        return comm;
    }

    @Override
    public String getProtocol() {
        return "local";
    }
}

