/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.preferences;

import org.eclipse.core.runtime.ListenerList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractPreferenceStore
implements DBPPreferenceStore {
    public static final boolean BOOLEAN_DEFAULT_DEFAULT = false;
    public static final double DOUBLE_DEFAULT_DEFAULT = 0.0;
    public static final float FLOAT_DEFAULT_DEFAULT = 0.0f;
    public static final int INT_DEFAULT_DEFAULT = 0;
    public static final long LONG_DEFAULT_DEFAULT = 0L;
    public static final String STRING_DEFAULT_DEFAULT = "";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private volatile transient ListenerList<DBPPreferenceListener> listenerList = null;

    @Override
    public void firePropertyChangeEvent(@NotNull String name, @Nullable Object oldValue, @Nullable Object newValue) {
        this.firePropertyChangeEvent(this, name, oldValue, newValue);
    }

    public void firePropertyChangeEvent(Object source, String name, Object oldValue, Object newValue) {
        DBPPreferenceListener[] finalListeners = this.getListeners();
        if (finalListeners.length > 0 && !CommonUtils.equalObjects((Object)oldValue, (Object)newValue)) {
            DBPPreferenceListener.PreferenceChangeEvent pe = new DBPPreferenceListener.PreferenceChangeEvent(source, name, oldValue, newValue);
            for (DBPPreferenceListener finalListener : finalListeners) {
                finalListener.preferenceChange(pe);
            }
        }
    }

    @Override
    public void addPropertyChangeListener(@NotNull DBPPreferenceListener listener) {
        this.addListenerObject(listener);
    }

    @Override
    public void removePropertyChangeListener(@NotNull DBPPreferenceListener listener) {
        this.removeListenerObject(listener);
    }

    protected boolean toBoolean(String value) {
        return value != null && value.equals(TRUE);
    }

    protected double toDouble(String value) {
        double ival = 0.0;
        if (!CommonUtils.isEmpty((String)value)) {
            try {
                ival = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ival;
    }

    protected float toFloat(String value) {
        float ival = 0.0f;
        if (!CommonUtils.isEmpty((String)value)) {
            try {
                ival = Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ival;
    }

    protected int toInt(String value) {
        int ival = 0;
        if (!CommonUtils.isEmpty((String)value)) {
            try {
                ival = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ival;
    }

    protected long toLong(String value) {
        long ival = 0L;
        if (!CommonUtils.isEmpty((String)value)) {
            try {
                ival = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ival;
    }

    protected final DBPPreferenceListener[] getListeners() {
        ListenerList<DBPPreferenceListener> list = this.listenerList;
        if (list == null) {
            return new DBPPreferenceListener[0];
        }
        Object[] ol = list.getListeners();
        DBPPreferenceListener[] listeners = new DBPPreferenceListener[ol.length];
        for (int i = 0; i < list.size(); ++i) {
            listeners[i] = (DBPPreferenceListener)ol[i];
        }
        return listeners;
    }

    protected final synchronized void addListenerObject(DBPPreferenceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)listener);
    }

    protected final synchronized void removeListenerObject(DBPPreferenceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listenerList != null) {
            this.listenerList.remove((Object)listener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }
}

