/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.tools.DocumentationTool;
import javax.tools.JavaCompiler;

public class ToolProvider {
    private static final String systemJavaCompilerModule = "jdk.compiler";
    private static final String systemJavaCompilerName = "com.sun.tools.javac.api.JavacTool";
    private static final String systemDocumentationToolModule = "jdk.javadoc";
    private static final String systemDocumentationToolName = "jdk.javadoc.internal.api.JavadocTool";

    private ToolProvider() {
    }

    public static JavaCompiler getSystemJavaCompiler() {
        return ToolProvider.getSystemTool(JavaCompiler.class, systemJavaCompilerModule, systemJavaCompilerName);
    }

    public static DocumentationTool getSystemDocumentationTool() {
        return ToolProvider.getSystemTool(DocumentationTool.class, systemDocumentationToolModule, systemDocumentationToolName);
    }

    @Deprecated(since="9")
    public static ClassLoader getSystemToolClassLoader() {
        return null;
    }

    private static <T> T getSystemTool(Class<T> clazz, String string, String string2) {
        try {
            ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, ClassLoader.getSystemClassLoader());
            for (T t : serviceLoader) {
                if (!ToolProvider.matches(t, string)) continue;
                return t;
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new Error(serviceConfigurationError);
        }
        return null;
    }

    private static <T> boolean matches(T t, String string) {
        PrivilegedAction<Boolean> privilegedAction = () -> {
            Module module = t.getClass().getModule();
            String string2 = module.getName();
            return Objects.equals(string2, string);
        };
        return AccessController.doPrivileged(privilegedAction);
    }
}

