SYD-KEY(1)

# NAME

*syd-key* - Utility to generate encryption keys and save to _keyrings_(7)

# SYNOPSIS

*syd-key* _[-hpP]_ _[-d keydesc]_ _[-t keytype]_ _[-k keyring]_

# DESCRIPTION

The *syd-key* utility generates random 256-bit encryption keys using
Linux Kernel's random number generator. The key is saved to Linux
_keyrings_(7) and key serial ID is printed as a decimal 32-bit integer
to standard output.

# OPTIONS

|[ *-h*
:< Display help.
|[ *-p*
:< Read passphrase from the controlling TTY (NOT _stdin_(3)) and derive key material.
|[
:< syd-key will refuse to read the passphrase from _stdin_(3) for
   safety, unless *-P* is explicitly supplied. The passphrase is hashed
   using SHA3-256; the resulting digest is stored with _keyrings_(7)
   interface.  The passphrase buffer is zeroized after use. Key serial ID
   is printed on _stdout_(3).
|[
:< If none of *-pP* is supplied, a random key is generated using _getrandom_(2) with GRND_RANDOM flag instead.
|[ *-P*
:< Read passphrase from _stdin_(3) and derive key material.
|[
:< This option is intended for non-interactive use (for example, piping
   a passphrase from a password manager). *Use with caution*: reading a
   passphrase from _stdin_(3) can be less secure than reading from the
   controlling TTY because it may be observable by other processes,
   recorded in shell constructs, or otherwise leaked by the environment.
   The passphrase is hashed using SHA3-256; the resulting digest is
   stored with keyrings(7) interface. The passphrase buffer is zeroized after
   use. Key serial ID is printed on stdout(3).
|[
:< If none of *-pP* is supplied, a random key is generated using _getrandom_(2) with GRND_RANDOM flag instead.
|[ *-d kdesc*
:< Specify alternative key description. Default is *SYD-3-CRYPT*.
|[ *-t ktype*
:< Specify alternative key type. Default is *user*.
|[ *-k kring*
:< Specify alternative key ring ID. Default is *KEY_SPEC_USER_KEYRING*.
   May be exactly one of *thread*, *process*, *session*, *user* or *user-session*.
   May also be a 32-bit decimal number specifying a keyring ID.

# CAVEATS

Keys in _keyrings_(7) are identified by their (type, description) pair.
When *syd-key* invokes _add_key_(2) with a type/description that already
exists in the target keyring, the kernel will update the existing key's
payload instead of creating a new key. To force creation of a new key,
use a unique description (for example by appending a UUID or timestamp).

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _syd-aes_(1), _getrandom_(2), _add_key_(2), _keyrings_(7)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
