/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.util.converter.ConverterBuilder;
import org.osgi.util.converter.ConverterFunction;
import org.osgi.util.converter.CustomConverterImpl;
import org.osgi.util.converter.InternalConverter;
import org.osgi.util.converter.TargetRule;

class ConverterBuilderImpl
implements ConverterBuilder {
    private final InternalConverter converter;
    private final Map<Type, List<ConverterFunction>> rules = new HashMap<Type, List<ConverterFunction>>();
    private final List<ConverterFunction> catchAllRules = new ArrayList<ConverterFunction>();
    private final List<ConverterFunction> errorHandlers = new ArrayList<ConverterFunction>();

    public ConverterBuilderImpl(InternalConverter c) {
        this.converter = c;
    }

    @Override
    public InternalConverter build() {
        return new CustomConverterImpl(this.converter, this.rules, this.catchAllRules, this.errorHandlers);
    }

    @Override
    public ConverterBuilder errorHandler(ConverterFunction func) {
        this.errorHandlers.add(func);
        return this;
    }

    @Override
    public ConverterBuilder rule(ConverterFunction func) {
        this.catchAllRules.add(func);
        return this;
    }

    @Override
    public ConverterBuilder rule(Type t, ConverterFunction func) {
        this.getRulesList(t).add(func);
        return this;
    }

    @Override
    public ConverterBuilder rule(TargetRule rule) {
        Type type = rule.getTargetType();
        this.getRulesList(type).add(rule.getFunction());
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            boolean containsWildCard = false;
            for (Type t : pt.getActualTypeArguments()) {
                if (!(t instanceof WildcardType)) continue;
                containsWildCard = true;
                break;
            }
            if (containsWildCard) {
                this.getRulesList(pt.getRawType()).add(rule.getFunction());
            }
        }
        return this;
    }

    private List<ConverterFunction> getRulesList(Type type) {
        List<ConverterFunction> l = this.rules.get(type);
        if (l == null) {
            l = new ArrayList<ConverterFunction>();
            this.rules.put(type, l);
        }
        return l;
    }
}

