/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import javax.swing.plaf.nimbus.Effect;
import javax.swing.plaf.nimbus.EffectUtils;
import javax.swing.plaf.nimbus.ShadowEffect;

class DropShadowEffect
extends ShadowEffect {
    DropShadowEffect() {
    }

    @Override
    Effect.EffectType getEffectType() {
        return Effect.EffectType.UNDER;
    }

    @Override
    BufferedImage applyEffect(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (bufferedImage == null || bufferedImage.getType() != 2) {
            throw new IllegalArgumentException("Effect only works with source images of type BufferedImage.TYPE_INT_ARGB.");
        }
        if (bufferedImage2 != null && bufferedImage2.getType() != 2) {
            throw new IllegalArgumentException("Effect only works with destination images of type BufferedImage.TYPE_INT_ARGB.");
        }
        double d = Math.toRadians(this.angle - 90);
        int n6 = (int)(Math.sin(d) * (double)this.distance);
        int n7 = (int)(Math.cos(d) * (double)this.distance);
        int n8 = n6 + this.size;
        int n9 = n6 + this.size;
        int n10 = n + n6 + this.size + this.size;
        int n11 = n2 + n6 + this.size;
        int[] nArray = DropShadowEffect.getArrayCache().getTmpIntArray(n);
        byte[] byArray = DropShadowEffect.getArrayCache().getTmpByteArray1(n10 * n11);
        Arrays.fill(byArray, (byte)0);
        byte[] byArray2 = DropShadowEffect.getArrayCache().getTmpByteArray2(n10 * n11);
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (int i = 0; i < n2; ++i) {
            int n12 = i + n9;
            n5 = n12 * n10;
            writableRaster.getDataElements(0, i, n, 1, nArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 + n8;
                byArray[n5 + n3] = (byte)((nArray[n4] & 0xFF000000) >>> 24);
            }
        }
        float[] fArray = EffectUtils.createGaussianKernel(this.size);
        EffectUtils.blur(byArray, byArray2, n10, n11, fArray, this.size);
        EffectUtils.blur(byArray2, byArray, n11, n10, fArray, this.size);
        float f = Math.min(1.0f / (1.0f - 0.01f * (float)this.spread), 255.0f);
        for (n5 = 0; n5 < byArray.length; ++n5) {
            n4 = (int)((float)(byArray[n5] & 0xFF) * f);
            byArray[n5] = (byte)(n4 > 255 ? -1 : (byte)n4);
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = new BufferedImage(n, n2, 2);
        }
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        n4 = this.color.getRed();
        n3 = this.color.getGreen();
        int n13 = this.color.getBlue();
        for (int i = 0; i < n2; ++i) {
            int n14 = i + n9;
            int n15 = (n14 - n7) * n10;
            for (int j = 0; j < n; ++j) {
                int n16 = j + n8;
                nArray[j] = byArray[n15 + (n16 - n6)] << 24 | n4 << 16 | n3 << 8 | n13;
            }
            writableRaster2.setDataElements(0, i, n, 1, nArray);
        }
        return bufferedImage2;
    }
}

