/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_brx extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ग्रिनवीच गेजेरारि सम",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "आकर स्टैंडर्ड टाईम",
               "",
               "आकर समर टाईम",
               "",
               "एकोर सम",
               "",
            };
        final String[] Apia = new String[] {
               "आपिया थाखोआरि सम",
               "",
               "आपिया सान सम",
               "",
               "आपिया सम",
               "",
            };
        final String[] Cook = new String[] {
               "कुक द्वीपफोरनि थाखोआरि सम",
               "",
               "कुक द्वीपफोरनि खावसे दैज्लां सम",
               "",
               "कुक द्वीपफोरनि सम",
               "",
            };
        final String[] Cuba = new String[] {
               "किउबा थाखोआरि सम",
               "CST",
               "किउबा सानारि सम",
               "CDT",
               "किउबा सम",
               "CT",
            };
        final String[] Fiji = new String[] {
               "फीजी थाखोआरि सम",
               "",
               "फीजी दैज्लां सम",
               "",
               "फीजी सम",
               "",
            };
        final String[] Gulf = new String[] {
               "गाल्फ थाखोआरि सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "ह’भ्द थाखोआरि सम",
               "",
               "ह’भ्द दैज्लां सम",
               "",
               "ह’भ्द सम",
               "",
            };
        final String[] Iran = new String[] {
               "इरान थाखोआरि सम",
               "",
               "इरान सानारि सम",
               "",
               "इरान सम",
               "",
            };
        final String[] Niue = new String[] {
               "नीऊए सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "अम्स्क थाखोआरि सम",
               "",
               "अम्स्क दैज्लां सम",
               "",
               "अम्स्क सम",
               "",
            };
        final String[] Peru = new String[] {
               "पेरु थाखोआरि सम",
               "",
               "पेरु दैज्लां सम",
               "",
               "पेरु सम",
               "",
            };
        final String[] Truk = new String[] {
               "चूक सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "वैक द्वीप सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "चीले थाखोआरि सम",
               "",
               "चीले दैज्लां सम",
               "",
               "चीले सम",
               "",
            };
        final String[] China = new String[] {
               "चाईना थाखोआरि सम",
               "CST",
               "चाईना सानारि सम",
               "CDT",
               "चाईना सम",
               "CT",
            };
        final String[] Cocos = new String[] {
               "कक’स द्वीपफोरनि सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "डेभिस सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "भारतारि थाखोआरि सम",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "जापान थाखोआरि सम",
               "JST",
               "जापान सानारि सम",
               "JDT",
               "जापान सम",
               "JT",
            };
        final String[] Korea = new String[] {
               "क’रिया थाखोआरि सम",
               "KST",
               "क’रिया सानारि सम",
               "KST",
               "क’रिया सम",
               "KST",
            };
        final String[] Nauru = new String[] {
               "नाऊरु सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "नेपाल सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "पालाउ सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "साम’वा थाखोआरि सम",
               "SST",
               "साम’वा सानारि सम",
               "SST",
               "साम’वा सम",
               "SST",
            };
        final String[] Syowa = new String[] {
               "सीअवा सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "टंगा थाखोआरि सम",
               "",
               "टंगा दैज्लां सम",
               "",
               "टंगा सम",
               "",
            };
        final String[] Yukon = new String[] {
               "यूकन सम",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "आलास्का स्टेन्डार्ड सम",
               "AKST",
               "आलास्कानि सानारि सम",
               "AKDT",
               "आलास्कानि सम",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "आमाजन थाखोआऱि सम",
               "",
               "आमाजन दैज्लां सम",
               "",
               "आमाजन सम",
               "",
            };
        final String[] Azores = new String[] {
               "आज’र्सनि थाखोआरि सम",
               "",
               "आज’र्सनि दैज्लां सम",
               "",
               "आज’र्सनि सम",
               "",
            };
        final String[] Bhutan = new String[] {
               "भुटान सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ब्रुनेई दर उस सलाम स्टैंडर्ड टाईम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "सानजायारि द्वीप थाखोआरि सम",
               "",
               "सानजायारि द्वीप दैज्लां सम",
               "",
               "सानजायारि द्वीप सम",
               "",
            };
        final String[] Guyana = new String[] {
               "गुयाना सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "हावाई-एल्युतियान थाखोआरि सम",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "इज्राईल थाखोआरि सम",
               "IST",
               "इज्राईल सानारि सम",
               "IDT",
               "इज्राईल सम",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "कस्रे सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "मौसन सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "मस्कौ थाखोआरि सम",
               "MSK",
               "मस्कौ दैज्लां सम",
               "MSK",
               "मस्कौ सम",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "पनापे सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "समारा स्टैंडर्ड टाईम",
               "",
               "समारा समर टाईम",
               "",
               "समारा टाईम",
               "",
            };
        final String[] Tahiti = new String[] {
               "टाहिटी सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "ताईपेइ थाखोआरि सम",
               "CST",
               "ताईपेइ सानारि सम",
               "CDT",
               "ताईपेइ सम",
               "CT",
            };
        final String[] Turkey = new String[] {
               "तुर्की स्टैंडर्ड टाईम",
               "",
               "तुर्की समर टाईम",
               "",
               "तुर्की टाईम",
               "",
            };
        final String[] Tuvalu = new String[] {
               "तुभालु सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "भस्त’क सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "वालीस आरो फुतुना सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "आराबीयान थाखोआरि सम",
               "",
               "आराबीयान सानारि सम",
               "",
               "आराबीयान सम",
               "",
            };
        final String[] Armenia = new String[] {
               "आर्मेनिया थाखोआरि सम",
               "",
               "आर्मेनिया दैज्लां सम",
               "",
               "आर्मेनिया सम",
               "",
            };
        final String[] Bolivia = new String[] {
               "बलिभिया सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "चेथाम थाखोआरि सम",
               "",
               "चेथाम सानारि सम",
               "",
               "चेथाम सम",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "गोरोबहोनाय मुलुगनां सम",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "एकुवाडर सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "गाम्बियेर सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "जर्जिया थाखोआरि सम",
               "",
               "जर्जिया दैज्लां सम",
               "",
               "जर्जिया सम",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ईर्कुत्स्क थाखोआरि सम",
               "",
               "ईर्कुत्स्क दैज्लांं सम",
               "",
               "ईर्कुत्स्क सम",
               "",
            };
        final String[] Magadan = new String[] {
               "मागादान थाखोआरि सम",
               "",
               "मागादान दैज्लां सम",
               "",
               "मागादान सम",
               "",
            };
        final String[] Myanmar = new String[] {
               "म्यानमार स्टैंडर्ड टाईम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "नरफ’क द्वीप थाखोआरि सम",
               "",
               "नरफ’क द्वीप सानारि सम",
               "",
               "नरफ’क द्वीप सम",
               "",
            };
        final String[] Noronha = new String[] {
               "फेरनान्द’ दे नर’न्हा थाखोआरि सम",
               "",
               "फेरनान्द’ दे नर’न्हा दैज्लां सम",
               "",
               "फेरनान्द’ दे नर’न्हा सम",
               "",
            };
        final String[] Reunion = new String[] {
               "रियूनियन सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "रथेरा सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "सल’मन द्वीपफोरनि सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "टकेलौ सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "उरुगुवे थाखोआरि सम",
               "",
               "उरुगुवे दैज्लां सम",
               "",
               "उरुगुवे सम",
               "",
            };
        final String[] Vanuatu = new String[] {
               "वानुआटु थाखोआरि सम",
               "",
               "वानुआटु दैज्लां सम",
               "",
               "वानुआटु सम",
               "",
            };
        final String[] Yakutsk = new String[] {
               "याकुत्स्क थाखोआरि सम",
               "",
               "याकुत्स्क दैज्लां सम",
               "",
               "याकुत्स्क सम",
               "",
            };
        final String[] Atlantic = new String[] {
               "आटलान्टिक थाखोआरि सम",
               "AST",
               "आटलान्टिक सानारि सम",
               "AST",
               "आटलान्टिक सम",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ब्राजीलिया थाखोआरि सम",
               "",
               "ब्राजीलिया दैज्लां सम",
               "",
               "ब्राजीलिया सम",
               "",
            };
        final String[] Chamorro = new String[] {
               "चाम’र्र’ थाखोआरि सम",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "कलम्बिया थाखोआरि सम",
               "",
               "कलम्बिया दैज्लां सम",
               "",
               "कलम्बिया सम",
               "",
            };
        final String[] Falkland = new String[] {
               "फकलेण्ड द्वीपफोरनि थाखोआरि सम",
               "",
               "फकलेण्ड द्वीपफोरनि दैज्लां सम",
               "",
               "फकलेण्ड द्वीपफोरनि सम",
               "",
            };
        final String[] Malaysia = new String[] {
               "मलेशिया स्टैंडर्ड टाईम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "मालदीभ्स सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "उलानबातार थाखोआरि सम",
               "",
               "उलानबातार दैज्लां सम",
               "",
               "उलानबातार सम",
               "",
            };
        final String[] Pakistan = new String[] {
               "पाकिस्तान थाखोआरि सम",
               "PKT",
               "पाकिस्तान दैज्लां सम",
               "PKST",
               "पाकिस्तान सम",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "पारागुवे थाखोआरि सम",
               "",
               "पारागुवे दैज्लां सम",
               "",
               "पारागुवे सम",
               "",
            };
        final String[] Pitcairn = new String[] {
               "पीटकैर्न सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "सुरीनाम सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "आर्जेन्टिना थाखोआरि सम",
               "",
               "आर्जेन्टिना दैज्लां सम",
               "",
               "आर्जेन्टिना सम",
               "",
            };
        final String[] Christmas = new String[] {
               "ख्रीस्टमास द्वीप सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "गालापाग’स सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "हंकं थाखोआरि सम",
               "HKT",
               "हंकं दैज्लां सम",
               "HKST",
               "हंकं सम",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ईंडो चइना स्टैंडर्ड टाईम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "पेत्रोपावलोस्क कामचटका स्टैंडर्ड टाईम",
               "",
               "पेत्रोपावलोस्क कामचटका समर टाईम",
               "",
               "पेत्र’पाभ्ल’भ्स्क-कामचात्स्कि सम",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "कीर्गीस्तान सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "लर्ड हावि थाखोआरि सम",
               "",
               "लर्ड हावि सानारि सम",
               "",
               "लर्ड हावि सम",
               "",
            };
        final String[] Marquesas = new String[] {
               "मार्केसास सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "म’रिशियासनि थाखोआरि सम",
               "",
               "म’रिशियासनि दैज्लां सम",
               "",
               "म’रिशियासनि सम",
               "",
            };
        final String[] Singapore = new String[] {
               "सींगापुर स्टैंडर्ड टाईम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "भेनेजुवेला सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "आजारबाईजान थाखोआरि सम",
               "",
               "आजारबाईजान दैज्लां सम",
               "",
               "आजारबाईजान सम",
               "",
            };
        final String[] Bangladesh = new String[] {
               "बांलादेश थाखोआरि सम",
               "",
               "बांलादेश दैज्लां सम",
               "",
               "बांलादेश सम",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "केप भेर्दे थाखोआरि सम",
               "",
               "केप भेर्दे दैज्लां सम",
               "",
               "केप भेर्दे सम",
               "",
            };
        final String[] East_Timor = new String[] {
               "ईस्ट टीमोर स्टैंडर्ड टाईम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "सेशेल्स सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "ताजिकिस्तान सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "उजबेकिस्तान थाखोआरि सम",
               "",
               "उजबेकिस्तान दैज्लां सम",
               "",
               "उजबेकिस्तान सम",
               "",
            };
        final String[] Afghanistan = new String[] {
               "आफगानीस्तान सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "क्रास्न’यार्स्क थाखोआरि सम",
               "",
               "क्रास्न’यार्स्क दैज्लांं सम",
               "",
               "क्रास्न’यार्स्क सम",
               "",
            };
        final String[] New_Zealand = new String[] {
               "निउजिलेण्ड थाखोआरि सम",
               "NZST",
               "निउजिलेण्ड सानारि सम",
               "NZDT",
               "निउजिलेण्ड सम",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "फीलीपीन्स स्टैंडर्ड टाईम",
               "PST",
               "फीलीपीन्स समर टाईम",
               "PDT",
               "फिलीपीन्स सम",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "भ्लादिभस्त’क थाखोआरि सम",
               "",
               "भ्लादिभस्त’क दैज्लां सम",
               "",
               "भ्लादिभस्त’क सम",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "भारत लैथोमायारि सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "लाईन द्वीपफोरनि सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "निउफाउन्दलेन्द थाखोआरि सम",
               "NST",
               "निउफाउन्दलेन्द सानारि सम",
               "NDT",
               "निउफाउन्दलेन्द सम",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "तुर्कमेनीस्तान थाखोआरि सम",
               "",
               "तुर्कमेनीस्तान दैज्लां सम",
               "",
               "तुर्कमेनीस्तान सम",
               "",
            };
        final String[] French_Guiana = new String[] {
               "फ्रेन्च गुईयाना सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "गोदान केलेडनिया थाखोआरि सम",
               "",
               "गोदान केलेडनिया दैज्लां सम",
               "",
               "गोदान केलेडनिया सम",
               "",
            };
        final String[] South_Georgia = new String[] {
               "खोला जर्जिया सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "येकातेरीनाबुर्ग थाखोआरि सम",
               "",
               "येकातेरीनाबुर्ग दैज्लां सम",
               "",
               "येकातेरीनाबुर्ग सम",
               "",
            };
        final String[] Africa_Central = new String[] {
               "मिरु आफ्रिका सम",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "सानजा आफ्रिका सम",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "सोनाब आफ्रिकानि सम",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "डुमन्त-डीआर्भील सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "मिरु युर’पनि थाखोआरि सम",
               "CET",
               "मिरु युर’पनि दैज्लां सम",
               "CEST",
               "मिरु युर’पनि सम",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "सानजायारि युर’पनि थाखोआरि सम",
               "EET",
               "सानजायारि युर’पनि दैज्लां सम",
               "EEST",
               "सानजायारि युर’पनि सम",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "सोनाब युर’पनि थाखोआरि सम",
               "WET",
               "सोनाब युर’पनि दैज्लां सम",
               "WEST",
               "सोनाब युर’पनि सम",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "मेक्सिक’नि पेसिफिक थाखोआरि सम",
               "MST",
               "मेक्सिक’नि पेसिफिक सानारि सम",
               "MDT",
               "मेक्सिक’नि पेसिफिक सम",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "खोला आफ्रिकानि थाखोआरि सम",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "साहा आमेरिकानि मिरु मानथाखोआरि सम",
               "CST",
               "साहा आमेरिकानि मिरु सानारि सम",
               "CDT",
               "साहा आमेरिकानि मिरु सम",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "साहा आमेरिकानि सानजायारि थाखोआरि सम",
               "EST",
               "साहा आमेरिकानि सानजायारि सानारि सम",
               "EST",
               "साहा आमेरिकानि सानजायारि सम",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "साहा आमेरिकानि पेसिफिक थाखोआरि सम",
               "PST",
               "साहा आमेरिकानि पेसिफिक सानारि सम",
               "PDT",
               "साहा आमेरिकानि पेसिफिक सम",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "फ्रेन्च खोलायारि आरो एन्टार्कटिक सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "गीलबार्ट द्वीपफोरनि सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "हावाई-एल्युतियान थाखोआरि सम",
               "HST",
               "हावाई-एल्युतियान सानारि सम",
               "HDT",
               "हावाई-एल्युतियान सम",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "फनीक्स द्वीपफोरनि सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "सैन्ट पियेर आरो मिक्वेलन थाखोआरि सम",
               "",
               "सैन्ट पियेर आरो मिक्वेलन सानारि सम",
               "",
               "सैन्ट पियेर आरो मिक्वेलन सम",
               "",
            };
        final String[] America_Mountain = new String[] {
               "साहा आमेरिकानि हाजोमायारि थाखोआरि सम",
               "MST",
               "साहा आमोरिकानि हाजोमायारि सानारि सम",
               "MST",
               "साहा आमेरिकानि हाजोमायारि सम",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "मार्शेल द्वीपफोरनि सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "पापुआ निउ गिनी सम",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "अ’स्ट्रेलियानि मिरु थाखोआरि सम",
               "ACST",
               "अ’स्ट्रेलिया मिरु सानारि सम",
               "ACDT",
               "मिरु अ’स्ट्रेलिया सम",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "अस्ट्रेलियानि सानजायारि थाखोआरि सम",
               "AEST",
               "अस्ट्रेलियानि सानजायारि सानारि सम",
               "AEDT",
               "सानजायारि अस्ट्रेलिया सम",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "अस्ट्रेलियानि सोनाबारि थाखोआरि सम",
               "AWST",
               "अस्ट्रेलियानि सोनाबारि सानारि सम",
               "AWDT",
               "सोनाबारि अस्ट्रेलिया सम",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "ईंडोनीशिया स्टैंडर्ड टाईम",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "ईस्टर्न ईंडोनीशिया स्टैंडर्ड टाईम",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "वेस्टर्न ईंडोनीशिया स्टैंडर्ड टाईम",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "अस्ट्रेलियानि मिरु सोनाबारि थाखोआरि सम",
               "",
               "अस्ट्रेलियानि मिरु सोनाबारि सानारि सम",
               "",
               "अस्ट्रेलियानि मिरु सोनाबारि सम",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ग्रिनवीच गेजेरारि सम",
                    "GMT",
                    "ब्रीटीश दैज्लां सम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "गोरोबहोनाय मुलुगनां सम",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ग्रिनवीच गेजेरारि सम",
                    "GMT",
                    "आईरीश थाखोआरि सम",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "गोरोबहोनाय मुलुगनां सम",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "गोरोबहोनाय मुलुगनां सम",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ग्रिनवीच गेजेरारि सम",
                    "GMT",
                    "ब्रीटीश दैज्लां सम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "गोरोबहोनाय मुलुगनां सम",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "गोरोबहोनाय मुलुगनां सम",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "गोरोबहोनाय मुलुगनां सम",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ग्रिनवीच गेजेरारि सम",
                    "GMT",
                    "आईरीश थाखोआरि सम",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ग्रिनवीच गेजेरारि सम",
                    "GMT",
                    "ब्रीटीश दैज्लां सम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ग्रिनवीच गेजेरारि सम",
                    "GMT",
                    "ब्रीटीश दैज्लां सम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ग्रिनवीच गेजेरारि सम",
                    "GMT",
                    "ब्रीटीश दैज्लां सम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ग्रिनवीच गेजेरारि सम",
                    "GMT",
                    "ब्रीटीश दैज्लां सम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ग्रिनवीच गेजेरारि सम",
                    "GMT",
                    "ब्रीटीश दैज्लां सम",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "एडेन" },
            { "timezone.excity.Asia/Baku", "बाकू" },
            { "timezone.excity.Asia/Dili", "डिली" },
            { "timezone.excity.Asia/Gaza", "गाजा" },
            { "timezone.excity.Asia/Hovd", "ह’भ्द" },
            { "timezone.excity.Asia/Omsk", "अम्स्क" },
            { "timezone.excity.Asia/Oral", "अराल" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "आम्मान" },
            { "timezone.excity.Asia/Aqtau", "अक्ताउ" },
            { "timezone.excity.Asia/Chita", "चीता" },
            { "timezone.excity.Asia/Dhaka", "धाका" },
            { "timezone.excity.Asia/Dubai", "दुबाई" },
            { "timezone.excity.Asia/Kabul", "काबूल" },
            { "timezone.excity.Asia/Macau", "माकाऊ" },
            { "timezone.excity.Asia/Qatar", "कातार" },
            { "timezone.excity.Asia/Seoul", "स’उल" },
            { "timezone.excity.Asia/Tokyo", "ट’क्य’" },
            { "timezone.excity.Asia/Tomsk", "तम्स्क" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "जुबा" },
            { "timezone.excity.Africa/Lome", "लमे" },
            { "timezone.excity.Asia/Almaty", "आल्माटी" },
            { "timezone.excity.Asia/Anadyr", "आनाडीर" },
            { "timezone.excity.Asia/Aqtobe", "आक्त’बे" },
            { "timezone.excity.Asia/Atyrau", "आतीराउ" },
            { "timezone.excity.Asia/Beirut", "बैरुत" },
            { "timezone.excity.Asia/Brunei", "ब्रुनइ" },
            { "timezone.excity.Asia/Hebron", "हेब्र’न" },
            { "timezone.excity.Asia/Kuwait", "कुवैत" },
            { "timezone.excity.Asia/Manila", "मनीला" },
            { "timezone.excity.Asia/Muscat", "मास्केट" },
            { "timezone.excity.Asia/Riyadh", "रियाध" },
            { "timezone.excity.Asia/Saigon", "साइगॉन" },
            { "timezone.excity.Asia/Taipei", "ताईपेइ" },
            { "timezone.excity.Asia/Tehran", "तेहरान" },
            { "timezone.excity.Asia/Urumqi", "उरुमकी" },
            { "timezone.excity.Etc/Unknown", "मिथियै नोगोर" },
            { "timezone.excity.Europe/Kiev", "कीभ" },
            { "timezone.excity.Europe/Oslo", "अस्ल’" },
            { "timezone.excity.Europe/Riga", "रिगा" },
            { "timezone.excity.Europe/Rome", "र’म" },
            { "timezone.excity.Indian/Mahe", "माहे" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "आक्रा" },
            { "timezone.excity.Africa/Cairo", "कायर’" },
            { "timezone.excity.Africa/Ceuta", "सेउता" },
            { "timezone.excity.Africa/Dakar", "डाकार" },
            { "timezone.excity.Africa/Lagos", "लाग’स" },
            { "timezone.excity.Africa/Tunis", "ट्यूनिस" },
            { "timezone.excity.America/Adak", "एडेक" },
            { "timezone.excity.America/Lima", "लीमा" },
            { "timezone.excity.America/Nome", "न’म" },
            { "timezone.excity.Asia/Baghdad", "बाघदाद" },
            { "timezone.excity.Asia/Bahrain", "बाहरैन" },
            { "timezone.excity.Asia/Bangkok", "बैंगकॉक" },
            { "timezone.excity.Asia/Barnaul", "बार्नौल" },
            { "timezone.excity.Asia/Bishkek", "बिश्केक" },
            { "timezone.excity.Asia/Colombo", "कलम्ब’" },
            { "timezone.excity.Asia/Irkutsk", "ईर्कुत्स्क" },
            { "timezone.excity.Asia/Jakarta", "जाकार्ता" },
            { "timezone.excity.Asia/Karachi", "कराची" },
            { "timezone.excity.Asia/Kuching", "कूचिंग" },
            { "timezone.excity.Asia/Magadan", "मागादान" },
            { "timezone.excity.Asia/Nicosia", "निक’सिया" },
            { "timezone.excity.Asia/Rangoon", "रंगून" },
            { "timezone.excity.Asia/Tbilisi", "तिबिलिसी" },
            { "timezone.excity.Asia/Thimphu", "थिम्फु" },
            { "timezone.excity.Asia/Yakutsk", "याकूत्स्क" },
            { "timezone.excity.Asia/Yerevan", "येरेभान" },
            { "timezone.excity.Europe/Kirov", "किर’भ" },
            { "timezone.excity.Europe/Malta", "माल्टा" },
            { "timezone.excity.Europe/Minsk", "मिन्स्क" },
            { "timezone.excity.Europe/Paris", "पेरिस" },
            { "timezone.excity.Europe/Sofia", "सफिया" },
            { "timezone.excity.Europe/Vaduz", "भाडुज" },
            { "timezone.excity.Indian/Cocos", "कक’स" },
            { "timezone.excity.Pacific/Apia", "आपिया" },
            { "timezone.excity.Pacific/Fiji", "फिजी" },
            { "timezone.excity.Pacific/Guam", "गुवाम" },
            { "timezone.excity.Pacific/Niue", "नीऊए" },
            { "timezone.excity.Pacific/Truk", "चूक" },
            { "timezone.excity.Pacific/Wake", "वेक" },
            { "timezone.excity.Africa/Asmera", "आस्मारा" },
            { "timezone.excity.Africa/Bamako", "बामाक’" },
            { "timezone.excity.Africa/Bangui", "बांगूई" },
            { "timezone.excity.Africa/Banjul", "बन्जुल" },
            { "timezone.excity.Africa/Bissau", "बिस्साउ" },
            { "timezone.excity.Africa/Douala", "दुआला" },
            { "timezone.excity.Africa/Harare", "हारारे" },
            { "timezone.excity.Africa/Kigali", "किगालि" },
            { "timezone.excity.Africa/Luanda", "लुआन्डा" },
            { "timezone.excity.Africa/Lusaka", "लुसाका" },
            { "timezone.excity.Africa/Malabo", "मालाब’" },
            { "timezone.excity.Africa/Maputo", "मापुट’" },
            { "timezone.excity.Africa/Maseru", "मासेरू" },
            { "timezone.excity.Africa/Niamey", "नीआमे" },
            { "timezone.excity.America/Aruba", "आरूबा" },
            { "timezone.excity.America/Bahia", "बाहिया" },
            { "timezone.excity.America/Belem", "बेलेम" },
            { "timezone.excity.America/Boise", "बयसि" },
            { "timezone.excity.America/Jujuy", "जुजुई" },
            { "timezone.excity.America/Sitka", "सित्का" },
            { "timezone.excity.America/Thule", "थ्यूल" },
            { "timezone.excity.Asia/Ashgabat", "अश्गाबात" },
            { "timezone.excity.Asia/Calcutta", "कलकाता" },
            { "timezone.excity.Asia/Damascus", "दामास्कास" },
            { "timezone.excity.Asia/Dushanbe", "दुशान्बे" },
            { "timezone.excity.Asia/Jayapura", "जयापुरा" },
            { "timezone.excity.Asia/Katmandu", "काठमान्डु" },
            { "timezone.excity.Asia/Khandyga", "खान्दीगा" },
            { "timezone.excity.Asia/Makassar", "माकास्सार" },
            { "timezone.excity.Asia/Qostanay", "कस्तानै" },
            { "timezone.excity.Asia/Sakhalin", "साखालिन" },
            { "timezone.excity.Asia/Shanghai", "शांघाई" },
            { "timezone.excity.Asia/Tashkent", "ताशकेन्त" },
            { "timezone.excity.Asia/Ust-Nera", "आस्त-नेरा" },
            { "timezone.excity.Europe/Athens", "एथेन्स" },
            { "timezone.excity.Europe/Berlin", "बार्लिन" },
            { "timezone.excity.Europe/Dublin", "डाबलिन" },
            { "timezone.excity.Europe/Jersey", "जार्सी" },
            { "timezone.excity.Europe/Lisbon", "लिस्बन" },
            { "timezone.excity.Europe/London", "लन्दन" },
            { "timezone.excity.Europe/Madrid", "माद्रिद" },
            { "timezone.excity.Europe/Monaco", "मनाक’" },
            { "timezone.excity.Europe/Moscow", "मस्कौ" },
            { "timezone.excity.Europe/Prague", "प्रेग" },
            { "timezone.excity.Europe/Samara", "सामारा" },
            { "timezone.excity.Europe/Skopje", "स्क’प्जे" },
            { "timezone.excity.Europe/Tirane", "टिरेन" },
            { "timezone.excity.Europe/Vienna", "भियेन्ना" },
            { "timezone.excity.Europe/Warsaw", "वारसौ" },
            { "timezone.excity.Europe/Zagreb", "जाग्रेब" },
            { "timezone.excity.Europe/Zurich", "जुरिख" },
            { "timezone.excity.Indian/Chagos", "चाग’स" },
            { "timezone.excity.Indian/Comoro", "कम’र’" },
            { "timezone.excity.Pacific/Efate", "एफाटे" },
            { "timezone.excity.Pacific/Nauru", "नाऊरु" },
            { "timezone.excity.Pacific/Palau", "पालाउ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "अबिदजान" },
            { "timezone.excity.Africa/Algiers", "आल्जीएर्स" },
            { "timezone.excity.Africa/Conakry", "कनाक्री" },
            { "timezone.excity.Africa/Kampala", "काम्पाला" },
            { "timezone.excity.Africa/Mbabane", "म्बाबाने" },
            { "timezone.excity.Africa/Nairobi", "नाईरौबी" },
            { "timezone.excity.Africa/Tripoli", "त्रिप’ली" },
            { "timezone.excity.America/Belize", "बेलिज" },
            { "timezone.excity.America/Bogota", "बग’टा" },
            { "timezone.excity.America/Cancun", "कांकुन" },
            { "timezone.excity.America/Cayman", "कैमेन" },
            { "timezone.excity.America/Cuiaba", "कुईआबा" },
            { "timezone.excity.America/Dawson", "डावस’न" },
            { "timezone.excity.America/Denver", "डेनभोर" },
            { "timezone.excity.America/Guyana", "गुयाना" },
            { "timezone.excity.America/Havana", "हाभाना" },
            { "timezone.excity.America/Inuvik", "इनूविक" },
            { "timezone.excity.America/Juneau", "जुनो" },
            { "timezone.excity.America/La_Paz", "ला पाज" },
            { "timezone.excity.America/Maceio", "माचेईओ" },
            { "timezone.excity.America/Manaus", "मनाउस" },
            { "timezone.excity.America/Merida", "मेरिडा" },
            { "timezone.excity.America/Nassau", "नास्साउ" },
            { "timezone.excity.America/Panama", "पानामा" },
            { "timezone.excity.America/Recife", "रेसिफे" },
            { "timezone.excity.America/Regina", "रेजिना" },
            { "timezone.excity.Asia/Famagusta", "फामागुस्ता" },
            { "timezone.excity.Asia/Hong_Kong", "हंकं" },
            { "timezone.excity.Asia/Jerusalem", "जेरुजालेम" },
            { "timezone.excity.Asia/Kamchatka", "कामचाटका" },
            { "timezone.excity.Asia/Pontianak", "पोंतिआनाक" },
            { "timezone.excity.Asia/Pyongyang", "प्यंयां" },
            { "timezone.excity.Asia/Qyzylorda", "कीजीलर्डा" },
            { "timezone.excity.Asia/Samarkand", "समरकान्द" },
            { "timezone.excity.Asia/Singapore", "सिंगापुर" },
            { "timezone.excity.Asia/Vientiane", "वियंसियान" },
            { "timezone.excity.Europe/Andorra", "आन्ड’रा" },
            { "timezone.excity.Europe/Saratov", "सारात’भ" },
            { "timezone.excity.Europe/Tallinn", "टेलिन" },
            { "timezone.excity.Europe/Vatican", "भेटिकान" },
            { "timezone.excity.Europe/Vilnius", "विल्निउस" },
            { "timezone.excity.Indian/Mayotte", "माय’त्ते" },
            { "timezone.excity.Indian/Reunion", "रेयूनिय’न" },
            { "timezone.excity.Pacific/Easter", "सानजायारि" },
            { "timezone.excity.Pacific/Kosrae", "कस्रे" },
            { "timezone.excity.Pacific/Majuro", "माजूर’" },
            { "timezone.excity.Pacific/Midway", "मीडवे" },
            { "timezone.excity.Pacific/Noumea", "नूमिया" },
            { "timezone.excity.Pacific/Ponape", "पनापे" },
            { "timezone.excity.Pacific/Saipan", "साइपान" },
            { "timezone.excity.Pacific/Tahiti", "टाहिटी" },
            { "timezone.excity.Pacific/Tarawa", "तारावा" },
            { "timezone.excity.Pacific/Wallis", "वालिस" },
            { "timezone.excity.Africa/Blantyre", "ब्लान्टाईर" },
            { "timezone.excity.Africa/Djibouti", "जिबौटी" },
            { "timezone.excity.Africa/El_Aaiun", "एल आइऊन" },
            { "timezone.excity.Africa/Freetown", "फ्रीटाउन" },
            { "timezone.excity.Africa/Gaborone", "गैबोरोन" },
            { "timezone.excity.Africa/Khartoum", "खार्तूम" },
            { "timezone.excity.Africa/Kinshasa", "किन्शासा" },
            { "timezone.excity.Africa/Monrovia", "मन्र’भिया" },
            { "timezone.excity.Africa/Ndjamena", "न्जामेना" },
            { "timezone.excity.Africa/Sao_Tome", "साव टमे" },
            { "timezone.excity.Africa/Windhoek", "विन्दह’क" },
            { "timezone.excity.America/Antigua", "एन्टिगुवा" },
            { "timezone.excity.America/Caracas", "काराकास" },
            { "timezone.excity.America/Cayenne", "कायेन" },
            { "timezone.excity.America/Chicago", "शिकाग’" },
            { "timezone.excity.America/Cordoba", "कर्डबा" },
            { "timezone.excity.America/Creston", "क्रेस्टन" },
            { "timezone.excity.America/Curacao", "कूरासाव" },
            { "timezone.excity.America/Detroit", "डेट्र’ईत" },
            { "timezone.excity.America/Godthab", "नूक" },
            { "timezone.excity.America/Grenada", "ग्रेनाडा" },
            { "timezone.excity.America/Halifax", "हेलिफेक्स" },
            { "timezone.excity.America/Iqaluit", "इकालुईत" },
            { "timezone.excity.America/Jamaica", "जामाईका" },
            { "timezone.excity.America/Managua", "मनागुआ" },
            { "timezone.excity.America/Marigot", "मेरिगत" },
            { "timezone.excity.America/Mendoza", "मेन्ड’जा" },
            { "timezone.excity.America/Moncton", "मक्ट’न" },
            { "timezone.excity.America/Noronha", "नर’न्हा" },
            { "timezone.excity.America/Ojinaga", "आजिनागा" },
            { "timezone.excity.America/Phoenix", "फीनिक्स" },
            { "timezone.excity.America/Tijuana", "टिहुआना" },
            { "timezone.excity.America/Toronto", "टरन्ट’" },
            { "timezone.excity.America/Tortola", "टर्त’ला" },
            { "timezone.excity.America/Yakutat", "याकुतात" },
            { "timezone.excity.Asia/Phnom_Penh", "नॉम पेन" },
            { "timezone.excity.Atlantic/Azores", "आज’र्स" },
            { "timezone.excity.Atlantic/Canary", "केनेरी" },
            { "timezone.excity.Atlantic/Faeroe", "फेरौ" },
            { "timezone.excity.Australia/Eucla", "यूक्ला" },
            { "timezone.excity.Australia/Perth", "पोर्थ" },
            { "timezone.excity.Europe/Belgrade", "बेलग्रेड" },
            { "timezone.excity.Europe/Brussels", "ब्रुस्सेल्स" },
            { "timezone.excity.Europe/Budapest", "बुदापेस्ट" },
            { "timezone.excity.Europe/Busingen", "बुसिंगेन" },
            { "timezone.excity.Europe/Chisinau", "चिसीनौ" },
            { "timezone.excity.Europe/Guernsey", "गार्नसी" },
            { "timezone.excity.Europe/Helsinki", "हेल्सिंकी" },
            { "timezone.excity.Europe/Istanbul", "इस्तानबुल" },
            { "timezone.excity.Europe/Sarajevo", "साराजेभ’" },
            { "timezone.excity.Indian/Maldives", "मालदीभ्स" },
            { "timezone.excity.Pacific/Chatham", "चाथाम" },
            { "timezone.excity.Pacific/Fakaofo", "फाकाअफ’" },
            { "timezone.excity.Pacific/Gambier", "गाम्बियेर" },
            { "timezone.excity.Pacific/Norfolk", "नरफ’क" },
            { "timezone.excity.Africa/Bujumbura", "बुजुम्बुरा" },
            { "timezone.excity.Africa/Mogadishu", "मगाडिशु" },
            { "timezone.excity.America/Anguilla", "एंग्वीला" },
            { "timezone.excity.America/Asuncion", "आसुनसीअन" },
            { "timezone.excity.America/Barbados", "बार्बाड’स" },
            { "timezone.excity.America/Dominica", "डमिनिका" },
            { "timezone.excity.America/Edmonton", "एडमन्टन" },
            { "timezone.excity.America/Eirunepe", "एईरुनेपे" },
            { "timezone.excity.America/Mazatlan", "माजाटलान" },
            { "timezone.excity.America/Miquelon", "मिक्वेल’न" },
            { "timezone.excity.America/New_York", "निउ यर्क" },
            { "timezone.excity.America/Resolute", "रेजल्युत" },
            { "timezone.excity.America/Santarem", "सान्तारेम" },
            { "timezone.excity.America/Santiago", "सान्तिआग’" },
            { "timezone.excity.America/St_Johns", "सैन्ट जन्स" },
            { "timezone.excity.America/St_Kitts", "सैन्ट कीत्स" },
            { "timezone.excity.America/St_Lucia", "सैन्ट लुसिया" },
            { "timezone.excity.America/Winnipeg", "वीनीपेग" },
            { "timezone.excity.Antarctica/Casey", "केसी" },
            { "timezone.excity.Antarctica/Davis", "डेभिस" },
            { "timezone.excity.Antarctica/Syowa", "सीअवा" },
            { "timezone.excity.Antarctica/Troll", "त्र’ल" },
            { "timezone.excity.Asia/Krasnoyarsk", "क्रास्न’यार्स्क" },
            { "timezone.excity.Asia/Novosibirsk", "नभ’सिबिर्स्क" },
            { "timezone.excity.Asia/Ulaanbaatar", "उलानबातार" },
            { "timezone.excity.Asia/Vladivostok", "भ्लादिभस्त’क" },
            { "timezone.excity.Atlantic/Bermuda", "बार्मुडा" },
            { "timezone.excity.Atlantic/Madeira", "माडैरा" },
            { "timezone.excity.Atlantic/Stanley", "स्टेनली" },
            { "timezone.excity.Australia/Darwin", "डार्वीन" },
            { "timezone.excity.Australia/Hobart", "हबार्ट" },
            { "timezone.excity.Australia/Sydney", "सिडनी" },
            { "timezone.excity.Europe/Amsterdam", "ऐम्स्टरडाम" },
            { "timezone.excity.Europe/Astrakhan", "आस्त्राखान" },
            { "timezone.excity.Europe/Bucharest", "बुकारेस्ट" },
            { "timezone.excity.Europe/Gibraltar", "जिब्राल्टार" },
            { "timezone.excity.Europe/Ljubljana", "जुब्ल्याना" },
            { "timezone.excity.Europe/Mariehamn", "मारैहाम" },
            { "timezone.excity.Europe/Podgorica", "पदग’रिका" },
            { "timezone.excity.Europe/Stockholm", "स्ट’कह’म" },
            { "timezone.excity.Europe/Ulyanovsk", "ऊल्यान’भ्स्क" },
            { "timezone.excity.Europe/Volgograd", "भल्ग’ग्रेद" },
            { "timezone.excity.Indian/Christmas", "ख्रीस्टमास द्वीप" },
            { "timezone.excity.Indian/Kerguelen", "केर्गेलेन" },
            { "timezone.excity.Indian/Mauritius", "मरिशियास" },
            { "timezone.excity.Pacific/Auckland", "औकलैण्ड" },
            { "timezone.excity.Pacific/Funafuti", "फुनाफूटी" },
            { "timezone.excity.Pacific/Honolulu", "हनलुलु" },
            { "timezone.excity.Pacific/Pitcairn", "पिटकैर्न" },
            { "timezone.excity.Africa/Casablanca", "कासाब्लांका" },
            { "timezone.excity.Africa/Libreville", "लिब्रेभिल" },
            { "timezone.excity.Africa/Lubumbashi", "लुबुम्बाशी" },
            { "timezone.excity.Africa/Nouakchott", "न्वाकश’त" },
            { "timezone.excity.Africa/Porto-Novo", "पर्ट’-नभ’" },
            { "timezone.excity.America/Anchorage", "एंकरेज" },
            { "timezone.excity.America/Araguaina", "आरागुआईना" },
            { "timezone.excity.America/Boa_Vista", "बआ भिस्ता" },
            { "timezone.excity.America/Catamarca", "काटामार्का" },
            { "timezone.excity.America/Chihuahua", "चुहभाभा" },
            { "timezone.excity.America/Fortaleza", "फर्टालेजा" },
            { "timezone.excity.America/Glace_Bay", "ग्लेस बेइ" },
            { "timezone.excity.America/Goose_Bay", "गूज बेइ" },
            { "timezone.excity.America/Guatemala", "ग्वाटेमाला" },
            { "timezone.excity.America/Guayaquil", "गुआयाकिल" },
            { "timezone.excity.America/Matamoros", "मेतामरस" },
            { "timezone.excity.America/Menominee", "मेन’मीनी" },
            { "timezone.excity.America/Monterrey", "मन्टेर्रे" },
            { "timezone.excity.America/Sao_Paulo", "साव पावल’" },
            { "timezone.excity.America/St_Thomas", "सैन्ट थमास" },
            { "timezone.excity.America/Vancouver", "भेनकूभर" },
            { "timezone.excity.Antarctica/Mawson", "मौसन" },
            { "timezone.excity.Antarctica/Palmer", "पालमार" },
            { "timezone.excity.Antarctica/Vostok", "भस्त’क" },
            { "timezone.excity.Asia/Kuala_Lumpur", "क्वाला लम्पुर" },
            { "timezone.excity.Asia/Novokuznetsk", "नभ’कुज्नेत्स्क" },
            { "timezone.excity.Europe/Bratislava", "ब्रातिस्लाभा" },
            { "timezone.excity.Europe/Copenhagen", "कपेनहेगेन" },
            { "timezone.excity.Europe/Luxembourg", "लाक्जेम्बार्ग" },
            { "timezone.excity.Europe/San_Marino", "सान मारिन’" },
            { "timezone.excity.Europe/Simferopol", "सिम्फेर’प’ल" },
            { "timezone.excity.Pacific/Enderbury", "केन्ट’न" },
            { "timezone.excity.Pacific/Galapagos", "गालापाग’स" },
            { "timezone.excity.Pacific/Kwajalein", "क्वाजालैन" },
            { "timezone.excity.Pacific/Marquesas", "मार्केसास" },
            { "timezone.excity.Pacific/Pago_Pago", "पाग’ पाग’" },
            { "timezone.excity.Pacific/Rarotonga", "रार’टंगा" },
            { "timezone.excity.Pacific/Tongatapu", "टंगाटापु" },
            { "timezone.excity.Africa/Addis_Ababa", "एद्दिस आबाबा" },
            { "timezone.excity.Africa/Brazzaville", "ब्राज्जाभील" },
            { "timezone.excity.Africa/Ouagadougou", "ऊगाडुगु" },
            { "timezone.excity.America/Costa_Rica", "कस्टा रिका" },
            { "timezone.excity.America/Grand_Turk", "ग्रेण्ड तार्क" },
            { "timezone.excity.America/Guadeloupe", "ग्वादेलूप" },
            { "timezone.excity.America/Hermosillo", "हार्म’सिल्ल’" },
            { "timezone.excity.America/Kralendijk", "क्रालेणजीक" },
            { "timezone.excity.America/Louisville", "लुईवील" },
            { "timezone.excity.America/Martinique", "मार्टीनीक" },
            { "timezone.excity.America/Metlakatla", "मेत्लाकात्ला" },
            { "timezone.excity.America/Montevideo", "मन्टेभिडिअ" },
            { "timezone.excity.America/Montserrat", "मनसेर्रात" },
            { "timezone.excity.America/Paramaribo", "पारामारिब’" },
            { "timezone.excity.America/Rio_Branco", "रिअ ब्रान्क’" },
            { "timezone.excity.America/St_Vincent", "सैन्ट भिन्सेन्ट" },
            { "timezone.excity.America/Whitehorse", "व्हाईतहर्स" },
            { "timezone.excity.Antarctica/McMurdo", "मेकमार्ड’" },
            { "timezone.excity.Antarctica/Rothera", "रथेरा" },
            { "timezone.excity.Asia/Srednekolymsk", "स्रेदनेक’लिम्स्क" },
            { "timezone.excity.Asia/Yekaterinburg", "येकातेरीनाबुर्ग" },
            { "timezone.excity.Atlantic/Reykjavik", "रीकयाभिक" },
            { "timezone.excity.Atlantic/St_Helena", "सैन्ट हेलेना" },
            { "timezone.excity.Australia/Adelaide", "एडेलैड" },
            { "timezone.excity.Australia/Brisbane", "ब्रीसबेन" },
            { "timezone.excity.Australia/Lindeman", "लिण्डमेन" },
            { "timezone.excity.Europe/Isle_of_Man", "आयोल अफ मेन" },
            { "timezone.excity.Europe/Kaliningrad", "कालिनींग्राद" },
            { "timezone.excity.Pacific/Kiritimati", "किरीतिमाति" },
            { "timezone.excity.Africa/Johannesburg", "जहान्सबार्ग" },
            { "timezone.excity.America/El_Salvador", "एल साल्भाडर" },
            { "timezone.excity.America/Fort_Nelson", "फर्त नेलसन" },
            { "timezone.excity.America/Los_Angeles", "लस एन्जेलोस" },
            { "timezone.excity.America/Mexico_City", "मेक्सिक’ सिती" },
            { "timezone.excity.America/Porto_Velho", "पर्ट’ भेल्ह’" },
            { "timezone.excity.America/Puerto_Rico", "पुएर्ट’ रिक’" },
            { "timezone.excity.America/Tegucigalpa", "तेगुसिगाल्पा" },
            { "timezone.excity.Arctic/Longyearbyen", "लंयारब्येन" },
            { "timezone.excity.Atlantic/Cape_Verde", "केप भेर्दे" },
            { "timezone.excity.Australia/Lord_Howe", "लर्ड हावि" },
            { "timezone.excity.Australia/Melbourne", "मेलबौर्न" },
            { "timezone.excity.Indian/Antananarivo", "एन्टानानारिभ’" },
            { "timezone.excity.Pacific/Guadalcanal", "ग्वाडालकेनेल" },
            { "timezone.excity.Africa/Dar_es_Salaam", "दार एस सलाम" },
            { "timezone.excity.America/Blanc-Sablon", "ब्लांक- साब्लन" },
            { "timezone.excity.America/Buenos_Aires", "बुएन’स एरेस" },
            { "timezone.excity.America/Campo_Grande", "केम्प ग्रान्ड" },
            { "timezone.excity.America/Danmarkshavn", "डानमार्कस्भान" },
            { "timezone.excity.America/Dawson_Creek", "डावस’न क्रीक" },
            { "timezone.excity.America/Indiana/Knox", "नक्स, इण्डियाना" },
            { "timezone.excity.America/Indianapolis", "इण्डियानापलिस" },
            { "timezone.excity.America/Punta_Arenas", "पुन्टा आरेनास" },
            { "timezone.excity.America/Rankin_Inlet", "रेनकिन इनलेट" },
            { "timezone.excity.America/Scoresbysund", "ईत्त’क्वर्तूमी" },
            { "timezone.excity.Antarctica/Macquarie", "माक्वारी" },
            { "timezone.excity.Pacific/Bougainville", "बुगैनभील" },
            { "timezone.excity.Pacific/Port_Moresby", "पर्ट मर्सबी" },
            { "timezone.excity.America/Cambridge_Bay", "केम्ब्रिज गाथोन" },
            { "timezone.excity.America/Coral_Harbour", "आतिककान" },
            { "timezone.excity.America/Indiana/Vevay", "भेभै, इण्डियाना" },
            { "timezone.excity.America/Lower_Princes", "लवार प्रिन्सोस क्वार्तार" },
            { "timezone.excity.America/Port_of_Spain", "पर्ट अफ स्पैन" },
            { "timezone.excity.America/Santo_Domingo", "सान्तो डमिग’" },
            { "timezone.excity.America/St_Barthelemy", "सैन्ट बार्थेलेमी" },
            { "timezone.excity.America/Swift_Current", "सुईफत कार्रेन्त" },
            { "timezone.excity.Australia/Broken_Hill", "ब्र’केन हिल" },
            { "timezone.excity.America/Bahia_Banderas", "बाहिया बान्देरास" },
            { "timezone.excity.America/Port-au-Prince", "पर्ट-आऊ-प्रिन्स" },
            { "timezone.excity.Atlantic/South_Georgia", "खोला जर्जिया" },
            { "timezone.excity.America/Argentina/Salta", "साल्टा" },
            { "timezone.excity.America/Indiana/Marengo", "मारेङ’, इण्डियाना" },
            { "timezone.excity.America/Indiana/Winamac", "विनामेक, इण्डियाना" },
            { "timezone.excity.America/Argentina/Tucuman", "टुकुमान" },
            { "timezone.excity.America/Argentina/Ushuaia", "उशूआयिया" },
            { "timezone.excity.America/Indiana/Tell_City", "तेल नोगोर, इण्डियाना" },
            { "timezone.excity.America/Indiana/Vincennes", "भानसेन्नेस, इण्डियाना" },
            { "timezone.excity.Antarctica/DumontDUrville", "डुमन्त-डीआर्भील" },
            { "timezone.excity.America/Argentina/La_Rioja", "ला रिअजा" },
            { "timezone.excity.America/Argentina/San_Juan", "सान हुवान" },
            { "timezone.excity.America/Argentina/San_Luis", "सान लुईस" },
            { "timezone.excity.America/Indiana/Petersburg", "पितार्सबार्ग, इण्डियाना" },
            { "timezone.excity.America/Kentucky/Monticello", "मन्टिछेल’, केन्टाकी" },
            { "timezone.excity.America/North_Dakota/Beulah", "बेऊलाह, साहा डाक’ता" },
            { "timezone.excity.America/North_Dakota/Center", "सेन्टोर, साहा डाक’ता" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "रिअ गालेगस" },
            { "timezone.excity.America/North_Dakota/New_Salem", "निउ सालेम, साहा डाक’ता" },
        };
        return data;
    }
}
