// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Function describes a function, including its human-readable name, system name, source file, and starting line number in the source.
type Function struct {
	NameStrindex       int32
	SystemNameStrindex int32
	FilenameStrindex   int32
	StartLine          int64
}

var (
	protoPoolFunction = sync.Pool{
		New: func() any {
			return &Function{}
		},
	}
)

func NewFunction() *Function {
	if !UseProtoPooling.IsEnabled() {
		return &Function{}
	}
	return protoPoolFunction.Get().(*Function)
}

func DeleteFunction(orig *Function, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolFunction.Put(orig)
	}
}

func CopyFunction(dest, src *Function) *Function {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewFunction()
	}
	dest.NameStrindex = src.NameStrindex
	dest.SystemNameStrindex = src.SystemNameStrindex
	dest.FilenameStrindex = src.FilenameStrindex
	dest.StartLine = src.StartLine

	return dest
}

func CopyFunctionSlice(dest, src []Function) []Function {
	var newDest []Function
	if cap(dest) < len(src) {
		newDest = make([]Function, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteFunction(&dest[i], false)
		}
	}
	for i := range src {
		CopyFunction(&newDest[i], &src[i])
	}
	return newDest
}

func CopyFunctionPtrSlice(dest, src []*Function) []*Function {
	var newDest []*Function
	if cap(dest) < len(src) {
		newDest = make([]*Function, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewFunction()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteFunction(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewFunction()
		}
	}
	for i := range src {
		CopyFunction(newDest[i], src[i])
	}
	return newDest
}

func (orig *Function) Reset() {
	*orig = Function{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Function) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.NameStrindex != int32(0) {
		dest.WriteObjectField("nameStrindex")
		dest.WriteInt32(orig.NameStrindex)
	}
	if orig.SystemNameStrindex != int32(0) {
		dest.WriteObjectField("systemNameStrindex")
		dest.WriteInt32(orig.SystemNameStrindex)
	}
	if orig.FilenameStrindex != int32(0) {
		dest.WriteObjectField("filenameStrindex")
		dest.WriteInt32(orig.FilenameStrindex)
	}
	if orig.StartLine != int64(0) {
		dest.WriteObjectField("startLine")
		dest.WriteInt64(orig.StartLine)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Function) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "nameStrindex", "name_strindex":
			orig.NameStrindex = iter.ReadInt32()
		case "systemNameStrindex", "system_name_strindex":
			orig.SystemNameStrindex = iter.ReadInt32()
		case "filenameStrindex", "filename_strindex":
			orig.FilenameStrindex = iter.ReadInt32()
		case "startLine", "start_line":
			orig.StartLine = iter.ReadInt64()
		default:
			iter.Skip()
		}
	}
}

func (orig *Function) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.NameStrindex != int32(0) {
		n += 1 + proto.Sov(uint64(orig.NameStrindex))
	}
	if orig.SystemNameStrindex != int32(0) {
		n += 1 + proto.Sov(uint64(orig.SystemNameStrindex))
	}
	if orig.FilenameStrindex != int32(0) {
		n += 1 + proto.Sov(uint64(orig.FilenameStrindex))
	}
	if orig.StartLine != int64(0) {
		n += 1 + proto.Sov(uint64(orig.StartLine))
	}
	return n
}

func (orig *Function) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.NameStrindex != int32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.NameStrindex))
		pos--
		buf[pos] = 0x8
	}
	if orig.SystemNameStrindex != int32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.SystemNameStrindex))
		pos--
		buf[pos] = 0x10
	}
	if orig.FilenameStrindex != int32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.FilenameStrindex))
		pos--
		buf[pos] = 0x18
	}
	if orig.StartLine != int64(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.StartLine))
		pos--
		buf[pos] = 0x20
	}
	return len(buf) - pos
}

func (orig *Function) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field NameStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.NameStrindex = int32(num)

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemNameStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.SystemNameStrindex = int32(num)

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field FilenameStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.FilenameStrindex = int32(num)

		case 4:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field StartLine", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.StartLine = int64(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestFunction() *Function {
	orig := NewFunction()
	orig.NameStrindex = int32(13)
	orig.SystemNameStrindex = int32(13)
	orig.FilenameStrindex = int32(13)
	orig.StartLine = int64(13)
	return orig
}

func GenTestFunctionPtrSlice() []*Function {
	orig := make([]*Function, 5)
	orig[0] = NewFunction()
	orig[1] = GenTestFunction()
	orig[2] = NewFunction()
	orig[3] = GenTestFunction()
	orig[4] = NewFunction()
	return orig
}

func GenTestFunctionSlice() []Function {
	orig := make([]Function, 5)
	orig[1] = *GenTestFunction()
	orig[3] = *GenTestFunction()
	return orig
}
