//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

extern "C" {
    /// Name of the filter
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributefiltername?language=objc)
    pub static kCIAttributeFilterName: &'static NSString;
}

extern "C" {
    /// Name of the filter intended for UI display (eg. localized)
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributefilterdisplayname?language=objc)
    pub static kCIAttributeFilterDisplayName: &'static NSString;
}

extern "C" {
    /// Description of the filter intended for UI display (eg. localized)
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributedescription?language=objc)
    pub static kCIAttributeDescription: &'static NSString;
}

extern "C" {
    /// The version of OS X and iOS a filter was first available in.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributefilteravailable_mac?language=objc)
    pub static kCIAttributeFilterAvailable_Mac: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributefilteravailable_ios?language=objc)
    pub static kCIAttributeFilterAvailable_iOS: &'static NSString;
}

extern "C" {
    /// URL for the reference documentation of the filter. See localizedReferenceDocumentationForFilterName.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributereferencedocumentation?language=objc)
    pub static kCIAttributeReferenceDocumentation: &'static NSString;
}

extern "C" {
    /// Array of filter category names (see below)
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributefiltercategories?language=objc)
    pub static kCIAttributeFilterCategories: &'static NSString;
}

extern "C" {
    /// Class name of the filter.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributeclass?language=objc)
    pub static kCIAttributeClass: &'static NSString;
}

extern "C" {
    /// The type of the attribute e.g. scalar, time, distance, etc.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetype?language=objc)
    pub static kCIAttributeType: &'static NSString;
}

extern "C" {
    /// Minimum value for the attribute.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributemin?language=objc)
    pub static kCIAttributeMin: &'static NSString;
}

extern "C" {
    /// Maximum value for the attribute.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributemax?language=objc)
    pub static kCIAttributeMax: &'static NSString;
}

extern "C" {
    /// Minimum value for the slider.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributeslidermin?language=objc)
    pub static kCIAttributeSliderMin: &'static NSString;
}

extern "C" {
    /// Maximum value for the slider.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributeslidermax?language=objc)
    pub static kCIAttributeSliderMax: &'static NSString;
}

extern "C" {
    /// Default value for the slider.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributedefault?language=objc)
    pub static kCIAttributeDefault: &'static NSString;
}

extern "C" {
    /// The identity value is the value at which the filter has no effect.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributeidentity?language=objc)
    pub static kCIAttributeIdentity: &'static NSString;
}

extern "C" {
    /// The non-localized name of the attribute.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributename?language=objc)
    pub static kCIAttributeName: &'static NSString;
}

extern "C" {
    /// The localized name of the attribute to be used for display to the user.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributedisplayname?language=objc)
    pub static kCIAttributeDisplayName: &'static NSString;
}

extern "C" {
    /// Key to request the desired set of controls in a filter UIView. The defined values for this key are:
    /// CIUISetBasic, CIUISetIntermediate, CIUISetAdvanced and CIUISetDevelopment.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciuiparameterset?language=objc)
    pub static kCIUIParameterSet: &'static NSString;
}

extern "C" {
    /// Constant for requesting controls that are appropriate in a basic user scenario, meaning the bare minimum of settings to control the filter.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciuisetbasic?language=objc)
    pub static kCIUISetBasic: &'static NSString;
}

extern "C" {
    /// Constant for requesting controls that are appropriate in an intermediate user scenario.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciuisetintermediate?language=objc)
    pub static kCIUISetIntermediate: &'static NSString;
}

extern "C" {
    /// Constant for requesting controls that are appropriate in an advanced user scenario.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciuisetadvanced?language=objc)
    pub static kCIUISetAdvanced: &'static NSString;
}

extern "C" {
    /// Constant for requesting controls that should only be visible for development purposes.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciuisetdevelopment?language=objc)
    pub static kCIUISetDevelopment: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypetime?language=objc)
    pub static kCIAttributeTypeTime: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypescalar?language=objc)
    pub static kCIAttributeTypeScalar: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypedistance?language=objc)
    pub static kCIAttributeTypeDistance: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypeangle?language=objc)
    pub static kCIAttributeTypeAngle: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypeboolean?language=objc)
    pub static kCIAttributeTypeBoolean: &'static NSString;
}

extern "C" {
    /// Indicates that the key uses integer values.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypeinteger?language=objc)
    pub static kCIAttributeTypeInteger: &'static NSString;
}

extern "C" {
    /// Indicates that the key uses non negative integer values.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypecount?language=objc)
    pub static kCIAttributeTypeCount: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypeposition?language=objc)
    pub static kCIAttributeTypePosition: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypeoffset?language=objc)
    pub static kCIAttributeTypeOffset: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypeposition3?language=objc)
    pub static kCIAttributeTypePosition3: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetyperectangle?language=objc)
    pub static kCIAttributeTypeRectangle: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypeopaquecolor?language=objc)
    pub static kCIAttributeTypeOpaqueColor: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypecolor?language=objc)
    pub static kCIAttributeTypeColor: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypegradient?language=objc)
    pub static kCIAttributeTypeGradient: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypeimage?language=objc)
    pub static kCIAttributeTypeImage: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciattributetypetransform?language=objc)
    pub static kCIAttributeTypeTransform: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorydistortioneffect?language=objc)
    pub static kCICategoryDistortionEffect: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorygeometryadjustment?language=objc)
    pub static kCICategoryGeometryAdjustment: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorycompositeoperation?language=objc)
    pub static kCICategoryCompositeOperation: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategoryhalftoneeffect?language=objc)
    pub static kCICategoryHalftoneEffect: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorycoloradjustment?language=objc)
    pub static kCICategoryColorAdjustment: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorycoloreffect?language=objc)
    pub static kCICategoryColorEffect: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorytransition?language=objc)
    pub static kCICategoryTransition: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorytileeffect?language=objc)
    pub static kCICategoryTileEffect: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorygenerator?language=objc)
    pub static kCICategoryGenerator: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategoryreduction?language=objc)
    pub static kCICategoryReduction: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorygradient?language=objc)
    pub static kCICategoryGradient: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorystylize?language=objc)
    pub static kCICategoryStylize: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorysharpen?language=objc)
    pub static kCICategorySharpen: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategoryblur?language=objc)
    pub static kCICategoryBlur: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategoryvideo?language=objc)
    pub static kCICategoryVideo: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorystillimage?language=objc)
    pub static kCICategoryStillImage: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategoryinterlaced?language=objc)
    pub static kCICategoryInterlaced: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorynonsquarepixels?language=objc)
    pub static kCICategoryNonSquarePixels: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategoryhighdynamicrange?language=objc)
    pub static kCICategoryHighDynamicRange: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategorybuiltin?language=objc)
    pub static kCICategoryBuiltIn: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcicategoryfiltergenerator?language=objc)
    pub static kCICategoryFilterGenerator: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciapplyoptionextent?language=objc)
    pub static kCIApplyOptionExtent: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciapplyoptiondefinition?language=objc)
    pub static kCIApplyOptionDefinition: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciapplyoptionuserinfo?language=objc)
    pub static kCIApplyOptionUserInfo: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciapplyoptioncolorspace?language=objc)
    pub static kCIApplyOptionColorSpace: &'static NSString;
}

extern "C" {
    /// A key to get  the output image of a Core Image filter.
    ///
    /// The value for this key will be a ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcioutputimagekey?language=objc)
    pub static kCIOutputImageKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the background image of a Core Image filter.
    ///
    /// The value for this key needs to be a ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputbackgroundimagekey?language=objc)
    pub static kCIInputBackgroundImageKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the input image of a Core Image filter.
    ///
    /// The value for this key needs to be a ``CIImage`` instance.
    /// For filters that also use a background image, this key refers to the foreground image.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputimagekey?language=objc)
    pub static kCIInputImageKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the depth map image of a Core Image filter.
    ///
    /// The value for this key needs to be a ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputdepthimagekey?language=objc)
    pub static kCIInputDepthImageKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the disparity map image of a Core Image filter.
    ///
    /// The value for this key needs to be a ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputdisparityimagekey?language=objc)
    pub static kCIInputDisparityImageKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the scalar amount value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputamountkey?language=objc)
    pub static kCIInputAmountKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the scalar count value of a Core Image filter.
    ///
    /// The value for this key needs to be an integer  `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputcountkey?language=objc)
    pub static kCIInputCountKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the scalar threshold value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputthresholdkey?language=objc)
    pub static kCIInputThresholdKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the scalar time value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputtimekey?language=objc)
    pub static kCIInputTimeKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the geometric 2x3 matrix transform value of a Core Image filter.
    /// The value for this key needs to be an `NSAffineTransformStruct` or an `NSValue` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputtransformkey?language=objc)
    pub static kCIInputTransformKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the geometric scale value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputscalekey?language=objc)
    pub static kCIInputScaleKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the geometric aspect ratio value of a Core Image filter.
    /// The value for this key needs to be an `NSNumber` instance containing the `horizontal/vertical` scale ratio .
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputaspectratiokey?language=objc)
    pub static kCIInputAspectRatioKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the center value of a Core Image filter.
    /// The value for this key needs to be a ``CIVector`` instance containing the `x,y` coordinate.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputcenterkey?language=objc)
    pub static kCIInputCenterKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the geometric radius value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputradiuskey?language=objc)
    pub static kCIInputRadiusKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the geometric radius value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputradius0key?language=objc)
    pub static kCIInputRadius0Key: &'static NSString;
}

extern "C" {
    /// A key to get or set the geometric radius value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputradius1key?language=objc)
    pub static kCIInputRadius1Key: &'static NSString;
}

extern "C" {
    /// A key to get or set the geometric angle value of a Core Image filter.  Typically the angle is in radians.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputanglekey?language=objc)
    pub static kCIInputAngleKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the scalar optical refraction value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputrefractionkey?language=objc)
    pub static kCIInputRefractionKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the geometric width value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputwidthkey?language=objc)
    pub static kCIInputWidthKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the scalar sharpness value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputsharpnesskey?language=objc)
    pub static kCIInputSharpnessKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the scalar intensity value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputintensitykey?language=objc)
    pub static kCIInputIntensityKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the scalar EV value of a Core Image filter that specifies how many F-stops brighter or darker to make the image.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputevkey?language=objc)
    pub static kCIInputEVKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the scalar saturation value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputsaturationkey?language=objc)
    pub static kCIInputSaturationKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the color value of a Core Image filter.
    ///
    /// The value for this key needs to be a ``CIColor`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputcolorkey?language=objc)
    pub static kCIInputColorKey: &'static NSString;
}

extern "C" {
    /// A key to get or set a color value of a Core Image filter.
    ///
    /// The value for this key needs to be a ``CIColor`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputcolor0key?language=objc)
    pub static kCIInputColor0Key: &'static NSString;
}

extern "C" {
    /// A key to get or set a color value of a Core Image filter.
    ///
    /// The value for this key needs to be a ``CIColor`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputcolor1key?language=objc)
    pub static kCIInputColor1Key: &'static NSString;
}

extern "C" {
    /// A key to get or set a color space value of a Core Image filter.
    ///
    /// The value for this key needs to be a `CGColorSpace` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputcolorspacekey?language=objc)
    pub static kCIInputColorSpaceKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the scalar brightness value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputbrightnesskey?language=objc)
    pub static kCIInputBrightnessKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the scalar contrast value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputcontrastkey?language=objc)
    pub static kCIInputContrastKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the boolean behavior of a Core Image filter that specifies if the filter should extrapolate a table beyond the defined range.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputextrapolatekey?language=objc)
    pub static kCIInputExtrapolateKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the boolean behavior of a Core Image filter that specifies if the filter should operate in linear or perceptual colors.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputperceptualkey?language=objc)
    pub static kCIInputPerceptualKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the scalar bias value of a Core Image filter.
    ///
    /// The value for this key needs to be an `NSNumber` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputbiaskey?language=objc)
    pub static kCIInputBiasKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the vector bias value of a Core Image filter.
    ///
    /// The value for this key needs to be a ``CIVector`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputbiasvectorkey?language=objc)
    pub static kCIInputBiasVectorKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the vector weights value of a convolution Core Image filter.
    ///
    /// The value for this key needs to be a ``CIVector`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputweightskey?language=objc)
    pub static kCIInputWeightsKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the gradient map image of a Core Image filter that maps luminance to a color with alpha.
    ///
    /// The value for this key needs to be a 1 pixel tall ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputgradientimagekey?language=objc)
    pub static kCIInputGradientImageKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the mask image of a Core Image filter.
    ///
    /// The value for this key needs to be a ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputmaskimagekey?language=objc)
    pub static kCIInputMaskImageKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the matte image of a Core Image filter.
    ///
    /// The value for this key needs to be a ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputmatteimagekey?language=objc)
    pub static kCIInputMatteImageKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the environment map image of a Core Image filter that maps normal directions to a color with alpha.
    ///
    /// The value for this key needs to be a ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputshadingimagekey?language=objc)
    pub static kCIInputShadingImageKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the target image for a transition Core Image filter.
    ///
    /// The value for this key needs to be a ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputtargetimagekey?language=objc)
    pub static kCIInputTargetImageKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the backside image for a transition Core Image filter.
    ///
    /// The value for this key needs to be a ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputbacksideimagekey?language=objc)
    pub static kCIInputBacksideImageKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the palette image for a  Core Image filter.
    ///
    /// The value for this key needs to be a  1 pixel tall ``CIImage`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputpaletteimagekey?language=objc)
    pub static kCIInputPaletteImageKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the vector extent value of a Core Image filterthat defines the extent of the effect.
    /// The value for this key needs to be a ``CIVector`` instance.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputextentkey?language=objc)
    pub static kCIInputExtentKey: &'static NSString;
}

extern "C" {
    /// A key to get or set the coordinate value of a Core Image filter.
    /// The value for this key needs to be a ``CIVector`` instance containing the `x,y` coordinate.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputpoint0key?language=objc)
    pub static kCIInputPoint0Key: &'static NSString;
}

extern "C" {
    /// A key to get or set a coordinate value of a Core Image filter.
    /// The value for this key needs to be a ``CIVector`` instance containing the `x,y` coordinate.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputpoint1key?language=objc)
    pub static kCIInputPoint1Key: &'static NSString;
}

extern "C" {
    /// A key to get or set a coordinate value of a Core Image filter.
    /// The value for this key needs to be a ``CIVector`` instance containing the `x,y` coordinate.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kciinputversionkey?language=objc)
    pub static kCIInputVersionKey: &'static NSString;
}

/// An enum string type that your code can use to select different System Tone Mapping modes.
///
/// These options are consistent with the analogous options available in Core Graphics,
/// Core Animation, AppKit, UIKit, and SwiftUI,
/// In Core Image, this option can be set on the `CISystemToneMap` filter.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cidynamicrangeoption?language=objc)
// NS_TYPED_ENUM
pub type CIDynamicRangeOption = NSString;

extern "C" {
    /// Use Standard dynamic range.
    ///
    /// Images with `contentHeadroom` metadata will be tone mapped to a maximum pixel value of 1.0.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcidynamicrangestandard?language=objc)
    pub static kCIDynamicRangeStandard: &'static CIDynamicRangeOption;
}

extern "C" {
    /// Use extended dynamic range, but brightness is modulated to optimize for
    /// co-existence with other composited content.
    ///
    /// For best results, images should contain `contentAverageLightLevel` metadata.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcidynamicrangeconstrainedhigh?language=objc)
    pub static kCIDynamicRangeConstrainedHigh: &'static CIDynamicRangeOption;
}

extern "C" {
    /// Use High dynamic range.
    ///
    /// The provides the best HDR quality and needs to be reserved
    /// for situations where the user is focused on the media, such as larger views in
    /// an image editing/viewing app, or annotating/drawing with HDR colors
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/kcidynamicrangehigh?language=objc)
    pub static kCIDynamicRangeHigh: &'static CIDynamicRangeOption;
}

extern_class!(
    /// CIFilter are filter objects for Core Image that encapsulate the filter with its attributes
    ///
    /// The CIFilter class produces a CIImage object as output. Typically, a filter takes one or more images as input. Some filters, however, generate an image based on other types of input parameters. The parameters of a CIFilter object are set and retrieved through the use of key-value pairs. You use the CIFilter object in conjunction with the CIImage, CIContext, CIVector, CIImageAccumulator, and CIColor objects to take advantage of the built-in Core Image filters when processing images. CIFilter objects are also used along with CIKernel, CISampler, and CIFilterShape objects to create custom filters.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cifilter?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIFilter;
);

extern_conformance!(
    unsafe impl NSCoding for CIFilter {}
);

extern_conformance!(
    unsafe impl NSCopying for CIFilter {}
);

unsafe impl CopyingHelper for CIFilter {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CIFilter {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CIFilter {}
);

impl CIFilter {
    extern_methods!(
        #[cfg(feature = "CIImage")]
        #[unsafe(method(outputImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn outputImage(&self) -> Option<Retained<CIImage>>;

        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub unsafe fn name(&self) -> Retained<NSString>;

        /// Setter for [`name`][Self::name].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setName(&self, name: &NSString);

        #[unsafe(method(isEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEnabled(&self) -> bool;

        /// Setter for [`isEnabled`][Self::isEnabled].
        #[unsafe(method(setEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEnabled(&self, enabled: bool);

        /// Returns an array containing the names of all inputs in the filter.
        #[unsafe(method(inputKeys))]
        #[unsafe(method_family = none)]
        pub unsafe fn inputKeys(&self) -> Retained<NSArray<NSString>>;

        /// Returns an array containing the names of all outputs in the filter.
        #[unsafe(method(outputKeys))]
        #[unsafe(method_family = none)]
        pub unsafe fn outputKeys(&self) -> Retained<NSArray<NSString>>;

        /// Sets all inputs to their default values (where default values are defined, other inputs are left as-is).
        #[unsafe(method(setDefaults))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefaults(&self);

        /// Returns a dictionary containing key/value pairs describing the filter. (see description of keys below)
        #[unsafe(method(attributes))]
        #[unsafe(method_family = none)]
        pub unsafe fn attributes(&self) -> Retained<NSDictionary<NSString, AnyObject>>;

        #[cfg(all(feature = "CIImage", feature = "CIKernel"))]
        /// Used by CIFilter subclasses to apply the array of argument values 'args' to the kernel function 'k'. The supplied arguments must be type-compatible with the function signature of the kernel.
        ///
        /// The key-value pairs defined by 'dict' (if non-nil) are used to control exactly how the kernel is evaluated. Valid keys include:
        /// kCIApplyOptionExtent: the size of the produced image. Value is a four element NSArray [X Y WIDTH HEIGHT].
        /// kCIApplyOptionDefinition: the Domain of Definition of the produced image. Value is either a CIFilterShape object, or a four element NSArray defining a rectangle.
        ///
        /// Parameter `k`: CIKernel of the filter
        ///
        /// Parameter `args`: Array of arguments that are applied to the kernel
        ///
        /// Parameter `dict`: Array of additional options
        ///
        /// # Safety
        ///
        /// - `args` generic should be of the correct type.
        /// - `dict` generic should be of the correct type.
        #[unsafe(method(apply:arguments:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn apply_arguments_options(
            &self,
            k: &CIKernel,
            args: Option<&NSArray>,
            dict: Option<&NSDictionary<NSString, AnyObject>>,
        ) -> Option<Retained<CIImage>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIFilter {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/cifilterprotocol?language=objc)
    #[doc(alias = "CIFilter")]
    #[name = "CIFilter"]
    pub unsafe trait CIFilterProtocol {
        #[cfg(feature = "CIImage")]
        #[unsafe(method(outputImage))]
        #[unsafe(method_family = none)]
        unsafe fn outputImage(&self) -> Option<Retained<CIImage>>;

        #[optional]
        #[unsafe(method(customAttributes))]
        #[unsafe(method_family = none)]
        unsafe fn customAttributes() -> Option<Retained<NSDictionary<NSString, AnyObject>>>;
    }
);

/// CIFilterRegistry.
///
/// Methods to register a filter and get access to the list of registered filters
/// Use these methods to create filters and find filters.
impl CIFilter {
    extern_methods!(
        /// Creates a new filter of type 'name'.
        /// On OSX, all input values will be undefined.
        /// On iOS, all input values will be set to default values.
        #[unsafe(method(filterWithName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn filterWithName(name: &NSString) -> Option<Retained<CIFilter>>;

        /// Creates a new filter of type 'name'.
        /// The filter's input parameters are set from the dictionary of key-value pairs.
        /// On OSX, any of the filter input parameters not specified in the dictionary will be undefined.
        /// On iOS, any of the filter input parameters not specified in the dictionary will be set to default values.
        ///
        /// # Safety
        ///
        /// `params` generic should be of the correct type.
        #[unsafe(method(filterWithName:withInputParameters:))]
        #[unsafe(method_family = none)]
        pub unsafe fn filterWithName_withInputParameters(
            name: &NSString,
            params: Option<&NSDictionary<NSString, AnyObject>>,
        ) -> Option<Retained<CIFilter>>;

        /// Returns an array containing all published filter names in a category.
        #[unsafe(method(filterNamesInCategory:))]
        #[unsafe(method_family = none)]
        pub unsafe fn filterNamesInCategory(
            category: Option<&NSString>,
        ) -> Retained<NSArray<NSString>>;

        /// Returns an array containing all published filter names that belong to all listed categories.
        #[unsafe(method(filterNamesInCategories:))]
        #[unsafe(method_family = none)]
        pub unsafe fn filterNamesInCategories(
            categories: Option<&NSArray<NSString>>,
        ) -> Retained<NSArray<NSString>>;

        #[cfg(feature = "CIFilterConstructor")]
        /// Publishes a new filter called 'name'.
        ///
        /// The constructor object 'anObject' should implement the filterWithName: method.
        /// That method will be invoked with the name of the filter to create.
        /// The class attributes must have a kCIAttributeFilterCategories key associated with a set of categories.
        ///
        /// Parameter `attributes`: Dictionary of the registration attributes of the filter. See below for attribute keys.
        ///
        /// # Safety
        ///
        /// `attributes` generic should be of the correct type.
        #[unsafe(method(registerFilterName:constructor:classAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerFilterName_constructor_classAttributes(
            name: &NSString,
            an_object: &ProtocolObject<dyn CIFilterConstructor>,
            attributes: &NSDictionary<NSString, AnyObject>,
        );

        /// Returns the localized name of a filter for display in the UI.
        #[unsafe(method(localizedNameForFilterName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedNameForFilterName(
            filter_name: &NSString,
        ) -> Option<Retained<NSString>>;

        /// Returns the localized name of a category for display in the UI.
        #[unsafe(method(localizedNameForCategory:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedNameForCategory(category: &NSString) -> Retained<NSString>;

        /// Returns the localized description of a filter for display in the UI.
        #[unsafe(method(localizedDescriptionForFilterName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedDescriptionForFilterName(
            filter_name: &NSString,
        ) -> Option<Retained<NSString>>;

        /// Returns the URL to the localized reference documentation describing the filter.
        ///
        /// The URL can be a local file or a remote document on a webserver. It is possible, that this method returns nil (like filters that predate this feature). A client of this API has to handle this case gracefully.
        #[unsafe(method(localizedReferenceDocumentationForFilterName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn localizedReferenceDocumentationForFilterName(
            filter_name: &NSString,
        ) -> Option<Retained<NSURL>>;
    );
}

/// CIFilterXMPSerialization.
///
/// Methods to serialize arrays of filters to xmp.
impl CIFilter {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[deprecated]
        #[unsafe(method(serializedXMPFromFilters:inputImageExtent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn serializedXMPFromFilters_inputImageExtent(
            filters: &NSArray<CIFilter>,
            extent: CGRect,
        ) -> Option<Retained<NSData>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[deprecated]
        #[unsafe(method(filterArrayFromSerializedXMP:inputImageExtent:error:))]
        #[unsafe(method_family = none)]
        pub unsafe fn filterArrayFromSerializedXMP_inputImageExtent_error(
            xmp_data: &NSData,
            extent: CGRect,
            out_error: Option<&mut Option<Retained<NSError>>>,
        ) -> Retained<NSArray<CIFilter>>;
    );
}
