// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The destination information for a V1 S3 Metadata configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p><note>
/// <p>If you created your S3 Metadata configuration before July 15, 2025, we recommend that you delete and re-create your configuration by using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucketMetadataConfiguration.html">CreateBucketMetadataConfiguration</a> so that you can expire journal table records and create a live inventory table.</p>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct S3TablesDestinationResult {
    /// <p>The Amazon Resource Name (ARN) for the table bucket that's specified as the destination in the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket.</p>
    pub table_bucket_arn: ::std::string::String,
    /// <p>The name for the metadata table in your metadata table configuration. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub table_name: ::std::string::String,
    /// <p>The Amazon Resource Name (ARN) for the metadata table in the metadata table configuration. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub table_arn: ::std::string::String,
    /// <p>The table bucket namespace for the metadata table in your metadata table configuration. This value is always <code>aws_s3_metadata</code>.</p>
    pub table_namespace: ::std::string::String,
}
impl S3TablesDestinationResult {
    /// <p>The Amazon Resource Name (ARN) for the table bucket that's specified as the destination in the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket.</p>
    pub fn table_bucket_arn(&self) -> &str {
        use std::ops::Deref;
        self.table_bucket_arn.deref()
    }
    /// <p>The name for the metadata table in your metadata table configuration. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub fn table_name(&self) -> &str {
        use std::ops::Deref;
        self.table_name.deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the metadata table in the metadata table configuration. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub fn table_arn(&self) -> &str {
        use std::ops::Deref;
        self.table_arn.deref()
    }
    /// <p>The table bucket namespace for the metadata table in your metadata table configuration. This value is always <code>aws_s3_metadata</code>.</p>
    pub fn table_namespace(&self) -> &str {
        use std::ops::Deref;
        self.table_namespace.deref()
    }
}
impl S3TablesDestinationResult {
    /// Creates a new builder-style object to manufacture [`S3TablesDestinationResult`](crate::types::S3TablesDestinationResult).
    pub fn builder() -> crate::types::builders::S3TablesDestinationResultBuilder {
        crate::types::builders::S3TablesDestinationResultBuilder::default()
    }
}

/// A builder for [`S3TablesDestinationResult`](crate::types::S3TablesDestinationResult).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct S3TablesDestinationResultBuilder {
    pub(crate) table_bucket_arn: ::std::option::Option<::std::string::String>,
    pub(crate) table_name: ::std::option::Option<::std::string::String>,
    pub(crate) table_arn: ::std::option::Option<::std::string::String>,
    pub(crate) table_namespace: ::std::option::Option<::std::string::String>,
}
impl S3TablesDestinationResultBuilder {
    /// <p>The Amazon Resource Name (ARN) for the table bucket that's specified as the destination in the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket.</p>
    /// This field is required.
    pub fn table_bucket_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.table_bucket_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) for the table bucket that's specified as the destination in the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket.</p>
    pub fn set_table_bucket_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.table_bucket_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) for the table bucket that's specified as the destination in the metadata table configuration. The destination table bucket must be in the same Region and Amazon Web Services account as the general purpose bucket.</p>
    pub fn get_table_bucket_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.table_bucket_arn
    }
    /// <p>The name for the metadata table in your metadata table configuration. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    /// This field is required.
    pub fn table_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.table_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name for the metadata table in your metadata table configuration. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub fn set_table_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.table_name = input;
        self
    }
    /// <p>The name for the metadata table in your metadata table configuration. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub fn get_table_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.table_name
    }
    /// <p>The Amazon Resource Name (ARN) for the metadata table in the metadata table configuration. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    /// This field is required.
    pub fn table_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.table_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) for the metadata table in the metadata table configuration. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub fn set_table_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.table_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) for the metadata table in the metadata table configuration. The specified metadata table name must be unique within the <code>aws_s3_metadata</code> namespace in the destination table bucket.</p>
    pub fn get_table_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.table_arn
    }
    /// <p>The table bucket namespace for the metadata table in your metadata table configuration. This value is always <code>aws_s3_metadata</code>.</p>
    /// This field is required.
    pub fn table_namespace(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.table_namespace = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The table bucket namespace for the metadata table in your metadata table configuration. This value is always <code>aws_s3_metadata</code>.</p>
    pub fn set_table_namespace(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.table_namespace = input;
        self
    }
    /// <p>The table bucket namespace for the metadata table in your metadata table configuration. This value is always <code>aws_s3_metadata</code>.</p>
    pub fn get_table_namespace(&self) -> &::std::option::Option<::std::string::String> {
        &self.table_namespace
    }
    /// Consumes the builder and constructs a [`S3TablesDestinationResult`](crate::types::S3TablesDestinationResult).
    /// This method will fail if any of the following fields are not set:
    /// - [`table_bucket_arn`](crate::types::builders::S3TablesDestinationResultBuilder::table_bucket_arn)
    /// - [`table_name`](crate::types::builders::S3TablesDestinationResultBuilder::table_name)
    /// - [`table_arn`](crate::types::builders::S3TablesDestinationResultBuilder::table_arn)
    /// - [`table_namespace`](crate::types::builders::S3TablesDestinationResultBuilder::table_namespace)
    pub fn build(self) -> ::std::result::Result<crate::types::S3TablesDestinationResult, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::S3TablesDestinationResult {
            table_bucket_arn: self.table_bucket_arn.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "table_bucket_arn",
                    "table_bucket_arn was not specified but it is required when building S3TablesDestinationResult",
                )
            })?,
            table_name: self.table_name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "table_name",
                    "table_name was not specified but it is required when building S3TablesDestinationResult",
                )
            })?,
            table_arn: self.table_arn.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "table_arn",
                    "table_arn was not specified but it is required when building S3TablesDestinationResult",
                )
            })?,
            table_namespace: self.table_namespace.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "table_namespace",
                    "table_namespace was not specified but it is required when building S3TablesDestinationResult",
                )
            })?,
        })
    }
}
