// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum Error {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::types::error::AccessDeniedException),
    /// <p>Indicates that a request to authorize a client with an access user session token is pending.</p>
    AuthorizationPendingException(crate::types::error::AuthorizationPendingException),
    /// <p>Indicates that the token issued by the service is expired and is no longer valid.</p>
    ExpiredTokenException(crate::types::error::ExpiredTokenException),
    /// <p>Indicates that an error from the service occurred while trying to process a request.</p>
    InternalServerException(crate::types::error::InternalServerException),
    /// <p>Indicates that the <code>clientId</code> or <code>clientSecret</code> in the request is invalid. For example, this can occur when a client sends an incorrect <code>clientId</code> or an expired <code>clientSecret</code>.</p>
    InvalidClientException(crate::types::error::InvalidClientException),
    /// <p>Indicates that the client information sent in the request during registration is invalid.</p>
    InvalidClientMetadataException(crate::types::error::InvalidClientMetadataException),
    /// <p>Indicates that a request contains an invalid grant. This can occur if a client makes a <code>CreateToken</code> request with an invalid grant type.</p>
    InvalidGrantException(crate::types::error::InvalidGrantException),
    /// <p>Indicates that one or more redirect URI in the request is not supported for this operation.</p>
    InvalidRedirectUriException(crate::types::error::InvalidRedirectUriException),
    /// <p>Indicates that something is wrong with the input to the request. For example, a required parameter might be missing or out of range.</p>
    InvalidRequestException(crate::types::error::InvalidRequestException),
    /// <p>Indicates that a token provided as input to the request was issued by and is only usable by calling IAM Identity Center endpoints in another region.</p>
    InvalidRequestRegionException(crate::types::error::InvalidRequestRegionException),
    /// <p>Indicates that the scope provided in the request is invalid.</p>
    InvalidScopeException(crate::types::error::InvalidScopeException),
    /// <p>Indicates that the client is making the request too frequently and is more than the service can handle.</p>
    SlowDownException(crate::types::error::SlowDownException),
    /// <p>Indicates that the client is not currently authorized to make the request. This can happen when a <code>clientId</code> is not issued for a public client.</p>
    UnauthorizedClientException(crate::types::error::UnauthorizedClientException),
    /// <p>Indicates that the grant type in the request is not supported by the service.</p>
    UnsupportedGrantTypeException(crate::types::error::UnsupportedGrantTypeException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-Error) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl ::std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::AuthorizationPendingException(inner) => inner.fmt(f),
            Error::ExpiredTokenException(inner) => inner.fmt(f),
            Error::InternalServerException(inner) => inner.fmt(f),
            Error::InvalidClientException(inner) => inner.fmt(f),
            Error::InvalidClientMetadataException(inner) => inner.fmt(f),
            Error::InvalidGrantException(inner) => inner.fmt(f),
            Error::InvalidRedirectUriException(inner) => inner.fmt(f),
            Error::InvalidRequestException(inner) => inner.fmt(f),
            Error::InvalidRequestRegionException(inner) => inner.fmt(f),
            Error::InvalidScopeException(inner) => inner.fmt(f),
            Error::SlowDownException(inner) => inner.fmt(f),
            Error::UnauthorizedClientException(inner) => inner.fmt(f),
            Error::UnsupportedGrantTypeException(inner) => inner.fmt(f),
            Error::Unhandled(_) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl From<::aws_smithy_types::error::operation::BuildError> for Error {
    fn from(value: ::aws_smithy_types::error::operation::BuildError) -> Self {
        Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: value.into(),
            meta: ::std::default::Default::default(),
        })
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for Error {
    fn meta(&self) -> &::aws_smithy_types::error::metadata::ErrorMetadata {
        match self {
            Self::AccessDeniedException(inner) => inner.meta(),
            Self::AuthorizationPendingException(inner) => inner.meta(),
            Self::ExpiredTokenException(inner) => inner.meta(),
            Self::InternalServerException(inner) => inner.meta(),
            Self::InvalidClientException(inner) => inner.meta(),
            Self::InvalidClientMetadataException(inner) => inner.meta(),
            Self::InvalidGrantException(inner) => inner.meta(),
            Self::InvalidRedirectUriException(inner) => inner.meta(),
            Self::InvalidRequestException(inner) => inner.meta(),
            Self::InvalidRequestRegionException(inner) => inner.meta(),
            Self::InvalidScopeException(inner) => inner.meta(),
            Self::SlowDownException(inner) => inner.meta(),
            Self::UnauthorizedClientException(inner) => inner.meta(),
            Self::UnsupportedGrantTypeException(inner) => inner.meta(),
            Self::Unhandled(inner) => &inner.meta,
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_token::CreateTokenError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_token::CreateTokenError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::create_token::CreateTokenError> for Error {
    fn from(err: crate::operation::create_token::CreateTokenError) -> Self {
        match err {
            crate::operation::create_token::CreateTokenError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::create_token::CreateTokenError::AuthorizationPendingException(inner) => Error::AuthorizationPendingException(inner),
            crate::operation::create_token::CreateTokenError::ExpiredTokenException(inner) => Error::ExpiredTokenException(inner),
            crate::operation::create_token::CreateTokenError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::create_token::CreateTokenError::InvalidClientException(inner) => Error::InvalidClientException(inner),
            crate::operation::create_token::CreateTokenError::InvalidGrantException(inner) => Error::InvalidGrantException(inner),
            crate::operation::create_token::CreateTokenError::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
            crate::operation::create_token::CreateTokenError::InvalidScopeException(inner) => Error::InvalidScopeException(inner),
            crate::operation::create_token::CreateTokenError::SlowDownException(inner) => Error::SlowDownException(inner),
            crate::operation::create_token::CreateTokenError::UnauthorizedClientException(inner) => Error::UnauthorizedClientException(inner),
            crate::operation::create_token::CreateTokenError::UnsupportedGrantTypeException(inner) => Error::UnsupportedGrantTypeException(inner),
            crate::operation::create_token::CreateTokenError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_token_with_iam::CreateTokenWithIAMError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::create_token_with_iam::CreateTokenWithIAMError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::create_token_with_iam::CreateTokenWithIAMError> for Error {
    fn from(err: crate::operation::create_token_with_iam::CreateTokenWithIAMError) -> Self {
        match err {
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::AuthorizationPendingException(inner) => {
                Error::AuthorizationPendingException(inner)
            }
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::ExpiredTokenException(inner) => Error::ExpiredTokenException(inner),
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::InvalidClientException(inner) => Error::InvalidClientException(inner),
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::InvalidGrantException(inner) => Error::InvalidGrantException(inner),
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::InvalidRequestRegionException(inner) => {
                Error::InvalidRequestRegionException(inner)
            }
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::InvalidScopeException(inner) => Error::InvalidScopeException(inner),
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::SlowDownException(inner) => Error::SlowDownException(inner),
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::UnauthorizedClientException(inner) => {
                Error::UnauthorizedClientException(inner)
            }
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::UnsupportedGrantTypeException(inner) => {
                Error::UnsupportedGrantTypeException(inner)
            }
            crate::operation::create_token_with_iam::CreateTokenWithIAMError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::register_client::RegisterClientError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::register_client::RegisterClientError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::register_client::RegisterClientError> for Error {
    fn from(err: crate::operation::register_client::RegisterClientError) -> Self {
        match err {
            crate::operation::register_client::RegisterClientError::InternalServerException(inner) => Error::InternalServerException(inner),
            crate::operation::register_client::RegisterClientError::InvalidClientMetadataException(inner) => {
                Error::InvalidClientMetadataException(inner)
            }
            crate::operation::register_client::RegisterClientError::InvalidRedirectUriException(inner) => Error::InvalidRedirectUriException(inner),
            crate::operation::register_client::RegisterClientError::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
            crate::operation::register_client::RegisterClientError::InvalidScopeException(inner) => Error::InvalidScopeException(inner),
            crate::operation::register_client::RegisterClientError::SlowDownException(inner) => Error::SlowDownException(inner),
            crate::operation::register_client::RegisterClientError::UnsupportedGrantTypeException(inner) => {
                Error::UnsupportedGrantTypeException(inner)
            }
            crate::operation::register_client::RegisterClientError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_device_authorization::StartDeviceAuthorizationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::start_device_authorization::StartDeviceAuthorizationError, R>,
    ) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::start_device_authorization::StartDeviceAuthorizationError> for Error {
    fn from(err: crate::operation::start_device_authorization::StartDeviceAuthorizationError) -> Self {
        match err {
            crate::operation::start_device_authorization::StartDeviceAuthorizationError::InternalServerException(inner) => {
                Error::InternalServerException(inner)
            }
            crate::operation::start_device_authorization::StartDeviceAuthorizationError::InvalidClientException(inner) => {
                Error::InvalidClientException(inner)
            }
            crate::operation::start_device_authorization::StartDeviceAuthorizationError::InvalidRequestException(inner) => {
                Error::InvalidRequestException(inner)
            }
            crate::operation::start_device_authorization::StartDeviceAuthorizationError::SlowDownException(inner) => Error::SlowDownException(inner),
            crate::operation::start_device_authorization::StartDeviceAuthorizationError::UnauthorizedClientException(inner) => {
                Error::UnauthorizedClientException(inner)
            }
            crate::operation::start_device_authorization::StartDeviceAuthorizationError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl ::std::error::Error for Error {
    fn source(&self) -> std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Error::AccessDeniedException(inner) => inner.source(),
            Error::AuthorizationPendingException(inner) => inner.source(),
            Error::ExpiredTokenException(inner) => inner.source(),
            Error::InternalServerException(inner) => inner.source(),
            Error::InvalidClientException(inner) => inner.source(),
            Error::InvalidClientMetadataException(inner) => inner.source(),
            Error::InvalidGrantException(inner) => inner.source(),
            Error::InvalidRedirectUriException(inner) => inner.source(),
            Error::InvalidRequestException(inner) => inner.source(),
            Error::InvalidRequestRegionException(inner) => inner.source(),
            Error::InvalidScopeException(inner) => inner.source(),
            Error::SlowDownException(inner) => inner.source(),
            Error::UnauthorizedClientException(inner) => inner.source(),
            Error::UnsupportedGrantTypeException(inner) => inner.source(),
            Error::Unhandled(inner) => ::std::option::Option::Some(&*inner.source),
        }
    }
}
impl ::aws_types::request_id::RequestId for Error {
    fn request_id(&self) -> Option<&str> {
        match self {
            Self::AccessDeniedException(e) => e.request_id(),
            Self::AuthorizationPendingException(e) => e.request_id(),
            Self::ExpiredTokenException(e) => e.request_id(),
            Self::InternalServerException(e) => e.request_id(),
            Self::InvalidClientException(e) => e.request_id(),
            Self::InvalidClientMetadataException(e) => e.request_id(),
            Self::InvalidGrantException(e) => e.request_id(),
            Self::InvalidRedirectUriException(e) => e.request_id(),
            Self::InvalidRequestException(e) => e.request_id(),
            Self::InvalidRequestRegionException(e) => e.request_id(),
            Self::InvalidScopeException(e) => e.request_id(),
            Self::SlowDownException(e) => e.request_id(),
            Self::UnauthorizedClientException(e) => e.request_id(),
            Self::UnsupportedGrantTypeException(e) => e.request_id(),
            Self::Unhandled(e) => e.meta.request_id(),
        }
    }
}
