/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * rotation variation v1. Rotation angles vary linearly between iteration parameters.
 * After the stop iteration, alpha = alpha + variable alpha.

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_rotation_vary_v1.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfRotationVaryV1Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 tempVC = (REAL4){fractal->transformCommon.rotation.x, fractal->transformCommon.rotation.y,
		fractal->transformCommon.rotation.z, 0.0f}; // constant to be varied
	int iterationRange =
		fractal->transformCommon.stopIterations - fractal->transformCommon.startIterations250;

	if (aux->i >= fractal->transformCommon.startIterations250 && iterationRange != 0)
	{
		if (aux->i < fractal->transformCommon.stopIterations)
		{
			int currentIteration = (aux->i - fractal->transformCommon.startIterations250);
			REAL dCurrentIteration = (REAL)currentIteration;
			REAL dIterationRange = (REAL)iterationRange;
			tempVC += fractal->transformCommon.offset000 * dCurrentIteration / dIterationRange;
		}
		else
		{
			tempVC += fractal->transformCommon.offset000;
		}
	}

	tempVC *= M_PI_180_F;

	z = RotateAroundVectorByAngle4(z, (REAL3){1.0f, 0.0f, 0.0f}, tempVC.x);
	z = RotateAroundVectorByAngle4(z, (REAL3){0.0f, 1.0f, 0.0f}, tempVC.y);
	z = RotateAroundVectorByAngle4(z, (REAL3){0.0f, 0.0f, 1.0f}, tempVC.z);
	return z;
}