//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// Type of mapping operation for sparse texture
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlsparsetexturemappingmode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLSparseTextureMappingMode(pub NSUInteger);
impl MTLSparseTextureMappingMode {
    #[doc(alias = "MTLSparseTextureMappingModeMap")]
    pub const Map: Self = Self(0);
    #[doc(alias = "MTLSparseTextureMappingModeUnmap")]
    pub const Unmap: Self = Self(1);
}

unsafe impl Encode for MTLSparseTextureMappingMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLSparseTextureMappingMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Structure describing indirect mapping region. This structure is used to populate a buffer for the method  'MTLResourceStateCommandEncoder updateTextureMapping:indirectBuffer:indirectBufferOffset:'
///
/// The correct data format for the buffer used in 'MTLResourceStateCommandEncoder updateTextureMapping:indirectBuffer:indirectBufferOffset: is the following:
///
/// struct MTLMapIndirectBufferFormat{
/// uint32_t numMappings;
/// MTLMapIndirectArguments mappings[numMappings];
/// }
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlmapindirectarguments?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLMapIndirectArguments {
    pub regionOriginX: u32,
    pub regionOriginY: u32,
    pub regionOriginZ: u32,
    pub regionSizeWidth: u32,
    pub regionSizeHeight: u32,
    pub regionSizeDepth: u32,
    pub mipMapLevel: u32,
    pub sliceId: u32,
}

unsafe impl Encode for MTLMapIndirectArguments {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for MTLMapIndirectArguments {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlresourcestatecommandencoder?language=objc)
    #[cfg(feature = "MTLCommandEncoder")]
    pub unsafe trait MTLResourceStateCommandEncoder: MTLCommandEncoder {
        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        /// Updates multiple regions within a sparse texture.
        #[optional]
        #[unsafe(method(updateTextureMappings:mode:regions:mipLevels:slices:numRegions:))]
        #[unsafe(method_family = none)]
        unsafe fn updateTextureMappings_mode_regions_mipLevels_slices_numRegions(
            &self,
            texture: &ProtocolObject<dyn MTLTexture>,
            mode: MTLSparseTextureMappingMode,
            regions: NonNull<MTLRegion>,
            mip_levels: NonNull<NSUInteger>,
            slices: NonNull<NSUInteger>,
            num_regions: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        /// Updates mapping for given sparse texture
        #[optional]
        #[unsafe(method(updateTextureMapping:mode:region:mipLevel:slice:))]
        #[unsafe(method_family = none)]
        unsafe fn updateTextureMapping_mode_region_mipLevel_slice(
            &self,
            texture: &ProtocolObject<dyn MTLTexture>,
            mode: MTLSparseTextureMappingMode,
            region: MTLRegion,
            mip_level: NSUInteger,
            slice: NSUInteger,
        );

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLBuffer",
            feature = "MTLResource",
            feature = "MTLTexture"
        ))]
        /// Updates mapping for given sparse texture. Updates are driven via a MTLBuffer with the structure format defined by MTLMapIndirectBufferFormat.
        ///
        /// struct MTLMapIndirectBufferFormat{
        /// uint32_t numMappings;
        /// MTLMapIndirectArguments mappings[numMappings];
        /// }
        #[optional]
        #[unsafe(method(updateTextureMapping:mode:indirectBuffer:indirectBufferOffset:))]
        #[unsafe(method_family = none)]
        unsafe fn updateTextureMapping_mode_indirectBuffer_indirectBufferOffset(
            &self,
            texture: &ProtocolObject<dyn MTLTexture>,
            mode: MTLSparseTextureMappingMode,
            indirect_buffer: &ProtocolObject<dyn MTLBuffer>,
            indirect_buffer_offset: NSUInteger,
        );

        #[cfg(feature = "MTLFence")]
        /// Update the fence to capture all GPU work so far enqueued by this encoder.
        ///
        /// The fence is updated at kernel submission to maintain global order and prevent deadlock.
        /// Drivers may delay fence updates until the end of the encoder. Drivers may also wait on fences at the beginning of an encoder. It is therefore illegal to wait on a fence after it has been updated in the same encoder.
        #[optional]
        #[unsafe(method(updateFence:))]
        #[unsafe(method_family = none)]
        unsafe fn updateFence(&self, fence: &ProtocolObject<dyn MTLFence>);

        #[cfg(feature = "MTLFence")]
        /// Prevent further GPU work until the fence is reached.
        ///
        /// The fence is evaluated at kernel submission to maintain global order and prevent deadlock.
        /// Drivers may delay fence updates until the end of the encoder. Drivers may also wait on fences at the beginning of an encoder. It is therefore illegal to wait on a fence after it has been updated in the same encoder.
        #[optional]
        #[unsafe(method(waitForFence:))]
        #[unsafe(method_family = none)]
        unsafe fn waitForFence(&self, fence: &ProtocolObject<dyn MTLFence>);

        #[cfg(all(
            feature = "MTLAllocation",
            feature = "MTLResource",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        /// Move sparse page mappings from one sparse texture to another from the same heap.
        ///
        /// The tile mapping is moved from the source texture only if the destination texture tile is unmapped. The textures must also have matching a texture format,
        /// texture type, sample count, usage and resource options.
        #[optional]
        #[unsafe(method(moveTextureMappingsFromTexture:sourceSlice:sourceLevel:sourceOrigin:sourceSize:toTexture:destinationSlice:destinationLevel:destinationOrigin:))]
        #[unsafe(method_family = none)]
        unsafe fn moveTextureMappingsFromTexture_sourceSlice_sourceLevel_sourceOrigin_sourceSize_toTexture_destinationSlice_destinationLevel_destinationOrigin(
            &self,
            source_texture: &ProtocolObject<dyn MTLTexture>,
            source_slice: NSUInteger,
            source_level: NSUInteger,
            source_origin: MTLOrigin,
            source_size: MTLSize,
            destination_texture: &ProtocolObject<dyn MTLTexture>,
            destination_slice: NSUInteger,
            destination_level: NSUInteger,
            destination_origin: MTLOrigin,
        );
    }
);
