use crate::spec::{Arch, StackProbeType, Target, base};

pub(crate) fn target() -> Target {
    let mut base = base::managarm_mlibc::opts();
    base.max_atomic_width = Some(128);
    base.stack_probes = StackProbeType::Inline;
    base.features = "+v8a".into();

    Target {
        llvm_target: "aarch64-unknown-managarm-mlibc".into(),
        metadata: crate::spec::TargetMetadata {
            description: Some("managarm/aarch64".into()),
            tier: Some(3),
            host_tools: Some(false),
            std: Some(false),
        },
        pointer_width: 64,
        data_layout: "e-m:e-p270:32:32-p271:32:32-p272:64:64-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128-Fn32".into(),
        arch: Arch::AArch64,
        options: base
    }
}
