// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutBucketCors`](crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder::set_bucket):<br>required: **true**<br><p>Specifies the bucket impacted by the <code>cors</code>configuration.</p><br>
    ///   - [`cors_configuration(CorsConfiguration)`](crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder::cors_configuration) / [`set_cors_configuration(Option<CorsConfiguration>)`](crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder::set_cors_configuration):<br>required: **true**<br><p>Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html">Enabling Cross-Origin Resource Sharing</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`content_md5(impl Into<String>)`](crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder::content_md5) / [`set_content_md5(Option<String>)`](crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder::set_content_md5):<br>required: **false**<br><p>The Base64 encoded 128-bit <code>MD5</code> digest of the data. This header must be used as a message integrity check to verify that the request body was not corrupted in transit. For more information, go to <a href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a></p> <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p><br>
    ///   - [`checksum_algorithm(ChecksumAlgorithm)`](crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder::checksum_algorithm) / [`set_checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder::set_checksum_algorithm):<br>required: **false**<br><p>Indicates the algorithm used to create the checksum for the request when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding <code>x-amz-checksum</code> or <code>x-amz-trailer</code> header sent. Otherwise, Amazon S3 fails the request with the HTTP status code <code>400 Bad Request</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you provide an individual checksum, Amazon S3 ignores any provided <code>ChecksumAlgorithm</code> parameter.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`PutBucketCorsOutput`](crate::operation::put_bucket_cors::PutBucketCorsOutput)
    /// - On failure, responds with [`SdkError<PutBucketCorsError>`](crate::operation::put_bucket_cors::PutBucketCorsError)
    pub fn put_bucket_cors(&self) -> crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder {
        crate::operation::put_bucket_cors::builders::PutBucketCorsFluentBuilder::new(self.handle.clone())
    }
}
