/*
 * Decompiled with CFR 0.152.
 */
package jflex.state;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import jflex.state.StateSet;

public final class StateSetEnumerator
implements PrimitiveIterator.OfInt {
    private static final boolean DEBUG = false;
    private int index;
    private int offset;
    private long mask;
    private long[] bits;

    public StateSetEnumerator() {
        this.bits = new long[0];
    }

    public StateSetEnumerator(StateSet states) {
        this.bits = states.bits;
        this.reset(states);
    }

    public void reset(StateSet states) {
        this.bits = states.bits;
        this.index = 0;
        this.offset = 0;
        this.mask = 1L;
        while (this.index < this.bits.length && this.bits[this.index] == 0L) {
            ++this.index;
        }
        if (this.index >= this.bits.length) {
            return;
        }
        while (this.offset <= 63 && (this.bits[this.index] & this.mask) == 0L) {
            this.mask <<= 1;
            ++this.offset;
        }
    }

    private void advance() {
        int _index = this.index;
        int _offset = this.offset;
        long _mask = this.mask;
        long[] _bits = this.bits;
        long bi = _bits[_index];
        while (++_offset <= 63 && (bi & (_mask <<= 1)) == 0L) {
        }
        if (_offset > 63) {
            int length = _bits.length;
            while (++_index < length && _bits[_index] == 0L) {
            }
            if (_index >= length) {
                this.index = length;
                return;
            }
            _offset = 0;
            _mask = 1L;
            bi = _bits[_index];
            while ((bi & _mask) == 0L) {
                _mask <<= 1;
                ++_offset;
            }
        }
        this.index = _index;
        this.mask = _mask;
        this.offset = _offset;
    }

    public boolean hasMoreElements() {
        return this.index < this.bits.length;
    }

    public int nextElement() {
        if (this.index >= this.bits.length) {
            throw new NoSuchElementException();
        }
        int x = (this.index << 6) + this.offset;
        this.advance();
        return x;
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreElements();
    }

    @Override
    public int nextInt() {
        return this.nextElement();
    }
}

