// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package mybusinesslodging provides access to the My Business Lodging API.
//
// For product documentation, see: https://developers.google.com/my-business/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/mybusinesslodging/v1"
//	...
//	ctx := context.Background()
//	mybusinesslodgingService, err := mybusinesslodging.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	mybusinesslodgingService, err := mybusinesslodging.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	mybusinesslodgingService, err := mybusinesslodging.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package mybusinesslodging // import "google.golang.org/api/mybusinesslodging/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "mybusinesslodging:v1"
const apiName = "mybusinesslodging"
const apiVersion = "v1"
const basePath = "https://mybusinesslodging.googleapis.com/"
const basePathTemplate = "https://mybusinesslodging.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://mybusinesslodging.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Locations = NewLocationsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Locations *LocationsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewLocationsService(s *Service) *LocationsService {
	rs := &LocationsService{s: s}
	rs.Lodging = NewLocationsLodgingService(s)
	return rs
}

type LocationsService struct {
	s *Service

	Lodging *LocationsLodgingService
}

func NewLocationsLodgingService(s *Service) *LocationsLodgingService {
	rs := &LocationsLodgingService{s: s}
	return rs
}

type LocationsLodgingService struct {
	s *Service
}

// Accessibility: Physical adaptations made to the property in consideration of
// varying levels of human physical ability.
type Accessibility struct {
	// MobilityAccessible: Mobility accessible. Throughout the property there are
	// physical adaptations to ease the stay of a person in a wheelchair, such as
	// auto-opening doors, wide elevators, wide bathrooms or ramps.
	MobilityAccessible bool `json:"mobilityAccessible,omitempty"`
	// MobilityAccessibleElevator: Mobility accessible elevator. A lift that
	// transports people from one level to another and is built to accommodate a
	// wheelchair-using passenger owing to the width of its doors and placement of
	// call buttons.
	MobilityAccessibleElevator bool `json:"mobilityAccessibleElevator,omitempty"`
	// MobilityAccessibleElevatorException: Mobility accessible elevator exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MobilityAccessibleElevatorException string `json:"mobilityAccessibleElevatorException,omitempty"`
	// MobilityAccessibleException: Mobility accessible exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MobilityAccessibleException string `json:"mobilityAccessibleException,omitempty"`
	// MobilityAccessibleParking: Mobility accessible parking. The presence of a
	// marked, designated area of prescribed size in which only registered, labeled
	// vehicles transporting a person with physical challenges may park.
	MobilityAccessibleParking bool `json:"mobilityAccessibleParking,omitempty"`
	// MobilityAccessibleParkingException: Mobility accessible parking exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MobilityAccessibleParkingException string `json:"mobilityAccessibleParkingException,omitempty"`
	// MobilityAccessiblePool: Mobility accessible pool. A swimming pool equipped
	// with a mechanical chair that can be lowered and raised for the purpose of
	// moving physically challenged guests into and out of the pool. May be powered
	// by electricity or water. Also known as pool lift.
	MobilityAccessiblePool bool `json:"mobilityAccessiblePool,omitempty"`
	// MobilityAccessiblePoolException: Mobility accessible pool exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MobilityAccessiblePoolException string `json:"mobilityAccessiblePoolException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MobilityAccessible") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MobilityAccessible") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Accessibility) MarshalJSON() ([]byte, error) {
	type NoMethod Accessibility
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Activities: Amenities and features related to leisure and play.
type Activities struct {
	// BeachAccess: Beach access. The hotel property is in close proximity to a
	// beach and offers a way to get to that beach. This can include a route to the
	// beach such as stairs down if hotel is on a bluff, or a short trail. Not the
	// same as beachfront (with beach access, the hotel's proximity is close to but
	// not right on the beach).
	BeachAccess bool `json:"beachAccess,omitempty"`
	// BeachAccessException: Beach access exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BeachAccessException string `json:"beachAccessException,omitempty"`
	// BeachFront: Breach front. The hotel property is physically located on the
	// beach alongside an ocean, sea, gulf, or bay. It is not on a lake, river,
	// stream, or pond. The hotel is not separated from the beach by a public road
	// allowing vehicular, pedestrian, or bicycle traffic.
	BeachFront bool `json:"beachFront,omitempty"`
	// BeachFrontException: Beach front exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BeachFrontException string `json:"beachFrontException,omitempty"`
	// BicycleRental: Bicycle rental. The hotel owns bicycles that it permits
	// guests to borrow and use. Can be free or for a fee.
	BicycleRental bool `json:"bicycleRental,omitempty"`
	// BicycleRentalException: Bicycle rental exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BicycleRentalException string `json:"bicycleRentalException,omitempty"`
	// BoutiqueStores: Boutique stores. There are stores selling clothing, jewelry,
	// art and decor either on hotel premises or very close by. Does not refer to
	// the hotel gift shop or convenience store.
	BoutiqueStores bool `json:"boutiqueStores,omitempty"`
	// BoutiqueStoresException: Boutique stores exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BoutiqueStoresException string `json:"boutiqueStoresException,omitempty"`
	// Casino: Casino. A space designated for gambling and gaming featuring
	// croupier-run table and card games, as well as electronic slot machines. May
	// be on hotel premises or located nearby.
	Casino bool `json:"casino,omitempty"`
	// CasinoException: Casino exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CasinoException string `json:"casinoException,omitempty"`
	// FreeBicycleRental: Free bicycle rental. The hotel owns bicycles that it
	// permits guests to borrow and use for free.
	FreeBicycleRental bool `json:"freeBicycleRental,omitempty"`
	// FreeBicycleRentalException: Free bicycle rental exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FreeBicycleRentalException string `json:"freeBicycleRentalException,omitempty"`
	// FreeWatercraftRental: Free watercraft rental. The hotel owns watercraft that
	// it permits guests to borrow and use for free.
	FreeWatercraftRental bool `json:"freeWatercraftRental,omitempty"`
	// FreeWatercraftRentalException: Free Watercraft rental exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FreeWatercraftRentalException string `json:"freeWatercraftRentalException,omitempty"`
	// GameRoom: Game room. There is a room at the hotel containing electronic
	// machines for play such as pinball, prize machines, driving simulators, and
	// other items commonly found at a family fun center or arcade. May also
	// include non-electronic games like pool, foosball, darts, and more. May or
	// may not be designed for children. Also known as arcade, fun room, or family
	// fun center.
	GameRoom bool `json:"gameRoom,omitempty"`
	// GameRoomException: Game room exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	GameRoomException string `json:"gameRoomException,omitempty"`
	// Golf: Golf. There is a golf course on hotel grounds or there is a nearby,
	// independently run golf course that allows use by hotel guests. Can be free
	// or for a fee.
	Golf bool `json:"golf,omitempty"`
	// GolfException: Golf exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	GolfException string `json:"golfException,omitempty"`
	// HorsebackRiding: Horseback riding. The hotel has a horse barn onsite or an
	// affiliation with a nearby barn to allow for guests to sit astride a horse
	// and direct it to walk, trot, cantor, gallop and/or jump. Can be in a riding
	// ring, on designated paths, or in the wilderness. May or may not involve
	// instruction.
	HorsebackRiding bool `json:"horsebackRiding,omitempty"`
	// HorsebackRidingException: Horseback riding exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	HorsebackRidingException string `json:"horsebackRidingException,omitempty"`
	// Nightclub: Nightclub. There is a room at the hotel with a bar, a dance
	// floor, and seating where designated staffers play dance music. There may
	// also be a designated area for the performance of live music, singing and
	// comedy acts.
	Nightclub bool `json:"nightclub,omitempty"`
	// NightclubException: Nightclub exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	NightclubException string `json:"nightclubException,omitempty"`
	// PrivateBeach: Private beach. The beach which is in close proximity to the
	// hotel is open only to guests.
	PrivateBeach bool `json:"privateBeach,omitempty"`
	// PrivateBeachException: Private beach exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PrivateBeachException string `json:"privateBeachException,omitempty"`
	// Scuba: Scuba. The provision for guests to dive under naturally occurring
	// water fitted with a self-contained underwater breathing apparatus (SCUBA)
	// for the purpose of exploring underwater life. Apparatus consists of a tank
	// providing oxygen to the diver through a mask. Requires certification of the
	// diver and supervision. The hotel may have the activity at its own waterfront
	// or have an affiliation with a nearby facility. Required equipment is most
	// often supplied to guests. Can be free or for a fee. Not snorkeling. Not done
	// in a swimming pool.
	Scuba bool `json:"scuba,omitempty"`
	// ScubaException: Scuba exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ScubaException string `json:"scubaException,omitempty"`
	// Snorkeling: Snorkeling. The provision for guests to participate in a
	// recreational water activity in which swimmers wear a diving mask, a simple,
	// shaped breathing tube and flippers/swim fins for the purpose of exploring
	// below the surface of an ocean, gulf or lake. Does not usually require user
	// certification or professional supervision. Equipment may or may not be
	// available for rent or purchase. Not scuba diving.
	Snorkeling bool `json:"snorkeling,omitempty"`
	// SnorkelingException: Snorkeling exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SnorkelingException string `json:"snorkelingException,omitempty"`
	// Tennis: Tennis. The hotel has the requisite court(s) on site or has an
	// affiliation with a nearby facility for the purpose of providing guests with
	// the opportunity to play a two-sided court-based game in which players use a
	// stringed racquet to hit a ball across a net to the side of the opposing
	// player. The court can be indoors or outdoors. Instructors, racquets and
	// balls may or may not be provided.
	Tennis bool `json:"tennis,omitempty"`
	// TennisException: Tennis exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TennisException string `json:"tennisException,omitempty"`
	// WaterSkiing: Water skiing. The provision of giving guests the opportunity to
	// be pulled across naturally occurring water while standing on skis and
	// holding a tow rope attached to a motorboat. Can occur on hotel premises or
	// at a nearby waterfront. Most often performed in a lake or ocean.
	WaterSkiing bool `json:"waterSkiing,omitempty"`
	// WaterSkiingException: Water skiing exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WaterSkiingException string `json:"waterSkiingException,omitempty"`
	// WatercraftRental: Watercraft rental. The hotel owns water vessels that it
	// permits guests to borrow and use. Can be free or for a fee. Watercraft may
	// include boats, pedal boats, rowboats, sailboats, powerboats, canoes, kayaks,
	// or personal watercraft (such as a Jet Ski).
	WatercraftRental bool `json:"watercraftRental,omitempty"`
	// WatercraftRentalException: Watercraft rental exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WatercraftRentalException string `json:"watercraftRentalException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BeachAccess") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BeachAccess") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Activities) MarshalJSON() ([]byte, error) {
	type NoMethod Activities
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Business: Features of the property of specific interest to the business
// traveler.
type Business struct {
	// BusinessCenter: Business center. A designated room at the hotel with one or
	// more desks and equipped with guest-use computers, printers, fax machines
	// and/or photocopiers. May or may not be open 24/7. May or may not require a
	// key to access. Not a meeting room or conference room.
	BusinessCenter bool `json:"businessCenter,omitempty"`
	// BusinessCenterException: Business center exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BusinessCenterException string `json:"businessCenterException,omitempty"`
	// MeetingRooms: Meeting rooms. Rooms at the hotel designated for
	// business-related gatherings. Rooms are usually equipped with tables or
	// desks, office chairs and audio/visual facilities to allow for presentations
	// and conference calls. Also known as conference rooms.
	MeetingRooms bool `json:"meetingRooms,omitempty"`
	// MeetingRoomsCount: Meeting rooms count. The number of meeting rooms at the
	// property.
	MeetingRoomsCount int64 `json:"meetingRoomsCount,omitempty"`
	// MeetingRoomsCountException: Meeting rooms count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MeetingRoomsCountException string `json:"meetingRoomsCountException,omitempty"`
	// MeetingRoomsException: Meeting rooms exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MeetingRoomsException string `json:"meetingRoomsException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BusinessCenter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BusinessCenter") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Business) MarshalJSON() ([]byte, error) {
	type NoMethod Business
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Connectivity: The ways in which the property provides guests with the
// ability to access the internet.
type Connectivity struct {
	// FreeWifi: Free wifi. The hotel offers guests wifi for free.
	FreeWifi bool `json:"freeWifi,omitempty"`
	// FreeWifiException: Free wifi exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FreeWifiException string `json:"freeWifiException,omitempty"`
	// PublicAreaWifiAvailable: Public area wifi available. Guests have the ability
	// to wirelessly connect to the internet in the areas of the hotel accessible
	// to anyone. Can be free or for a fee.
	PublicAreaWifiAvailable bool `json:"publicAreaWifiAvailable,omitempty"`
	// PublicAreaWifiAvailableException: Public area wifi available exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PublicAreaWifiAvailableException string `json:"publicAreaWifiAvailableException,omitempty"`
	// PublicInternetTerminal: Public internet terminal. An area of the hotel
	// supplied with computers and designated for the purpose of providing guests
	// with the ability to access the internet.
	PublicInternetTerminal bool `json:"publicInternetTerminal,omitempty"`
	// PublicInternetTerminalException: Public internet terminal exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PublicInternetTerminalException string `json:"publicInternetTerminalException,omitempty"`
	// WifiAvailable: Wifi available. The hotel provides the ability for guests to
	// wirelessly connect to the internet. Can be in the public areas of the hotel
	// and/or in the guest rooms. Can be free or for a fee.
	WifiAvailable bool `json:"wifiAvailable,omitempty"`
	// WifiAvailableException: Wifi available exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WifiAvailableException string `json:"wifiAvailableException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FreeWifi") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FreeWifi") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Connectivity) MarshalJSON() ([]byte, error) {
	type NoMethod Connectivity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EcoCertification: An eco certificate awarded to the hotel. Deprecated: this
// message is no longer populated. All certification data is now provided by
// BeCause.
type EcoCertification struct {
	// Awarded: Whether the eco certificate was awarded or not.
	Awarded bool `json:"awarded,omitempty"`
	// AwardedException: Awarded exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	AwardedException string `json:"awardedException,omitempty"`
	// EcoCertificate: Required. The eco certificate.
	//
	// Possible values:
	//   "ECO_CERTIFICATE_UNSPECIFIED" - Default EcoCertificate. Do not use.
	//   "ISO14001" - ISO14001.
	//   "ISO50001" - ISO50001.
	//   "ASIAN_ECOTOURISM" - Asian Ecotourism Standard for Accommodations (AESA).
	//   "BIOSPHERE_RESPOSNIBLE_TOURISM" - Biosphere Responsible Tourism Standard.
	//   "BUREAU_VERITAS" - Bureau Veritas.
	//   "CONTROL_UNION" - Control Union.
	//   "EARTHCHECK" - EarthCheck.
	//   "ECO_CERTIFICATION_MALTA" - Eco-Certification Malta Standard.
	//   "ECOTOURISM_AUSTRALIAS_ECO" - Ecotourism Australia's ECO Certification
	// Standard.
	//   "GREAT_GREEN_DEAL" - GREAT Green Deal Certification.
	//   "GREEN_GLOBE" - Green Globe.
	//   "GREEN_GROWTH2050" - Green Growth 2050 Standard.
	//   "GREEN_KEY" - Green Key.
	//   "GREEN_KEY_ECO_RATING" - Geen Key Eco Rating.
	//   "GREEN_SEAL" - Green Seal.
	//   "GREEN_STAR" - Green Star Hotel Standard.
	//   "GREEN_TOURISM_ACTIVE" - Green Tourism Active Standard.
	//   "HILTON_LIGHTSTAY" - Hilton LightStay.
	//   "HOSTELLING_INTERNATIONALS_QUALITY_AND_SUSTAINABILITY" - Hostelling
	// International's Quality and Sustainability Standard.
	//   "HOTELES_MAS_VERDES" - Hoteles más Verdes (AHT) Standard.
	//   "NORDIC_SWAN_ECOLABEL" - Nordic Swan Ecolabel.
	//   "PREFERRED_BY_NATURE_SUSTAINABLE_TOURISM" - Preferred by Nature
	// Sustainable Tourism Standard for Accommodation.
	//   "SUSTAINABLE_TRAVEL_IRELAND" - Sustainable Travel Ireland – GSTC
	// Industry Criteria.
	//   "TOF_TIGERS_INITITIVES_PUG" - TOFTigers Initiative's Pug Standard.
	//   "TRAVELIFE" - Travelife Standard for Hotels & Accommodations.
	//   "UNITED_CERTIFICATION_SYSTEMS_LIMITED" - United Certification Systems
	// Limited.
	//   "VIREO_SRL" - Vireo Srl.
	EcoCertificate string `json:"ecoCertificate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Awarded") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Awarded") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EcoCertification) MarshalJSON() ([]byte, error) {
	type NoMethod EcoCertification
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EnergyEfficiency: Energy efficiency practices implemented at the hotel.
type EnergyEfficiency struct {
	// CarbonFreeEnergySources: Carbon free energy sources. Property sources
	// carbon-free electricity via at least one of the following methods: on-site
	// clean energy generation, power purchase agreement(s) with clean energy
	// generators, green power provided by electricity supplier, or purchases of
	// Energy Attribute Certificates (such as Renewable Energy Certificates or
	// Guarantees of Origin).
	CarbonFreeEnergySources bool `json:"carbonFreeEnergySources,omitempty"`
	// CarbonFreeEnergySourcesException: Carbon free energy sources exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CarbonFreeEnergySourcesException string `json:"carbonFreeEnergySourcesException,omitempty"`
	// EnergyConservationProgram: Energy conservation program. The property tracks
	// corporate-level Scope 1 and 2 GHG emissions, and Scope 3 emissions if
	// available. The property has a commitment to implement initiatives that
	// reduce GHG emissions year over year. The property has shown an absolute
	// reduction in emissions for at least 2 years. Emissions are either verfied by
	// a third-party and/or published in external communications.
	EnergyConservationProgram bool `json:"energyConservationProgram,omitempty"`
	// EnergyConservationProgramException: Energy conservation program exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	EnergyConservationProgramException string `json:"energyConservationProgramException,omitempty"`
	// EnergyEfficientHeatingAndCoolingSystems: Energy efficient heating and
	// cooling systems. The property doesn't use chlorofluorocarbon (CFC)-based
	// refrigerants in heating, ventilating, and air-conditioning systems unless a
	// third-party audit shows it's not economically feasible. The CFC-based
	// refrigerants which are used should have a Global Warming Potential (GWP) ≤
	// 10. The property uses occupancy sensors on HVAC systems in back-of-house
	// spaces, meeting rooms, and other low-traffic areas.
	EnergyEfficientHeatingAndCoolingSystems bool `json:"energyEfficientHeatingAndCoolingSystems,omitempty"`
	// EnergyEfficientHeatingAndCoolingSystemsException: Energy efficient heating
	// and cooling systems exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	EnergyEfficientHeatingAndCoolingSystemsException string `json:"energyEfficientHeatingAndCoolingSystemsException,omitempty"`
	// EnergyEfficientLighting: Energy efficient lighting. At least 75% of the
	// property's lighting is energy efficient, using lighting that is more than 45
	// lumens per watt – typically LED or CFL lightbulbs.
	EnergyEfficientLighting bool `json:"energyEfficientLighting,omitempty"`
	// EnergyEfficientLightingException: Energy efficient lighting exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	EnergyEfficientLightingException string `json:"energyEfficientLightingException,omitempty"`
	// EnergySavingThermostats: Energy saving thermostats. The property installed
	// energy-saving thermostats throughout the building to conserve energy when
	// rooms or areas are not in use. Energy-saving thermostats are devices that
	// control heating/cooling in the building by learning temperature preferences
	// and automatically adjusting to energy-saving temperatures as the default.
	// The thermostats are automatically set to a temperature between 68-78 degrees
	// F (20-26 °C), depending on seasonality. In the winter, set the thermostat
	// to 68°F (20°C) when the room is occupied, lowering room temperature when
	// unoccupied. In the summer, set the thermostat to 78°F (26°C) when the room
	// is occupied.
	EnergySavingThermostats bool `json:"energySavingThermostats,omitempty"`
	// EnergySavingThermostatsException: Energy saving thermostats exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	EnergySavingThermostatsException string `json:"energySavingThermostatsException,omitempty"`
	// GreenBuildingDesign: Output only. Green building design. True if the
	// property has been awarded a relevant certification.
	GreenBuildingDesign bool `json:"greenBuildingDesign,omitempty"`
	// GreenBuildingDesignException: Output only. Green building design exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	GreenBuildingDesignException string `json:"greenBuildingDesignException,omitempty"`
	// IndependentOrganizationAuditsEnergyUse: Independent organization audits
	// energy use. The property conducts an energy audit at least every 5 years,
	// the results of which are either verified by a third-party and/or published
	// in external communications. An energy audit is a detailed assessment of the
	// facility which provides recommendations to existing operations and
	// procedures to improve energy efficiency, available incentives or rebates,and
	// opportunities for improvements through renovations or upgrades. Examples of
	// organizations that conduct credible third party audits include: Engie
	// Impact, DNV GL (EU), Dexma, and local utility providers (they often provide
	// energy and water audits).
	IndependentOrganizationAuditsEnergyUse bool `json:"independentOrganizationAuditsEnergyUse,omitempty"`
	// IndependentOrganizationAuditsEnergyUseException: Independent organization
	// audits energy use exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	IndependentOrganizationAuditsEnergyUseException string `json:"independentOrganizationAuditsEnergyUseException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CarbonFreeEnergySources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CarbonFreeEnergySources") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EnergyEfficiency) MarshalJSON() ([]byte, error) {
	type NoMethod EnergyEfficiency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EnhancedCleaning: Enhanced cleaning measures implemented by the hotel during
// COVID-19.
type EnhancedCleaning struct {
	// CommercialGradeDisinfectantCleaning: Commercial-grade disinfectant used to
	// clean the property.
	CommercialGradeDisinfectantCleaning bool `json:"commercialGradeDisinfectantCleaning,omitempty"`
	// CommercialGradeDisinfectantCleaningException: Commercial grade disinfectant
	// cleaning exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CommercialGradeDisinfectantCleaningException string `json:"commercialGradeDisinfectantCleaningException,omitempty"`
	// CommonAreasEnhancedCleaning: Enhanced cleaning of common areas.
	CommonAreasEnhancedCleaning bool `json:"commonAreasEnhancedCleaning,omitempty"`
	// CommonAreasEnhancedCleaningException: Common areas enhanced cleaning
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CommonAreasEnhancedCleaningException string `json:"commonAreasEnhancedCleaningException,omitempty"`
	// EmployeesTrainedCleaningProcedures: Employees trained in COVID-19 cleaning
	// procedures.
	EmployeesTrainedCleaningProcedures bool `json:"employeesTrainedCleaningProcedures,omitempty"`
	// EmployeesTrainedCleaningProceduresException: Employees trained cleaning
	// procedures exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	EmployeesTrainedCleaningProceduresException string `json:"employeesTrainedCleaningProceduresException,omitempty"`
	// EmployeesTrainedThoroughHandWashing: Employees trained in thorough
	// hand-washing.
	EmployeesTrainedThoroughHandWashing bool `json:"employeesTrainedThoroughHandWashing,omitempty"`
	// EmployeesTrainedThoroughHandWashingException: Employees trained thorough
	// hand washing exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	EmployeesTrainedThoroughHandWashingException string `json:"employeesTrainedThoroughHandWashingException,omitempty"`
	// EmployeesWearProtectiveEquipment: Employees wear masks, face shields, and/or
	// gloves.
	EmployeesWearProtectiveEquipment bool `json:"employeesWearProtectiveEquipment,omitempty"`
	// EmployeesWearProtectiveEquipmentException: Employees wear protective
	// equipment exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	EmployeesWearProtectiveEquipmentException string `json:"employeesWearProtectiveEquipmentException,omitempty"`
	// GuestRoomsEnhancedCleaning: Enhanced cleaning of guest rooms.
	GuestRoomsEnhancedCleaning bool `json:"guestRoomsEnhancedCleaning,omitempty"`
	// GuestRoomsEnhancedCleaningException: Guest rooms enhanced cleaning
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	GuestRoomsEnhancedCleaningException string `json:"guestRoomsEnhancedCleaningException,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CommercialGradeDisinfectantCleaning") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "CommercialGradeDisinfectantCleaning") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s EnhancedCleaning) MarshalJSON() ([]byte, error) {
	type NoMethod EnhancedCleaning
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Families: Services and amenities for families and young guests.
type Families struct {
	// Babysitting: Babysitting. Child care that is offered by hotel staffers or
	// coordinated by hotel staffers with local child care professionals. Can be
	// free or for a fee.
	Babysitting bool `json:"babysitting,omitempty"`
	// BabysittingException: Babysitting exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BabysittingException string `json:"babysittingException,omitempty"`
	// KidsActivities: Kids activities. Recreational options such as sports, films,
	// crafts and games designed for the enjoyment of children and offered at the
	// hotel. May or may not be supervised. May or may not be at a designated time
	// or place. Cab be free or for a fee.
	KidsActivities bool `json:"kidsActivities,omitempty"`
	// KidsActivitiesException: Kids activities exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	KidsActivitiesException string `json:"kidsActivitiesException,omitempty"`
	// KidsClub: Kids club. An organized program of group activities held at the
	// hotel and designed for the enjoyment of children. Facilitated by hotel staff
	// (or staff procured by the hotel) in an area(s) designated for the purpose of
	// entertaining children without their parents. May include games, outings,
	// water sports, team sports, arts and crafts, and films. Usually has set
	// hours. Can be free or for a fee. Also known as Kids Camp or Kids program.
	KidsClub bool `json:"kidsClub,omitempty"`
	// KidsClubException: Kids club exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	KidsClubException string `json:"kidsClubException,omitempty"`
	// KidsFriendly: Kids friendly. The hotel has one or more special features for
	// families with children, such as reduced rates, child-sized beds, kids' club,
	// babysitting service, or suitable place to play on premises.
	KidsFriendly bool `json:"kidsFriendly,omitempty"`
	// KidsFriendlyException: Kids friendly exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	KidsFriendlyException string `json:"kidsFriendlyException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Babysitting") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Babysitting") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Families) MarshalJSON() ([]byte, error) {
	type NoMethod Families
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FoodAndDrink: Meals, snacks, and beverages available at the property.
type FoodAndDrink struct {
	// Bar: Bar. A designated room, lounge or area of an on-site restaurant with
	// seating at a counter behind which a hotel staffer takes the guest's order
	// and provides the requested alcoholic drink. Can be indoors or outdoors. Also
	// known as Pub.
	Bar bool `json:"bar,omitempty"`
	// BarException: Bar exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BarException string `json:"barException,omitempty"`
	// BreakfastAvailable: Breakfast available. The morning meal is offered to all
	// guests. Can be free or for a fee.
	BreakfastAvailable bool `json:"breakfastAvailable,omitempty"`
	// BreakfastAvailableException: Breakfast available exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BreakfastAvailableException string `json:"breakfastAvailableException,omitempty"`
	// BreakfastBuffet: Breakfast buffet. Breakfast meal service where guests serve
	// themselves from a variety of dishes/foods that are put out on a table.
	BreakfastBuffet bool `json:"breakfastBuffet,omitempty"`
	// BreakfastBuffetException: Breakfast buffet exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BreakfastBuffetException string `json:"breakfastBuffetException,omitempty"`
	// Buffet: Buffet. A type of meal where guests serve themselves from a variety
	// of dishes/foods that are put out on a table. Includes lunch and/or dinner
	// meals. A breakfast-only buffet is not sufficient.
	Buffet bool `json:"buffet,omitempty"`
	// BuffetException: Buffet exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BuffetException string `json:"buffetException,omitempty"`
	// DinnerBuffet: Dinner buffet. Dinner meal service where guests serve
	// themselves from a variety of dishes/foods that are put out on a table.
	DinnerBuffet bool `json:"dinnerBuffet,omitempty"`
	// DinnerBuffetException: Dinner buffet exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	DinnerBuffetException string `json:"dinnerBuffetException,omitempty"`
	// FreeBreakfast: Free breakfast. Breakfast is offered for free to all guests.
	// Does not apply if limited to certain room packages.
	FreeBreakfast bool `json:"freeBreakfast,omitempty"`
	// FreeBreakfastException: Free breakfast exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FreeBreakfastException string `json:"freeBreakfastException,omitempty"`
	// Restaurant: Restaurant. A business onsite at the hotel that is open to the
	// public as well as guests, and offers meals and beverages to consume at
	// tables or counters. May or may not include table service. Also known as
	// cafe, buffet, eatery. A "breakfast room" where the hotel serves breakfast
	// only to guests (not the general public) does not count as a restaurant.
	Restaurant bool `json:"restaurant,omitempty"`
	// RestaurantException: Restaurant exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	RestaurantException string `json:"restaurantException,omitempty"`
	// RestaurantsCount: Restaurants count. The number of restaurants at the hotel.
	RestaurantsCount int64 `json:"restaurantsCount,omitempty"`
	// RestaurantsCountException: Restaurants count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	RestaurantsCountException string `json:"restaurantsCountException,omitempty"`
	// RoomService: Room service. A hotel staffer delivers meals prepared onsite to
	// a guest's room as per their request. May or may not be available during
	// specific hours. Services should be available to all guests (not based on
	// rate/room booked/reward program, etc).
	RoomService bool `json:"roomService,omitempty"`
	// RoomServiceException: Room service exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	RoomServiceException string `json:"roomServiceException,omitempty"`
	// TableService: Table service. A restaurant in which a staff member is
	// assigned to a guest's table to take their order, deliver and clear away
	// food, and deliver the bill, if applicable. Also known as sit-down
	// restaurant.
	TableService bool `json:"tableService,omitempty"`
	// TableServiceException: Table service exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TableServiceException string `json:"tableServiceException,omitempty"`
	// TwentyFourHourRoomService: 24hr room service. Room service is available 24
	// hours a day.
	TwentyFourHourRoomService bool `json:"twentyFourHourRoomService,omitempty"`
	// TwentyFourHourRoomServiceException: 24hr room service exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TwentyFourHourRoomServiceException string `json:"twentyFourHourRoomServiceException,omitempty"`
	// VendingMachine: Vending machine. A glass-fronted mechanized cabinet
	// displaying and dispensing snacks and beverages for purchase by coins, paper
	// money and/or credit cards.
	VendingMachine bool `json:"vendingMachine,omitempty"`
	// VendingMachineException: Vending machine exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	VendingMachineException string `json:"vendingMachineException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bar") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bar") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FoodAndDrink) MarshalJSON() ([]byte, error) {
	type NoMethod FoodAndDrink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetGoogleUpdatedLodgingResponse: Response message for
// LodgingService.GetGoogleUpdatedLodging
type GetGoogleUpdatedLodgingResponse struct {
	// DiffMask: Required. The fields in the Lodging that have been updated by
	// Google. Repeated field items are not individually specified.
	DiffMask string `json:"diffMask,omitempty"`
	// Lodging: Required. The Google updated Lodging.
	Lodging *Lodging `json:"lodging,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DiffMask") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiffMask") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetGoogleUpdatedLodgingResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetGoogleUpdatedLodgingResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuestUnitFeatures: Features and available amenities in the guest unit.
type GuestUnitFeatures struct {
	// BungalowOrVilla: Bungalow or villa. An independent structure that is part of
	// a hotel or resort that is rented to one party for a vacation stay. The hotel
	// or resort may be completely comprised of bungalows or villas, or they may be
	// one of several guestroom options. Guests in the bungalows or villas most
	// often have the same, if not more, amenities and services offered to guests
	// in other guestroom types.
	BungalowOrVilla bool `json:"bungalowOrVilla,omitempty"`
	// BungalowOrVillaException: Bungalow or villa exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BungalowOrVillaException string `json:"bungalowOrVillaException,omitempty"`
	// ConnectingUnitAvailable: Connecting unit available. A guestroom type that
	// features access to an adjacent guestroom for the purpose of booking both
	// rooms. Most often used by families who need more than one room to
	// accommodate the number of people in their group.
	ConnectingUnitAvailable bool `json:"connectingUnitAvailable,omitempty"`
	// ConnectingUnitAvailableException: Connecting unit available exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ConnectingUnitAvailableException string `json:"connectingUnitAvailableException,omitempty"`
	// ExecutiveFloor: Executive floor. A floor of the hotel where the guestrooms
	// are only bookable by members of the hotel's frequent guest membership
	// program. Benefits of this room class include access to a designated lounge
	// which may or may not feature free breakfast, cocktails or other perks
	// specific to members of the program.
	ExecutiveFloor bool `json:"executiveFloor,omitempty"`
	// ExecutiveFloorException: Executive floor exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ExecutiveFloorException string `json:"executiveFloorException,omitempty"`
	// MaxAdultOccupantsCount: Max adult occupants count. The total number of adult
	// guests allowed to stay overnight in the guestroom.
	MaxAdultOccupantsCount int64 `json:"maxAdultOccupantsCount,omitempty"`
	// MaxAdultOccupantsCountException: Max adult occupants count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MaxAdultOccupantsCountException string `json:"maxAdultOccupantsCountException,omitempty"`
	// MaxChildOccupantsCount: Max child occupants count. The total number of
	// children allowed to stay overnight in the room.
	MaxChildOccupantsCount int64 `json:"maxChildOccupantsCount,omitempty"`
	// MaxChildOccupantsCountException: Max child occupants count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MaxChildOccupantsCountException string `json:"maxChildOccupantsCountException,omitempty"`
	// MaxOccupantsCount: Max occupants count. The total number of guests allowed
	// to stay overnight in the guestroom.
	MaxOccupantsCount int64 `json:"maxOccupantsCount,omitempty"`
	// MaxOccupantsCountException: Max occupants count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MaxOccupantsCountException string `json:"maxOccupantsCountException,omitempty"`
	// PrivateHome: Private home. A privately owned home (house, townhouse,
	// apartment, cabin, bungalow etc) that may or not serve as the owner's
	// residence, but is rented out in its entirety or by the room(s) to paying
	// guest(s) for vacation stays. Not for lease-based, long-term residency.
	PrivateHome bool `json:"privateHome,omitempty"`
	// PrivateHomeException: Private home exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PrivateHomeException string `json:"privateHomeException,omitempty"`
	// Suite: Suite. A guestroom category that implies both a bedroom area and a
	// separate living area. There may or may not be full walls and doors
	// separating the two areas, but regardless, they are very distinct. Does not
	// mean a couch or chair in a bedroom.
	Suite bool `json:"suite,omitempty"`
	// SuiteException: Suite exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SuiteException string `json:"suiteException,omitempty"`
	// Tier: Tier. Classification of the unit based on available
	// features/amenities. A non-standard tier is only permitted if at least one
	// other unit type falls under the standard tier.
	//
	// Possible values:
	//   "UNIT_TIER_UNSPECIFIED" - Default tier. Equivalent to STANDARD. Prefer
	// using STANDARD directly.
	//   "STANDARD_UNIT" - Standard unit. The predominant and most basic guestroom
	// type available at the hotel. All other guestroom types include the
	// features/amenities of this room, as well as additional features/amenities.
	//   "DELUXE_UNIT" - Deluxe unit. A guestroom type that builds on the features
	// of the standard guestroom by offering additional amenities and/or more
	// space, and/or views. The room rate is higher than that of the standard room
	// type. Also known as Superior. Only allowed if another unit type is a
	// standard tier.
	Tier string `json:"tier,omitempty"`
	// TierException: Tier exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TierException string `json:"tierException,omitempty"`
	// TotalLivingAreas: Features available in the living areas in the guest unit.
	TotalLivingAreas *LivingArea `json:"totalLivingAreas,omitempty"`
	// Views: Views available from the guest unit itself.
	Views *ViewsFromUnit `json:"views,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BungalowOrVilla") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BungalowOrVilla") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuestUnitFeatures) MarshalJSON() ([]byte, error) {
	type NoMethod GuestUnitFeatures
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GuestUnitType: A specific type of unit primarily defined by its features.
type GuestUnitType struct {
	// Codes: Required. Unit or room code identifiers for a single GuestUnitType.
	// Each code must be unique within a Lodging instance.
	Codes []string `json:"codes,omitempty"`
	// Features: Features and available amenities of the GuestUnitType.
	Features *GuestUnitFeatures `json:"features,omitempty"`
	// Label: Required. Short, English label or name of the GuestUnitType. Target
	// <50 chars.
	Label string `json:"label,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Codes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Codes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GuestUnitType) MarshalJSON() ([]byte, error) {
	type NoMethod GuestUnitType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HealthAndSafety: Health and safety measures implemented by the hotel during
// COVID-19.
type HealthAndSafety struct {
	// EnhancedCleaning: Enhanced cleaning measures implemented by the hotel during
	// COVID-19.
	EnhancedCleaning *EnhancedCleaning `json:"enhancedCleaning,omitempty"`
	// IncreasedFoodSafety: Increased food safety measures implemented by the hotel
	// during COVID-19.
	IncreasedFoodSafety *IncreasedFoodSafety `json:"increasedFoodSafety,omitempty"`
	// MinimizedContact: Minimized contact measures implemented by the hotel during
	// COVID-19.
	MinimizedContact *MinimizedContact `json:"minimizedContact,omitempty"`
	// PersonalProtection: Personal protection measures implemented by the hotel
	// during COVID-19.
	PersonalProtection *PersonalProtection `json:"personalProtection,omitempty"`
	// PhysicalDistancing: Physical distancing measures implemented by the hotel
	// during COVID-19.
	PhysicalDistancing *PhysicalDistancing `json:"physicalDistancing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnhancedCleaning") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnhancedCleaning") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HealthAndSafety) MarshalJSON() ([]byte, error) {
	type NoMethod HealthAndSafety
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Housekeeping: Conveniences provided in guest units to facilitate an easier,
// more comfortable stay.
type Housekeeping struct {
	// DailyHousekeeping: Daily housekeeping. Guest units are cleaned by hotel
	// staff daily during guest's stay.
	DailyHousekeeping bool `json:"dailyHousekeeping,omitempty"`
	// DailyHousekeepingException: Daily housekeeping exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	DailyHousekeepingException string `json:"dailyHousekeepingException,omitempty"`
	// HousekeepingAvailable: Housekeeping available. Guest units are cleaned by
	// hotel staff during guest's stay. Schedule may vary from daily, weekly, or
	// specific days of the week.
	HousekeepingAvailable bool `json:"housekeepingAvailable,omitempty"`
	// HousekeepingAvailableException: Housekeeping available exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	HousekeepingAvailableException string `json:"housekeepingAvailableException,omitempty"`
	// TurndownService: Turndown service. Hotel staff enters guest units to prepare
	// the bed for sleep use. May or may not include some light housekeeping. May
	// or may not include an evening snack or candy. Also known as evening service.
	TurndownService bool `json:"turndownService,omitempty"`
	// TurndownServiceException: Turndown service exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TurndownServiceException string `json:"turndownServiceException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DailyHousekeeping") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DailyHousekeeping") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Housekeeping) MarshalJSON() ([]byte, error) {
	type NoMethod Housekeeping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IncreasedFoodSafety: Increased food safety measures implemented by the hotel
// during COVID-19.
type IncreasedFoodSafety struct {
	// DiningAreasAdditionalSanitation: Additional sanitation in dining areas.
	DiningAreasAdditionalSanitation bool `json:"diningAreasAdditionalSanitation,omitempty"`
	// DiningAreasAdditionalSanitationException: Dining areas additional sanitation
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	DiningAreasAdditionalSanitationException string `json:"diningAreasAdditionalSanitationException,omitempty"`
	// DisposableFlatware: Disposable flatware.
	DisposableFlatware bool `json:"disposableFlatware,omitempty"`
	// DisposableFlatwareException: Disposable flatware exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	DisposableFlatwareException string `json:"disposableFlatwareException,omitempty"`
	// FoodPreparationAndServingAdditionalSafety: Additional safety measures during
	// food prep and serving.
	FoodPreparationAndServingAdditionalSafety bool `json:"foodPreparationAndServingAdditionalSafety,omitempty"`
	// FoodPreparationAndServingAdditionalSafetyException: Food preparation and
	// serving additional safety exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FoodPreparationAndServingAdditionalSafetyException string `json:"foodPreparationAndServingAdditionalSafetyException,omitempty"`
	// IndividualPackagedMeals: Individually-packaged meals.
	IndividualPackagedMeals bool `json:"individualPackagedMeals,omitempty"`
	// IndividualPackagedMealsException: Individual packaged meals exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	IndividualPackagedMealsException string `json:"individualPackagedMealsException,omitempty"`
	// SingleUseFoodMenus: Single-use menus.
	SingleUseFoodMenus bool `json:"singleUseFoodMenus,omitempty"`
	// SingleUseFoodMenusException: Single use food menus exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SingleUseFoodMenusException string `json:"singleUseFoodMenusException,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "DiningAreasAdditionalSanitation") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiningAreasAdditionalSanitation")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IncreasedFoodSafety) MarshalJSON() ([]byte, error) {
	type NoMethod IncreasedFoodSafety
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LanguageSpoken: Language spoken by at least one staff member.
type LanguageSpoken struct {
	// LanguageCode: Required. The BCP-47 language code for the spoken language.
	// Currently accepted codes: ar, de, en, es, fil, fr, hi, id, it, ja, ko, nl,
	// pt, ru, vi, yue, zh.
	LanguageCode string `json:"languageCode,omitempty"`
	// Spoken: At least one member of the staff can speak the language.
	Spoken bool `json:"spoken,omitempty"`
	// SpokenException: Spoken exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SpokenException string `json:"spokenException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LanguageSpoken) MarshalJSON() ([]byte, error) {
	type NoMethod LanguageSpoken
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LivingArea: An individual room, such as kitchen, bathroom, bedroom, within a
// bookable guest unit.
type LivingArea struct {
	// Accessibility: Accessibility features of the living area.
	Accessibility *LivingAreaAccessibility `json:"accessibility,omitempty"`
	// Eating: Information about eating features in the living area.
	Eating *LivingAreaEating `json:"eating,omitempty"`
	// Features: Features in the living area.
	Features *LivingAreaFeatures `json:"features,omitempty"`
	// Layout: Information about the layout of the living area.
	Layout *LivingAreaLayout `json:"layout,omitempty"`
	// Sleeping: Information about sleeping features in the living area.
	Sleeping *LivingAreaSleeping `json:"sleeping,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Accessibility") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accessibility") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LivingArea) MarshalJSON() ([]byte, error) {
	type NoMethod LivingArea
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LivingAreaAccessibility: Accessibility features of the living area.
type LivingAreaAccessibility struct {
	// AdaCompliantUnit: ADA compliant unit. A guestroom designed to accommodate
	// the physical challenges of a guest with mobility and/or auditory and/or
	// visual issues, as determined by legislative policy. Usually features
	// enlarged doorways, roll-in showers with seats, bathroom grab bars, and
	// communication equipment for the hearing and sight challenged.
	AdaCompliantUnit bool `json:"adaCompliantUnit,omitempty"`
	// AdaCompliantUnitException: ADA compliant unit exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	AdaCompliantUnitException string `json:"adaCompliantUnitException,omitempty"`
	// HearingAccessibleDoorbell: Hearing-accessible doorbell. A visual
	// indicator(s) of a knock or ring at the door.
	HearingAccessibleDoorbell bool `json:"hearingAccessibleDoorbell,omitempty"`
	// HearingAccessibleDoorbellException: Hearing-accessible doorbell exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	HearingAccessibleDoorbellException string `json:"hearingAccessibleDoorbellException,omitempty"`
	// HearingAccessibleFireAlarm: Hearing-accessible fire alarm. A device that
	// gives warning of a fire through flashing lights.
	HearingAccessibleFireAlarm bool `json:"hearingAccessibleFireAlarm,omitempty"`
	// HearingAccessibleFireAlarmException: Hearing-accessible fire alarm
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	HearingAccessibleFireAlarmException string `json:"hearingAccessibleFireAlarmException,omitempty"`
	// HearingAccessibleUnit: Hearing-accessible unit. A guestroom designed to
	// accommodate the physical challenges of a guest with auditory issues.
	HearingAccessibleUnit bool `json:"hearingAccessibleUnit,omitempty"`
	// HearingAccessibleUnitException: Hearing-accessible unit exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	HearingAccessibleUnitException string `json:"hearingAccessibleUnitException,omitempty"`
	// MobilityAccessibleBathtub: Mobility-accessible bathtub. A bathtub that
	// accomodates the physically challenged with additional railings or hand
	// grips, a transfer seat or lift, and/or a door to enable walking into the
	// tub.
	MobilityAccessibleBathtub bool `json:"mobilityAccessibleBathtub,omitempty"`
	// MobilityAccessibleBathtubException: Mobility-accessible bathtub exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MobilityAccessibleBathtubException string `json:"mobilityAccessibleBathtubException,omitempty"`
	// MobilityAccessibleShower: Mobility-accessible shower. A shower with an
	// enlarged door or access point to accommodate a wheelchair or a waterproof
	// seat for the physically challenged.
	MobilityAccessibleShower bool `json:"mobilityAccessibleShower,omitempty"`
	// MobilityAccessibleShowerException: Mobility-accessible shower exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MobilityAccessibleShowerException string `json:"mobilityAccessibleShowerException,omitempty"`
	// MobilityAccessibleToilet: Mobility-accessible toilet. A toilet with a higher
	// seat, grab bars, and/or a larger area around it to accommodate the
	// physically challenged.
	MobilityAccessibleToilet bool `json:"mobilityAccessibleToilet,omitempty"`
	// MobilityAccessibleToiletException: Mobility-accessible toilet exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MobilityAccessibleToiletException string `json:"mobilityAccessibleToiletException,omitempty"`
	// MobilityAccessibleUnit: Mobility-accessible unit. A guestroom designed to
	// accommodate the physical challenges of a guest with mobility and/or auditory
	// and/or visual issues. Usually features enlarged doorways, roll-in showers
	// with seats, bathroom grab bars, and communication equipment for the hearing
	// and sight challenged.
	MobilityAccessibleUnit bool `json:"mobilityAccessibleUnit,omitempty"`
	// MobilityAccessibleUnitException: Mobility-accessible unit exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MobilityAccessibleUnitException string `json:"mobilityAccessibleUnitException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdaCompliantUnit") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdaCompliantUnit") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LivingAreaAccessibility) MarshalJSON() ([]byte, error) {
	type NoMethod LivingAreaAccessibility
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LivingAreaEating: Information about eating features in the living area.
type LivingAreaEating struct {
	// CoffeeMaker: Coffee maker. An electric appliance that brews coffee by
	// heating and forcing water through ground coffee.
	CoffeeMaker bool `json:"coffeeMaker,omitempty"`
	// CoffeeMakerException: Coffee maker exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CoffeeMakerException string `json:"coffeeMakerException,omitempty"`
	// Cookware: Cookware. Kitchen pots, pans and utensils used in connection with
	// the preparation of food.
	Cookware bool `json:"cookware,omitempty"`
	// CookwareException: Cookware exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CookwareException string `json:"cookwareException,omitempty"`
	// Dishwasher: Dishwasher. A counter-height electrical cabinet containing racks
	// for dirty dishware, cookware and cutlery, and a dispenser for soap built
	// into the pull-down door. The cabinet is attached to the plumbing system to
	// facilitate the automatic cleaning of its contents.
	Dishwasher bool `json:"dishwasher,omitempty"`
	// DishwasherException: Dishwasher exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	DishwasherException string `json:"dishwasherException,omitempty"`
	// IndoorGrill: Indoor grill. Metal grates built into an indoor cooktop on
	// which food is cooked over an open flame or electric heat source.
	IndoorGrill bool `json:"indoorGrill,omitempty"`
	// IndoorGrillException: Indoor grill exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	IndoorGrillException string `json:"indoorGrillException,omitempty"`
	// Kettle: Kettle. A covered container with a handle and a spout used for
	// boiling water.
	Kettle bool `json:"kettle,omitempty"`
	// KettleException: Kettle exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	KettleException string `json:"kettleException,omitempty"`
	// KitchenAvailable: Kitchen available. An area of the guestroom designated for
	// the preparation and storage of food via the presence of a refrigerator, cook
	// top, oven and sink, as well as cutlery, dishes and cookware. Usually
	// includes small appliances such a coffee maker and a microwave. May or may
	// not include an automatic dishwasher.
	KitchenAvailable bool `json:"kitchenAvailable,omitempty"`
	// KitchenAvailableException: Kitchen available exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	KitchenAvailableException string `json:"kitchenAvailableException,omitempty"`
	// Microwave: Microwave. An electric oven that quickly cooks and heats food by
	// microwave energy. Smaller than a standing or wall mounted oven. Usually
	// placed on a kitchen counter, a shelf or tabletop or mounted above a cooktop.
	Microwave bool `json:"microwave,omitempty"`
	// MicrowaveException: Microwave exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MicrowaveException string `json:"microwaveException,omitempty"`
	// Minibar: Minibar. A small refrigerated cabinet in the guestroom containing
	// bottles/cans of soft drinks, mini bottles of alcohol, and snacks. The items
	// are most commonly available for a fee.
	Minibar bool `json:"minibar,omitempty"`
	// MinibarException: Minibar exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MinibarException string `json:"minibarException,omitempty"`
	// OutdoorGrill: Outdoor grill. Metal grates on which food is cooked over an
	// open flame or electric heat source. Part of an outdoor apparatus that
	// supports the grates. Also known as barbecue grill or barbecue.
	OutdoorGrill bool `json:"outdoorGrill,omitempty"`
	// OutdoorGrillException: Outdoor grill exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	OutdoorGrillException string `json:"outdoorGrillException,omitempty"`
	// Oven: Oven. A temperature controlled, heated metal cabinet powered by gas or
	// electricity in which food is placed for the purpose of cooking or reheating.
	Oven bool `json:"oven,omitempty"`
	// OvenException: Oven exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	OvenException string `json:"ovenException,omitempty"`
	// Refrigerator: Refrigerator. A large, climate-controlled electrical cabinet
	// with vertical doors. Built for the purpose of chilling and storing
	// perishable foods.
	Refrigerator bool `json:"refrigerator,omitempty"`
	// RefrigeratorException: Refrigerator exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	RefrigeratorException string `json:"refrigeratorException,omitempty"`
	// Sink: Sink. A basin with a faucet attached to a water source and used for
	// the purpose of washing and rinsing.
	Sink bool `json:"sink,omitempty"`
	// SinkException: Sink exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SinkException string `json:"sinkException,omitempty"`
	// Snackbar: Snackbar. A small cabinet in the guestroom containing snacks. The
	// items are most commonly available for a fee.
	Snackbar bool `json:"snackbar,omitempty"`
	// SnackbarException: Snackbar exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SnackbarException string `json:"snackbarException,omitempty"`
	// Stove: Stove. A kitchen appliance powered by gas or electricity for the
	// purpose of creating a flame or hot surface on which pots of food can be
	// cooked. Also known as cooktop or hob.
	Stove bool `json:"stove,omitempty"`
	// StoveException: Stove exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	StoveException string `json:"stoveException,omitempty"`
	// TeaStation: Tea station. A small area with the supplies needed to heat water
	// and make tea.
	TeaStation bool `json:"teaStation,omitempty"`
	// TeaStationException: Tea station exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TeaStationException string `json:"teaStationException,omitempty"`
	// Toaster: Toaster. A small, temperature controlled electric appliance with
	// rectangular slots at the top that are lined with heated coils for the
	// purpose of browning slices of bread products.
	Toaster bool `json:"toaster,omitempty"`
	// ToasterException: Toaster exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ToasterException string `json:"toasterException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CoffeeMaker") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CoffeeMaker") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LivingAreaEating) MarshalJSON() ([]byte, error) {
	type NoMethod LivingAreaEating
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LivingAreaFeatures: Features in the living area.
type LivingAreaFeatures struct {
	// AirConditioning: Air conditioning. An electrical machine used to cool the
	// temperature of the guestroom.
	AirConditioning bool `json:"airConditioning,omitempty"`
	// AirConditioningException: Air conditioning exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	AirConditioningException string `json:"airConditioningException,omitempty"`
	// Bathtub: Bathtub. A fixed plumbing feature set on the floor and consisting
	// of a large container that accommodates the body of an adult for the purpose
	// of seated bathing. Includes knobs or fixtures to control the temperature of
	// the water, a faucet through which the water flows, and a drain that can be
	// closed for filling and opened for draining.
	Bathtub bool `json:"bathtub,omitempty"`
	// BathtubException: Bathtub exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BathtubException string `json:"bathtubException,omitempty"`
	// Bidet: Bidet. A plumbing fixture attached to a toilet or a low, fixed sink
	// designed for the purpose of washing after toilet use.
	Bidet bool `json:"bidet,omitempty"`
	// BidetException: Bidet exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BidetException string `json:"bidetException,omitempty"`
	// Dryer: Dryer. An electrical machine designed to dry clothing.
	Dryer bool `json:"dryer,omitempty"`
	// DryerException: Dryer exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	DryerException string `json:"dryerException,omitempty"`
	// ElectronicRoomKey: Electronic room key. A card coded by the check-in
	// computer that is read by the lock on the hotel guestroom door to allow for
	// entry.
	ElectronicRoomKey bool `json:"electronicRoomKey,omitempty"`
	// ElectronicRoomKeyException: Electronic room key exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ElectronicRoomKeyException string `json:"electronicRoomKeyException,omitempty"`
	// Fireplace: Fireplace. A framed opening (aka hearth) at the base of a chimney
	// in which logs or an electrical fire feature are burned to provide a relaxing
	// ambiance or to heat the room. Often made of bricks or stone.
	Fireplace bool `json:"fireplace,omitempty"`
	// FireplaceException: Fireplace exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FireplaceException string `json:"fireplaceException,omitempty"`
	// Hairdryer: Hairdryer. A handheld electric appliance that blows
	// temperature-controlled air for the purpose of drying wet hair. Can be
	// mounted to a bathroom wall or a freestanding device stored in the
	// guestroom's bathroom or closet.
	Hairdryer bool `json:"hairdryer,omitempty"`
	// HairdryerException: Hairdryer exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	HairdryerException string `json:"hairdryerException,omitempty"`
	// Heating: Heating. An electrical machine used to warm the temperature of the
	// guestroom.
	Heating bool `json:"heating,omitempty"`
	// HeatingException: Heating exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	HeatingException string `json:"heatingException,omitempty"`
	// InunitSafe: In-unit safe. A strong fireproof cabinet with a programmable
	// lock, used for the protected storage of valuables in a guestroom. Often
	// built into a closet.
	InunitSafe bool `json:"inunitSafe,omitempty"`
	// InunitSafeException: In-unit safe exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	InunitSafeException string `json:"inunitSafeException,omitempty"`
	// InunitWifiAvailable: In-unit Wifi available. Guests can wirelessly connect
	// to the Internet in the guestroom. Can be free or for a fee.
	InunitWifiAvailable bool `json:"inunitWifiAvailable,omitempty"`
	// InunitWifiAvailableException: In-unit Wifi available exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	InunitWifiAvailableException string `json:"inunitWifiAvailableException,omitempty"`
	// IroningEquipment: Ironing equipment. A device, usually with a flat metal
	// base, that is heated to smooth, finish, or press clothes and a flat, padded,
	// cloth-covered surface on which the clothes are worked.
	IroningEquipment bool `json:"ironingEquipment,omitempty"`
	// IroningEquipmentException: Ironing equipment exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	IroningEquipmentException string `json:"ironingEquipmentException,omitempty"`
	// PayPerViewMovies: Pay per view movies. Televisions with channels that offer
	// films that can be viewed for a fee, and have an interface to allow the
	// viewer to accept the terms and approve payment.
	PayPerViewMovies bool `json:"payPerViewMovies,omitempty"`
	// PayPerViewMoviesException: Pay per view movies exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PayPerViewMoviesException string `json:"payPerViewMoviesException,omitempty"`
	// PrivateBathroom: Private bathroom. A bathroom designated for the express use
	// of the guests staying in a specific guestroom.
	PrivateBathroom bool `json:"privateBathroom,omitempty"`
	// PrivateBathroomException: Private bathroom exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PrivateBathroomException string `json:"privateBathroomException,omitempty"`
	// Shower: Shower. A fixed plumbing fixture for standing bathing that features
	// a tall spray spout or faucet through which water flows, a knob or knobs that
	// control the water's temperature, and a drain in the floor.
	Shower bool `json:"shower,omitempty"`
	// ShowerException: Shower exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ShowerException string `json:"showerException,omitempty"`
	// Toilet: Toilet. A fixed bathroom feature connected to a sewer or septic
	// system and consisting of a water-flushed bowl with a seat, as well as a
	// device that elicites the water-flushing action. Used for the process and
	// disposal of human waste.
	Toilet bool `json:"toilet,omitempty"`
	// ToiletException: Toilet exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ToiletException string `json:"toiletException,omitempty"`
	// Tv: TV. A television is available in the guestroom.
	Tv bool `json:"tv,omitempty"`
	// TvCasting: TV casting. A television equipped with a device through which the
	// video entertainment accessed on a personal computer, phone or tablet can be
	// wirelessly delivered to and viewed on the guestroom's television.
	TvCasting bool `json:"tvCasting,omitempty"`
	// TvCastingException: TV exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TvCastingException string `json:"tvCastingException,omitempty"`
	// TvException: TV exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TvException string `json:"tvException,omitempty"`
	// TvStreaming: TV streaming. Televisions that embed a range of web-based apps
	// to allow for watching media from those apps.
	TvStreaming bool `json:"tvStreaming,omitempty"`
	// TvStreamingException: TV streaming exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TvStreamingException string `json:"tvStreamingException,omitempty"`
	// UniversalPowerAdapters: Universal power adapters. A power supply for
	// electronic devices which plugs into a wall for the purpose of converting AC
	// to a single DC voltage. Also know as AC adapter or charger.
	UniversalPowerAdapters bool `json:"universalPowerAdapters,omitempty"`
	// UniversalPowerAdaptersException: Universal power adapters exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	UniversalPowerAdaptersException string `json:"universalPowerAdaptersException,omitempty"`
	// Washer: Washer. An electrical machine connected to a running water source
	// designed to launder clothing.
	Washer bool `json:"washer,omitempty"`
	// WasherException: Washer exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WasherException string `json:"washerException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AirConditioning") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AirConditioning") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LivingAreaFeatures) MarshalJSON() ([]byte, error) {
	type NoMethod LivingAreaFeatures
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LivingAreaLayout: Information about the layout of the living area.
type LivingAreaLayout struct {
	// Balcony: Balcony. An outdoor platform attached to a building and surrounded
	// by a short wall, fence or other safety railing. The balcony is accessed
	// through a door in a guestroom or suite and is for use by the guest staying
	// in that room. May or may not include seating or outdoor furniture. Is not
	// located on the ground floor. Also lanai.
	Balcony bool `json:"balcony,omitempty"`
	// BalconyException: Balcony exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BalconyException string `json:"balconyException,omitempty"`
	// LivingAreaSqMeters: Living area sq meters. The measurement in meters of the
	// area of a guestroom's living space.
	LivingAreaSqMeters float64 `json:"livingAreaSqMeters,omitempty"`
	// LivingAreaSqMetersException: Living area sq meters exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	LivingAreaSqMetersException string `json:"livingAreaSqMetersException,omitempty"`
	// Loft: Loft. A three-walled upper area accessed by stairs or a ladder that
	// overlooks the lower area of a room.
	Loft bool `json:"loft,omitempty"`
	// LoftException: Loft exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	LoftException string `json:"loftException,omitempty"`
	// NonSmoking: Non smoking. A guestroom in which the smoking of cigarettes,
	// cigars and pipes is prohibited.
	NonSmoking bool `json:"nonSmoking,omitempty"`
	// NonSmokingException: Non smoking exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	NonSmokingException string `json:"nonSmokingException,omitempty"`
	// Patio: Patio. A paved, outdoor area with seating attached to and accessed
	// through a ground-floor guestroom for use by the occupants of the guestroom.
	Patio bool `json:"patio,omitempty"`
	// PatioException: Patio exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PatioException string `json:"patioException,omitempty"`
	// Stairs: Stairs. There are steps leading from one level or story to another
	// in the unit.
	Stairs bool `json:"stairs,omitempty"`
	// StairsException: Stairs exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	StairsException string `json:"stairsException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Balcony") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Balcony") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LivingAreaLayout) MarshalJSON() ([]byte, error) {
	type NoMethod LivingAreaLayout
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *LivingAreaLayout) UnmarshalJSON(data []byte) error {
	type NoMethod LivingAreaLayout
	var s1 struct {
		LivingAreaSqMeters gensupport.JSONFloat64 `json:"livingAreaSqMeters"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.LivingAreaSqMeters = float64(s1.LivingAreaSqMeters)
	return nil
}

// LivingAreaSleeping: Information about sleeping features in the living area.
type LivingAreaSleeping struct {
	// BedsCount: Beds count. The number of permanent beds present in a guestroom.
	// Does not include rollaway beds, cribs or sofabeds.
	BedsCount int64 `json:"bedsCount,omitempty"`
	// BedsCountException: Beds count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BedsCountException string `json:"bedsCountException,omitempty"`
	// BunkBedsCount: Bunk beds count. The number of furniture pieces in which one
	// framed mattress is fixed directly above another by means of a physical
	// frame. This allows one person(s) to sleep in the bottom bunk and one
	// person(s) to sleep in the top bunk. Also known as double decker bed.
	BunkBedsCount int64 `json:"bunkBedsCount,omitempty"`
	// BunkBedsCountException: Bunk beds count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BunkBedsCountException string `json:"bunkBedsCountException,omitempty"`
	// CribsCount: Cribs count. The number of small beds for an infant or toddler
	// that the guestroom can obtain. The bed is surrounded by a high railing to
	// prevent the child from falling or climbing out of the bed
	CribsCount int64 `json:"cribsCount,omitempty"`
	// CribsCountException: Cribs count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CribsCountException string `json:"cribsCountException,omitempty"`
	// DoubleBedsCount: Double beds count. The number of medium beds measuring 53"W
	// x 75"L (135cm x 191cm). Also known as full size bed.
	DoubleBedsCount int64 `json:"doubleBedsCount,omitempty"`
	// DoubleBedsCountException: Double beds count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	DoubleBedsCountException string `json:"doubleBedsCountException,omitempty"`
	// FeatherPillows: Feather pillows. The option for guests to obtain bed pillows
	// that are stuffed with the feathers and down of ducks or geese.
	FeatherPillows bool `json:"featherPillows,omitempty"`
	// FeatherPillowsException: Feather pillows exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FeatherPillowsException string `json:"featherPillowsException,omitempty"`
	// HypoallergenicBedding: Hypoallergenic bedding. Bedding such as linens,
	// pillows, mattress covers and/or mattresses that are made of materials known
	// to be resistant to allergens such as mold, dust and dander.
	HypoallergenicBedding bool `json:"hypoallergenicBedding,omitempty"`
	// HypoallergenicBeddingException: Hypoallergenic bedding exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	HypoallergenicBeddingException string `json:"hypoallergenicBeddingException,omitempty"`
	// KingBedsCount: King beds count. The number of large beds measuring 76"W x
	// 80"L (193cm x 102cm). Most often meant to accompany two people. Includes
	// California king and super king.
	KingBedsCount int64 `json:"kingBedsCount,omitempty"`
	// KingBedsCountException: King beds count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	KingBedsCountException string `json:"kingBedsCountException,omitempty"`
	// MemoryFoamPillows: Memory foam pillows. The option for guests to obtain bed
	// pillows that are stuffed with a man-made foam that responds to body heat by
	// conforming to the body closely, and then recovers its shape when the pillow
	// cools down.
	MemoryFoamPillows bool `json:"memoryFoamPillows,omitempty"`
	// MemoryFoamPillowsException: Memory foam pillows exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MemoryFoamPillowsException string `json:"memoryFoamPillowsException,omitempty"`
	// OtherBedsCount: Other beds count. The number of beds that are not standard
	// mattress and boxspring setups such as Japanese tatami mats, trundle beds,
	// air mattresses and cots.
	OtherBedsCount int64 `json:"otherBedsCount,omitempty"`
	// OtherBedsCountException: Other beds count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	OtherBedsCountException string `json:"otherBedsCountException,omitempty"`
	// QueenBedsCount: Queen beds count. The number of medium-large beds measuring
	// 60"W x 80"L (152cm x 102cm).
	QueenBedsCount int64 `json:"queenBedsCount,omitempty"`
	// QueenBedsCountException: Queen beds count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	QueenBedsCountException string `json:"queenBedsCountException,omitempty"`
	// RollAwayBedsCount: Roll away beds count. The number of mattresses on wheeled
	// frames that can be folded in half and rolled away for easy storage that the
	// guestroom can obtain upon request.
	RollAwayBedsCount int64 `json:"rollAwayBedsCount,omitempty"`
	// RollAwayBedsCountException: Roll away beds count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	RollAwayBedsCountException string `json:"rollAwayBedsCountException,omitempty"`
	// SingleOrTwinBedsCount: Single or twin count beds. The number of smaller beds
	// measuring 38"W x 75"L (97cm x 191cm) that can accommodate one adult.
	SingleOrTwinBedsCount int64 `json:"singleOrTwinBedsCount,omitempty"`
	// SingleOrTwinBedsCountException: Single or twin beds count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SingleOrTwinBedsCountException string `json:"singleOrTwinBedsCountException,omitempty"`
	// SofaBedsCount: Sofa beds count. The number of specially designed sofas that
	// can be made to serve as a bed by lowering its hinged upholstered back to
	// horizontal position or by pulling out a concealed mattress.
	SofaBedsCount int64 `json:"sofaBedsCount,omitempty"`
	// SofaBedsCountException: Sofa beds count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SofaBedsCountException string `json:"sofaBedsCountException,omitempty"`
	// SyntheticPillows: Synthetic pillows. The option for guests to obtain bed
	// pillows stuffed with polyester material crafted to reproduce the feel of a
	// pillow stuffed with down and feathers.
	SyntheticPillows bool `json:"syntheticPillows,omitempty"`
	// SyntheticPillowsException: Synthetic pillows exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SyntheticPillowsException string `json:"syntheticPillowsException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BedsCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BedsCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LivingAreaSleeping) MarshalJSON() ([]byte, error) {
	type NoMethod LivingAreaSleeping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Lodging: Lodging of a location that provides accomodations.
type Lodging struct {
	// Accessibility: Physical adaptations made to the property in consideration of
	// varying levels of human physical ability.
	Accessibility *Accessibility `json:"accessibility,omitempty"`
	// Activities: Amenities and features related to leisure and play.
	Activities *Activities `json:"activities,omitempty"`
	// AllUnits: Output only. All units on the property have at least these
	// attributes.
	AllUnits *GuestUnitFeatures `json:"allUnits,omitempty"`
	// Business: Features of the property of specific interest to the business
	// traveler.
	Business *Business `json:"business,omitempty"`
	// CommonLivingArea: Features of the shared living areas available in this
	// Lodging.
	CommonLivingArea *LivingArea `json:"commonLivingArea,omitempty"`
	// Connectivity: The ways in which the property provides guests with the
	// ability to access the internet.
	Connectivity *Connectivity `json:"connectivity,omitempty"`
	// Families: Services and amenities for families and young guests.
	Families *Families `json:"families,omitempty"`
	// FoodAndDrink: Meals, snacks, and beverages available at the property.
	FoodAndDrink *FoodAndDrink `json:"foodAndDrink,omitempty"`
	// GuestUnits: Individual GuestUnitTypes that are available in this Lodging.
	GuestUnits []*GuestUnitType `json:"guestUnits,omitempty"`
	// HealthAndSafety: Health and safety measures implemented by the hotel during
	// COVID-19.
	HealthAndSafety *HealthAndSafety `json:"healthAndSafety,omitempty"`
	// Housekeeping: Conveniences provided in guest units to facilitate an easier,
	// more comfortable stay.
	Housekeeping *Housekeeping `json:"housekeeping,omitempty"`
	// Metadata: Required. Metadata for the lodging.
	Metadata *LodgingMetadata `json:"metadata,omitempty"`
	// Name: Required. Google identifier for this location in the form:
	// `locations/{location_id}/lodging`
	Name string `json:"name,omitempty"`
	// Parking: Parking options at the property.
	Parking *Parking `json:"parking,omitempty"`
	// Pets: Policies regarding guest-owned animals.
	Pets *Pets `json:"pets,omitempty"`
	// Policies: Property rules that impact guests.
	Policies *Policies `json:"policies,omitempty"`
	// Pools: Swimming pool or recreational water facilities available at the
	// hotel.
	Pools *Pools `json:"pools,omitempty"`
	// Property: General factual information about the property's physical
	// structure and important dates.
	Property *Property `json:"property,omitempty"`
	// Services: Conveniences or help provided by the property to facilitate an
	// easier, more comfortable stay.
	Services *Services `json:"services,omitempty"`
	// SomeUnits: Output only. Some units on the property have as much as these
	// attributes.
	SomeUnits *GuestUnitFeatures `json:"someUnits,omitempty"`
	// Sustainability: Sustainability practices implemented at the hotel.
	Sustainability *Sustainability `json:"sustainability,omitempty"`
	// Transportation: Vehicles or vehicular services facilitated or owned by the
	// property.
	Transportation *Transportation `json:"transportation,omitempty"`
	// Wellness: Guest facilities at the property to promote or maintain health,
	// beauty, and fitness.
	Wellness *Wellness `json:"wellness,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Accessibility") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accessibility") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Lodging) MarshalJSON() ([]byte, error) {
	type NoMethod Lodging
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LodgingMetadata: Metadata for the Lodging.
type LodgingMetadata struct {
	// UpdateTime: Required. The latest time at which the Lodging data is asserted
	// to be true in the real world. This is not necessarily the time at which the
	// request is made.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UpdateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UpdateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LodgingMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod LodgingMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MinimizedContact: Minimized contact measures implemented by the hotel during
// COVID-19.
type MinimizedContact struct {
	// ContactlessCheckinCheckout: No-contact check-in and check-out.
	ContactlessCheckinCheckout bool `json:"contactlessCheckinCheckout,omitempty"`
	// ContactlessCheckinCheckoutException: Contactless check-in check-out
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ContactlessCheckinCheckoutException string `json:"contactlessCheckinCheckoutException,omitempty"`
	// DigitalGuestRoomKeys: Keyless mobile entry to guest rooms.
	DigitalGuestRoomKeys bool `json:"digitalGuestRoomKeys,omitempty"`
	// DigitalGuestRoomKeysException: Digital guest room keys exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	DigitalGuestRoomKeysException string `json:"digitalGuestRoomKeysException,omitempty"`
	// HousekeepingScheduledRequestOnly: Housekeeping scheduled by request only.
	HousekeepingScheduledRequestOnly bool `json:"housekeepingScheduledRequestOnly,omitempty"`
	// HousekeepingScheduledRequestOnlyException: Housekeeping scheduled request
	// only exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	HousekeepingScheduledRequestOnlyException string `json:"housekeepingScheduledRequestOnlyException,omitempty"`
	// NoHighTouchItemsCommonAreas: High-touch items, such as magazines, removed
	// from common areas.
	NoHighTouchItemsCommonAreas bool `json:"noHighTouchItemsCommonAreas,omitempty"`
	// NoHighTouchItemsCommonAreasException: No high touch items common areas
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	NoHighTouchItemsCommonAreasException string `json:"noHighTouchItemsCommonAreasException,omitempty"`
	// NoHighTouchItemsGuestRooms: High-touch items, such as decorative pillows,
	// removed from guest rooms.
	NoHighTouchItemsGuestRooms bool `json:"noHighTouchItemsGuestRooms,omitempty"`
	// NoHighTouchItemsGuestRoomsException: No high touch items guest rooms
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	NoHighTouchItemsGuestRoomsException string `json:"noHighTouchItemsGuestRoomsException,omitempty"`
	// PlasticKeycardsDisinfected: Plastic key cards are disinfected or discarded.
	PlasticKeycardsDisinfected bool `json:"plasticKeycardsDisinfected,omitempty"`
	// PlasticKeycardsDisinfectedException: Plastic keycards disinfected exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PlasticKeycardsDisinfectedException string `json:"plasticKeycardsDisinfectedException,omitempty"`
	// RoomBookingsBuffer: Buffer maintained between room bookings.
	RoomBookingsBuffer bool `json:"roomBookingsBuffer,omitempty"`
	// RoomBookingsBufferException: Room bookings buffer exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	RoomBookingsBufferException string `json:"roomBookingsBufferException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContactlessCheckinCheckout")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContactlessCheckinCheckout") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MinimizedContact) MarshalJSON() ([]byte, error) {
	type NoMethod MinimizedContact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Parking: Parking options at the property.
type Parking struct {
	// ElectricCarChargingStations: Electric car charging stations. Electric power
	// stations, usually located outdoors, into which guests plug their electric
	// cars to receive a charge.
	ElectricCarChargingStations bool `json:"electricCarChargingStations,omitempty"`
	// ElectricCarChargingStationsException: Electric car charging stations
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ElectricCarChargingStationsException string `json:"electricCarChargingStationsException,omitempty"`
	// FreeParking: Free parking. The hotel allows the cars of guests to be parked
	// for free. Parking facility may be an outdoor lot or an indoor garage, but
	// must be onsite. Nearby parking does not apply. Parking may be performed by
	// the guest or by hotel staff. Free parking must be available to all guests
	// (limited conditions does not apply).
	FreeParking bool `json:"freeParking,omitempty"`
	// FreeParkingException: Free parking exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FreeParkingException string `json:"freeParkingException,omitempty"`
	// FreeSelfParking: Free self parking. Guests park their own cars for free.
	// Parking facility may be an outdoor lot or an indoor garage, but must be
	// onsite. Nearby parking does not apply.
	FreeSelfParking bool `json:"freeSelfParking,omitempty"`
	// FreeSelfParkingException: Free self parking exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FreeSelfParkingException string `json:"freeSelfParkingException,omitempty"`
	// FreeValetParking: Free valet parking. Hotel staff member parks the cars of
	// guests. Parking with this service is free.
	FreeValetParking bool `json:"freeValetParking,omitempty"`
	// FreeValetParkingException: Free valet parking exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FreeValetParkingException string `json:"freeValetParkingException,omitempty"`
	// ParkingAvailable: Parking available. The hotel allows the cars of guests to
	// be parked. Can be free or for a fee. Parking facility may be an outdoor lot
	// or an indoor garage, but must be onsite. Nearby parking does not apply.
	// Parking may be performed by the guest or by hotel staff.
	ParkingAvailable bool `json:"parkingAvailable,omitempty"`
	// ParkingAvailableException: Parking available exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ParkingAvailableException string `json:"parkingAvailableException,omitempty"`
	// SelfParkingAvailable: Self parking available. Guests park their own cars.
	// Parking facility may be an outdoor lot or an indoor garage, but must be
	// onsite. Nearby parking does not apply. Can be free or for a fee.
	SelfParkingAvailable bool `json:"selfParkingAvailable,omitempty"`
	// SelfParkingAvailableException: Self parking available exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SelfParkingAvailableException string `json:"selfParkingAvailableException,omitempty"`
	// ValetParkingAvailable: Valet parking available. Hotel staff member parks the
	// cars of guests. Parking with this service can be free or for a fee.
	ValetParkingAvailable bool `json:"valetParkingAvailable,omitempty"`
	// ValetParkingAvailableException: Valet parking available exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ValetParkingAvailableException string `json:"valetParkingAvailableException,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ElectricCarChargingStations") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ElectricCarChargingStations") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Parking) MarshalJSON() ([]byte, error) {
	type NoMethod Parking
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PaymentOptions: Forms of payment accepted at the property.
type PaymentOptions struct {
	// Cash: Cash. The hotel accepts payment by paper/coin currency.
	Cash bool `json:"cash,omitempty"`
	// CashException: Cash exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CashException string `json:"cashException,omitempty"`
	// Cheque: Cheque. The hotel accepts a printed document issued by the guest's
	// bank in the guest's name as a form of payment.
	Cheque bool `json:"cheque,omitempty"`
	// ChequeException: Cheque exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ChequeException string `json:"chequeException,omitempty"`
	// CreditCard: Credit card. The hotel accepts payment by a card issued by a
	// bank or credit card company. Also known as charge card, debit card, bank
	// card, or charge plate.
	CreditCard bool `json:"creditCard,omitempty"`
	// CreditCardException: Credit card exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CreditCardException string `json:"creditCardException,omitempty"`
	// DebitCard: Debit card. The hotel accepts a bank-issued card that immediately
	// deducts the charged funds from the guest's bank account upon processing.
	DebitCard bool `json:"debitCard,omitempty"`
	// DebitCardException: Debit card exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	DebitCardException string `json:"debitCardException,omitempty"`
	// MobileNfc: Mobile nfc. The hotel has the compatible computer hardware
	// terminal that reads and charges a payment app on the guest's smartphone
	// without requiring the two devices to make physical contact. Also known as
	// Apple Pay, Google Pay, Samsung Pay.
	MobileNfc bool `json:"mobileNfc,omitempty"`
	// MobileNfcException: Mobile nfc exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MobileNfcException string `json:"mobileNfcException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cash") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cash") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PaymentOptions) MarshalJSON() ([]byte, error) {
	type NoMethod PaymentOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PersonalProtection: Personal protection measures implemented by the hotel
// during COVID-19.
type PersonalProtection struct {
	// CommonAreasOfferSanitizingItems: Hand-sanitizer and/or sanitizing wipes are
	// offered in common areas.
	CommonAreasOfferSanitizingItems bool `json:"commonAreasOfferSanitizingItems,omitempty"`
	// CommonAreasOfferSanitizingItemsException: Common areas offer sanitizing
	// items exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CommonAreasOfferSanitizingItemsException string `json:"commonAreasOfferSanitizingItemsException,omitempty"`
	// FaceMaskRequired: Masks required on the property.
	FaceMaskRequired bool `json:"faceMaskRequired,omitempty"`
	// FaceMaskRequiredException: Face mask required exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FaceMaskRequiredException string `json:"faceMaskRequiredException,omitempty"`
	// GuestRoomHygieneKitsAvailable: In-room hygiene kits with masks, hand
	// sanitizer, and/or antibacterial wipes.
	GuestRoomHygieneKitsAvailable bool `json:"guestRoomHygieneKitsAvailable,omitempty"`
	// GuestRoomHygieneKitsAvailableException: Guest room hygiene kits available
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	GuestRoomHygieneKitsAvailableException string `json:"guestRoomHygieneKitsAvailableException,omitempty"`
	// ProtectiveEquipmentAvailable: Masks and/or gloves available for guests.
	ProtectiveEquipmentAvailable bool `json:"protectiveEquipmentAvailable,omitempty"`
	// ProtectiveEquipmentAvailableException: Protective equipment available
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ProtectiveEquipmentAvailableException string `json:"protectiveEquipmentAvailableException,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CommonAreasOfferSanitizingItems") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonAreasOfferSanitizingItems")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PersonalProtection) MarshalJSON() ([]byte, error) {
	type NoMethod PersonalProtection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Pets: Policies regarding guest-owned animals.
type Pets struct {
	// CatsAllowed: Cats allowed. Domesticated felines are permitted at the
	// property and allowed to stay in the guest room of their owner. May or may
	// not require a fee.
	CatsAllowed bool `json:"catsAllowed,omitempty"`
	// CatsAllowedException: Cats allowed exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CatsAllowedException string `json:"catsAllowedException,omitempty"`
	// DogsAllowed: Dogs allowed. Domesticated canines are permitted at the
	// property and allowed to stay in the guest room of their owner. May or may
	// not require a fee.
	DogsAllowed bool `json:"dogsAllowed,omitempty"`
	// DogsAllowedException: Dogs allowed exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	DogsAllowedException string `json:"dogsAllowedException,omitempty"`
	// PetsAllowed: Pets allowed. Household animals are allowed at the property and
	// in the specific guest room of their owner. May or may not include dogs,
	// cats, reptiles and/or fish. May or may not require a fee. Service animals
	// are not considered to be pets, so not governed by this policy.
	PetsAllowed bool `json:"petsAllowed,omitempty"`
	// PetsAllowedException: Pets allowed exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PetsAllowedException string `json:"petsAllowedException,omitempty"`
	// PetsAllowedFree: Pets allowed free. Household animals are allowed at the
	// property and in the specific guest room of their owner for free. May or may
	// not include dogs, cats, reptiles, and/or fish.
	PetsAllowedFree bool `json:"petsAllowedFree,omitempty"`
	// PetsAllowedFreeException: Pets allowed free exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PetsAllowedFreeException string `json:"petsAllowedFreeException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CatsAllowed") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CatsAllowed") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Pets) MarshalJSON() ([]byte, error) {
	type NoMethod Pets
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PhysicalDistancing: Physical distancing measures implemented by the hotel
// during COVID-19.
type PhysicalDistancing struct {
	// CommonAreasPhysicalDistancingArranged: Common areas arranged to maintain
	// physical distancing.
	CommonAreasPhysicalDistancingArranged bool `json:"commonAreasPhysicalDistancingArranged,omitempty"`
	// CommonAreasPhysicalDistancingArrangedException: Common areas physical
	// distancing arranged exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CommonAreasPhysicalDistancingArrangedException string `json:"commonAreasPhysicalDistancingArrangedException,omitempty"`
	// PhysicalDistancingRequired: Physical distancing required.
	PhysicalDistancingRequired bool `json:"physicalDistancingRequired,omitempty"`
	// PhysicalDistancingRequiredException: Physical distancing required exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PhysicalDistancingRequiredException string `json:"physicalDistancingRequiredException,omitempty"`
	// SafetyDividers: Safety dividers at front desk and other locations.
	SafetyDividers bool `json:"safetyDividers,omitempty"`
	// SafetyDividersException: Safety dividers exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SafetyDividersException string `json:"safetyDividersException,omitempty"`
	// SharedAreasLimitedOccupancy: Guest occupancy limited within shared
	// facilities.
	SharedAreasLimitedOccupancy bool `json:"sharedAreasLimitedOccupancy,omitempty"`
	// SharedAreasLimitedOccupancyException: Shared areas limited occupancy
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SharedAreasLimitedOccupancyException string `json:"sharedAreasLimitedOccupancyException,omitempty"`
	// WellnessAreasHavePrivateSpaces: Private spaces designated in spa and
	// wellness areas.
	WellnessAreasHavePrivateSpaces bool `json:"wellnessAreasHavePrivateSpaces,omitempty"`
	// WellnessAreasHavePrivateSpacesException: Wellness areas have private spaces
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WellnessAreasHavePrivateSpacesException string `json:"wellnessAreasHavePrivateSpacesException,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CommonAreasPhysicalDistancingArranged") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "CommonAreasPhysicalDistancingArranged") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s PhysicalDistancing) MarshalJSON() ([]byte, error) {
	type NoMethod PhysicalDistancing
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policies: Property rules that impact guests.
type Policies struct {
	// AllInclusiveAvailable: All inclusive available. The hotel offers a rate
	// option that includes the cost of the room, meals, activities, and other
	// amenities that might otherwise be charged separately.
	AllInclusiveAvailable bool `json:"allInclusiveAvailable,omitempty"`
	// AllInclusiveAvailableException: All inclusive available exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	AllInclusiveAvailableException string `json:"allInclusiveAvailableException,omitempty"`
	// AllInclusiveOnly: All inclusive only. The only rate option offered by the
	// hotel is a rate that includes the cost of the room, meals, activities and
	// other amenities that might otherwise be charged separately.
	AllInclusiveOnly bool `json:"allInclusiveOnly,omitempty"`
	// AllInclusiveOnlyException: All inclusive only exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	AllInclusiveOnlyException string `json:"allInclusiveOnlyException,omitempty"`
	// CheckinTime: Check-in time. The time of the day at which the hotel begins
	// providing guests access to their unit at the beginning of their stay.
	CheckinTime *TimeOfDay `json:"checkinTime,omitempty"`
	// CheckinTimeException: Check-in time exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CheckinTimeException string `json:"checkinTimeException,omitempty"`
	// CheckoutTime: Check-out time. The time of the day on the last day of a
	// guest's reserved stay at which the guest must vacate their room and settle
	// their bill. Some hotels may offer late or early check out for a fee.
	CheckoutTime *TimeOfDay `json:"checkoutTime,omitempty"`
	// CheckoutTimeException: Check-out time exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CheckoutTimeException string `json:"checkoutTimeException,omitempty"`
	// KidsStayFree: Kids stay free. The children of guests are allowed to stay in
	// the room/suite of a parent or adult without an additional fee. The policy
	// may or may not stipulate a limit of the child's age or the overall number of
	// children allowed.
	KidsStayFree bool `json:"kidsStayFree,omitempty"`
	// KidsStayFreeException: Kids stay free exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	KidsStayFreeException string `json:"kidsStayFreeException,omitempty"`
	// MaxChildAge: Max child age. The hotel allows children up to a certain age to
	// stay in the room/suite of a parent or adult without an additional fee.
	MaxChildAge int64 `json:"maxChildAge,omitempty"`
	// MaxChildAgeException: Max child age exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MaxChildAgeException string `json:"maxChildAgeException,omitempty"`
	// MaxKidsStayFreeCount: Max kids stay free count. The hotel allows a specific,
	// defined number of children to stay in the room/suite of a parent or adult
	// without an additional fee.
	MaxKidsStayFreeCount int64 `json:"maxKidsStayFreeCount,omitempty"`
	// MaxKidsStayFreeCountException: Max kids stay free count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MaxKidsStayFreeCountException string `json:"maxKidsStayFreeCountException,omitempty"`
	// PaymentOptions: Forms of payment accepted at the property.
	PaymentOptions *PaymentOptions `json:"paymentOptions,omitempty"`
	// SmokeFreeProperty: Smoke free property. Smoking is not allowed inside the
	// building, on balconies, or in outside spaces. Hotels that offer a designated
	// area for guests to smoke are not considered smoke-free properties.
	SmokeFreeProperty bool `json:"smokeFreeProperty,omitempty"`
	// SmokeFreePropertyException: Smoke free property exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SmokeFreePropertyException string `json:"smokeFreePropertyException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllInclusiveAvailable") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllInclusiveAvailable") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policies) MarshalJSON() ([]byte, error) {
	type NoMethod Policies
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Pools: Swimming pool or recreational water facilities available at the
// hotel.
type Pools struct {
	// AdultPool: Adult pool. A pool restricted for use by adults only. Can be
	// indoors or outdoors.
	AdultPool bool `json:"adultPool,omitempty"`
	// AdultPoolException: Adult pool exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	AdultPoolException string `json:"adultPoolException,omitempty"`
	// HotTub: Hot tub. A man-made pool containing bubbling water maintained at a
	// higher temperature and circulated by aerating jets for the purpose of
	// soaking, relaxation and hydrotherapy. Can be indoors or outdoors. Not used
	// for active swimming. Also known as Jacuzzi. Hot tub must be in a common area
	// where all guests can access it. Does not apply to room-specific hot tubs
	// that are only accessible to guest occupying that room.
	HotTub bool `json:"hotTub,omitempty"`
	// HotTubException: Hot tub exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	HotTubException string `json:"hotTubException,omitempty"`
	// IndoorPool: Indoor pool. A pool located inside the hotel and available for
	// guests to use for swimming and/or soaking. Use may or may not be restricted
	// to adults and/or children.
	IndoorPool bool `json:"indoorPool,omitempty"`
	// IndoorPoolException: Indoor pool exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	IndoorPoolException string `json:"indoorPoolException,omitempty"`
	// IndoorPoolsCount: Indoor pools count. The sum of all indoor pools at the
	// hotel.
	IndoorPoolsCount int64 `json:"indoorPoolsCount,omitempty"`
	// IndoorPoolsCountException: Indoor pools count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	IndoorPoolsCountException string `json:"indoorPoolsCountException,omitempty"`
	// LazyRiver: Lazy river. A man-made pool or several interconnected
	// recreational pools built to mimic the shape and current of a winding river
	// where guests float in the water on inflated rubber tubes. Can be indoors or
	// outdoors.
	LazyRiver bool `json:"lazyRiver,omitempty"`
	// LazyRiverException: Lazy river exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	LazyRiverException string `json:"lazyRiverException,omitempty"`
	// Lifeguard: Lifeguard. A trained member of the hotel staff stationed by the
	// hotel's indoor or outdoor swimming area and responsible for the safety of
	// swimming guests.
	Lifeguard bool `json:"lifeguard,omitempty"`
	// LifeguardException: Lifeguard exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	LifeguardException string `json:"lifeguardException,omitempty"`
	// OutdoorPool: Outdoor pool. A pool located outside on the grounds of the
	// hotel and available for guests to use for swimming, soaking or recreation.
	// Use may or may not be restricted to adults and/or children.
	OutdoorPool bool `json:"outdoorPool,omitempty"`
	// OutdoorPoolException: Outdoor pool exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	OutdoorPoolException string `json:"outdoorPoolException,omitempty"`
	// OutdoorPoolsCount: Outdoor pools count. The sum of all outdoor pools at the
	// hotel.
	OutdoorPoolsCount int64 `json:"outdoorPoolsCount,omitempty"`
	// OutdoorPoolsCountException: Outdoor pools count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	OutdoorPoolsCountException string `json:"outdoorPoolsCountException,omitempty"`
	// Pool: Pool. The presence of a pool, either indoors or outdoors, for guests
	// to use for swimming and/or soaking. Use may or may not be restricted to
	// adults and/or children.
	Pool bool `json:"pool,omitempty"`
	// PoolException: Pool exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PoolException string `json:"poolException,omitempty"`
	// PoolsCount: Pools count. The sum of all pools at the hotel.
	PoolsCount int64 `json:"poolsCount,omitempty"`
	// PoolsCountException: Pools count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PoolsCountException string `json:"poolsCountException,omitempty"`
	// WadingPool: Wading pool. A shallow pool designed for small children to play
	// in. Can be indoors or outdoors. Also known as kiddie pool.
	WadingPool bool `json:"wadingPool,omitempty"`
	// WadingPoolException: Wading pool exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WadingPoolException string `json:"wadingPoolException,omitempty"`
	// WaterPark: Water park. An aquatic recreation area with a large pool or
	// series of pools that has features such as a water slide or tube, wavepool,
	// fountains, rope swings, and/or obstacle course. Can be indoors or outdoors.
	// Also known as adventure pool.
	WaterPark bool `json:"waterPark,omitempty"`
	// WaterParkException: Water park exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WaterParkException string `json:"waterParkException,omitempty"`
	// Waterslide: Waterslide. A continuously wetted chute positioned by an indoor
	// or outdoor pool which people slide down into the water.
	Waterslide bool `json:"waterslide,omitempty"`
	// WaterslideException: Waterslide exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WaterslideException string `json:"waterslideException,omitempty"`
	// WavePool: Wave pool. A large indoor or outdoor pool with a machine that
	// produces water currents to mimic the ocean's crests.
	WavePool bool `json:"wavePool,omitempty"`
	// WavePoolException: Wave pool exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WavePoolException string `json:"wavePoolException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdultPool") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdultPool") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Pools) MarshalJSON() ([]byte, error) {
	type NoMethod Pools
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Property: General factual information about the property's physical
// structure and important dates.
type Property struct {
	// BuiltYear: Built year. The year that construction of the property was
	// completed.
	BuiltYear int64 `json:"builtYear,omitempty"`
	// BuiltYearException: Built year exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BuiltYearException string `json:"builtYearException,omitempty"`
	// FloorsCount: Floors count. The number of stories the building has from the
	// ground floor to the top floor that are accessible to guests.
	FloorsCount int64 `json:"floorsCount,omitempty"`
	// FloorsCountException: Floors count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FloorsCountException string `json:"floorsCountException,omitempty"`
	// LastRenovatedYear: Last renovated year. The year when the most recent
	// renovation of the property was completed. Renovation may include all or any
	// combination of the following: the units, the public spaces, the exterior, or
	// the interior.
	LastRenovatedYear int64 `json:"lastRenovatedYear,omitempty"`
	// LastRenovatedYearException: Last renovated year exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	LastRenovatedYearException string `json:"lastRenovatedYearException,omitempty"`
	// RoomsCount: Rooms count. The total number of rooms and suites bookable by
	// guests for an overnight stay. Does not include event space, public spaces,
	// conference rooms, fitness rooms, business centers, spa, salon,
	// restaurants/bars, or shops.
	RoomsCount int64 `json:"roomsCount,omitempty"`
	// RoomsCountException: Rooms count exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	RoomsCountException string `json:"roomsCountException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuiltYear") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuiltYear") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Property) MarshalJSON() ([]byte, error) {
	type NoMethod Property
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Services: Conveniences or help provided by the property to facilitate an
// easier, more comfortable stay.
type Services struct {
	// BaggageStorage: Baggage storage. A provision for guests to leave their bags
	// at the hotel when they arrive for their stay before the official check-in
	// time. May or may not apply for guests who wish to leave their bags after
	// check-out and before departing the locale. Also known as bag dropoff.
	BaggageStorage bool `json:"baggageStorage,omitempty"`
	// BaggageStorageException: Baggage storage exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BaggageStorageException string `json:"baggageStorageException,omitempty"`
	// Concierge: Concierge. Hotel staff member(s) responsible for facilitating an
	// easy, comfortable stay through making reservations for meals, sourcing
	// theater tickets, arranging tours, finding a doctor, making recommendations,
	// and answering questions.
	Concierge bool `json:"concierge,omitempty"`
	// ConciergeException: Concierge exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ConciergeException string `json:"conciergeException,omitempty"`
	// ConvenienceStore: Convenience store. A shop at the hotel primarily selling
	// snacks, drinks, non-prescription medicines, health and beauty aids,
	// magazines and newspapers.
	ConvenienceStore bool `json:"convenienceStore,omitempty"`
	// ConvenienceStoreException: Convenience store exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ConvenienceStoreException string `json:"convenienceStoreException,omitempty"`
	// CurrencyExchange: Currency exchange. A staff member or automated machine
	// tasked with the transaction of providing the native currency of the hotel's
	// locale in exchange for the foreign currency provided by a guest.
	CurrencyExchange bool `json:"currencyExchange,omitempty"`
	// CurrencyExchangeException: Currency exchange exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CurrencyExchangeException string `json:"currencyExchangeException,omitempty"`
	// Elevator: Elevator. A passenger elevator that transports guests from one
	// story to another. Also known as lift.
	Elevator bool `json:"elevator,omitempty"`
	// ElevatorException: Elevator exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ElevatorException string `json:"elevatorException,omitempty"`
	// FrontDesk: Front desk. A counter or desk in the lobby or the immediate
	// interior of the hotel where a member of the staff greets guests and
	// processes the information related to their stay (including check-in and
	// check-out). May or may not be manned and open 24/7.
	FrontDesk bool `json:"frontDesk,omitempty"`
	// FrontDeskException: Front desk exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FrontDeskException string `json:"frontDeskException,omitempty"`
	// FullServiceLaundry: Full service laundry. Laundry and dry cleaning
	// facilitated and handled by the hotel on behalf of the guest. Does not
	// include the provision for guests to do their own laundry in on-site
	// machines.
	FullServiceLaundry bool `json:"fullServiceLaundry,omitempty"`
	// FullServiceLaundryException: Full service laundry exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FullServiceLaundryException string `json:"fullServiceLaundryException,omitempty"`
	// GiftShop: Gift shop. An on-site store primarily selling souvenirs, mementos
	// and other gift items. May or may not also sell sundries, magazines and
	// newspapers, clothing, or snacks.
	GiftShop bool `json:"giftShop,omitempty"`
	// GiftShopException: Gift shop exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	GiftShopException string `json:"giftShopException,omitempty"`
	// LanguagesSpoken: Languages spoken by at least one staff member.
	LanguagesSpoken []*LanguageSpoken `json:"languagesSpoken,omitempty"`
	// SelfServiceLaundry: Self service laundry. On-site clothes washers and dryers
	// accessible to guests for the purpose of washing and drying their own
	// clothes. May or may not require payment to use the machines.
	SelfServiceLaundry bool `json:"selfServiceLaundry,omitempty"`
	// SelfServiceLaundryException: Self service laundry exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SelfServiceLaundryException string `json:"selfServiceLaundryException,omitempty"`
	// SocialHour: Social hour. A reception with complimentary soft drinks, tea,
	// coffee, wine and/or cocktails in the afternoon or evening. Can be hosted by
	// hotel staff or guests may serve themselves. Also known as wine hour. The
	// availability of coffee/tea in the lobby throughout the day does not
	// constitute a social or wine hour.
	SocialHour bool `json:"socialHour,omitempty"`
	// SocialHourException: Social hour exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SocialHourException string `json:"socialHourException,omitempty"`
	// TwentyFourHourFrontDesk: 24hr front desk. Front desk is staffed 24 hours a
	// day.
	TwentyFourHourFrontDesk bool `json:"twentyFourHourFrontDesk,omitempty"`
	// TwentyFourHourFrontDeskException: 24hr front desk exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TwentyFourHourFrontDeskException string `json:"twentyFourHourFrontDeskException,omitempty"`
	// WakeUpCalls: Wake up calls. By direction of the guest, a hotel staff member
	// will phone the guest unit at the requested hour. Also known as morning call.
	WakeUpCalls bool `json:"wakeUpCalls,omitempty"`
	// WakeUpCallsException: Wake up calls exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WakeUpCallsException string `json:"wakeUpCallsException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaggageStorage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaggageStorage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Services) MarshalJSON() ([]byte, error) {
	type NoMethod Services
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Sustainability: Sustainability practices implemented at the hotel.
type Sustainability struct {
	// EnergyEfficiency: Energy efficiency practices implemented at the hotel.
	EnergyEfficiency *EnergyEfficiency `json:"energyEfficiency,omitempty"`
	// SustainabilityCertifications: Sustainability certifications the hotel has
	// been awarded. Deprecated: this field is no longer populated. All
	// certification data is now provided by BeCause.
	SustainabilityCertifications *SustainabilityCertifications `json:"sustainabilityCertifications,omitempty"`
	// SustainableSourcing: Sustainable sourcing practices implemented at the
	// hotel.
	SustainableSourcing *SustainableSourcing `json:"sustainableSourcing,omitempty"`
	// WasteReduction: Waste reduction practices implemented at the hotel.
	WasteReduction *WasteReduction `json:"wasteReduction,omitempty"`
	// WaterConservation: Water conservation practices implemented at the hotel.
	WaterConservation *WaterConservation `json:"waterConservation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnergyEfficiency") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnergyEfficiency") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Sustainability) MarshalJSON() ([]byte, error) {
	type NoMethod Sustainability
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SustainabilityCertifications: Sustainability certifications the hotel has
// been awarded. Deprecated: this message is no longer populated. All
// certification data is now provided by BeCause.
type SustainabilityCertifications struct {
	// BreeamCertification: BREEAM certification.
	//
	// Possible values:
	//   "BREEAM_CERTIFICATION_UNSPECIFIED" - Default BreeamCertification. Do not
	// use.
	//   "NO_BREEAM_CERTIFICATION" - Not certified.
	//   "BREEAM_PASS" - BREEAM Pass.
	//   "BREEAM_GOOD" - BREEAM Good.
	//   "BREEAM_VERY_GOOD" - BREEAM Very Good.
	//   "BREEAM_EXCELLENT" - BREEAM Excellent.
	//   "BREEAM_OUTSTANDING" - BREEAM Outstanding.
	BreeamCertification string `json:"breeamCertification,omitempty"`
	// BreeamCertificationException: BREEAM certification exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BreeamCertificationException string `json:"breeamCertificationException,omitempty"`
	// EcoCertifications: The eco certificates awarded to the hotel.
	EcoCertifications []*EcoCertification `json:"ecoCertifications,omitempty"`
	// LeedCertification: LEED certification.
	//
	// Possible values:
	//   "LEED_CERTIFICATION_UNSPECIFIED" - Default LeedCertification. Do not use.
	//   "NO_LEED_CERTIFICATION" - Not certified.
	//   "LEED_CERTIFIED" - LEED Certified.
	//   "LEED_SILVER" - LEED Silver.
	//   "LEED_GOLD" - LEED Gold.
	//   "LEED_PLATINUM" - LEED Platinum.
	LeedCertification string `json:"leedCertification,omitempty"`
	// LeedCertificationException: LEED certification exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	LeedCertificationException string `json:"leedCertificationException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BreeamCertification") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BreeamCertification") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SustainabilityCertifications) MarshalJSON() ([]byte, error) {
	type NoMethod SustainabilityCertifications
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SustainableSourcing: Sustainable sourcing practices implemented at the
// hotel.
type SustainableSourcing struct {
	// EcoFriendlyToiletries: Eco friendly toiletries. Soap, shampoo, lotion, and
	// other toiletries provided for guests have a nationally or internationally
	// recognized sustainability certification, such as USDA Organic, EU Organic,
	// or cruelty-free.
	EcoFriendlyToiletries bool `json:"ecoFriendlyToiletries,omitempty"`
	// EcoFriendlyToiletriesException: Eco friendly toiletries exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	EcoFriendlyToiletriesException string `json:"ecoFriendlyToiletriesException,omitempty"`
	// LocallySourcedFoodAndBeverages: Locally sourced food and beverages. Property
	// sources locally in order to lower the environmental footprint from reduced
	// transportation and to stimulate the local economy. Products produced less
	// than 62 miles from the establishment are normally considered as locally
	// produced.
	LocallySourcedFoodAndBeverages bool `json:"locallySourcedFoodAndBeverages,omitempty"`
	// LocallySourcedFoodAndBeveragesException: Locally sourced food and beverages
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	LocallySourcedFoodAndBeveragesException string `json:"locallySourcedFoodAndBeveragesException,omitempty"`
	// OrganicCageFreeEggs: Organic cage free eggs. The property sources 100%
	// certified organic and cage-free eggs (shell, liquid, and egg products).
	// Cage-free means hens are able to walk, spread their wings and lay their eggs
	// in nests).
	OrganicCageFreeEggs bool `json:"organicCageFreeEggs,omitempty"`
	// OrganicCageFreeEggsException: Organic cage free eggs exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	OrganicCageFreeEggsException string `json:"organicCageFreeEggsException,omitempty"`
	// OrganicFoodAndBeverages: Organic food and beverages. At least 25% of food
	// and beverages, by spend, are certified organic. Organic means products that
	// are certified to one of the organic standard listed in the IFOAM family of
	// standards. Qualifying certifications include USDA Organic and EU Organic,
	// among others.
	OrganicFoodAndBeverages bool `json:"organicFoodAndBeverages,omitempty"`
	// OrganicFoodAndBeveragesException: Organic food and beverages exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	OrganicFoodAndBeveragesException string `json:"organicFoodAndBeveragesException,omitempty"`
	// ResponsiblePurchasingPolicy: Responsible purchasing policy. The property has
	// a responsible procurement policy in place. Responsible means integration of
	// social, ethical, and/or environmental performance factors into the
	// procurement process when selecting suppliers.
	ResponsiblePurchasingPolicy bool `json:"responsiblePurchasingPolicy,omitempty"`
	// ResponsiblePurchasingPolicyException: Responsible purchasing policy
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ResponsiblePurchasingPolicyException string `json:"responsiblePurchasingPolicyException,omitempty"`
	// ResponsiblySourcesSeafood: Responsibly sources seafood. The property does
	// not source seafood from the Monterey Bay Aquarium Seafood Watch "avoid"
	// list, and must sustainably source seafood listed as "good alternative,"
	// "eco-certified," and "best choice". The property has a policy outlining a
	// commitment to source Marine Stewardship Council (MSC) and/or Aquaculture
	// Stewardship Council (ASC) Chain of Custody certified seafood.
	ResponsiblySourcesSeafood bool `json:"responsiblySourcesSeafood,omitempty"`
	// ResponsiblySourcesSeafoodException: Responsibly sources seafood exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ResponsiblySourcesSeafoodException string `json:"responsiblySourcesSeafoodException,omitempty"`
	// VeganMeals: Vegan meals. The property provides vegan menu options for
	// guests. Vegan food does not contain animal products or byproducts.
	VeganMeals bool `json:"veganMeals,omitempty"`
	// VeganMealsException: Vegan meals exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	VeganMealsException string `json:"veganMealsException,omitempty"`
	// VegetarianMeals: Vegetarian meals. The property provides vegetarian menu
	// options for guests. Vegetarian food does not contain meat, poultry, fish, or
	// seafood.
	VegetarianMeals bool `json:"vegetarianMeals,omitempty"`
	// VegetarianMealsException: Vegetarian meals exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	VegetarianMealsException string `json:"vegetarianMealsException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EcoFriendlyToiletries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EcoFriendlyToiletries") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SustainableSourcing) MarshalJSON() ([]byte, error) {
	type NoMethod SustainableSourcing
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeOfDay: Represents a time of day. The date and time zone are either not
// significant or are specified elsewhere. An API may choose to allow leap
// seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
type TimeOfDay struct {
	// Hours: Hours of a day in 24 hour format. Must be greater than or equal to 0
	// and typically must be less than or equal to 23. An API may choose to allow
	// the value "24:00:00" for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Minutes of an hour. Must be greater than or equal to 0 and less
	// than or equal to 59.
	Minutes int64 `json:"minutes,omitempty"`
	// Nanos: Fractions of seconds, in nanoseconds. Must be greater than or equal
	// to 0 and less than or equal to 999,999,999.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Seconds of a minute. Must be greater than or equal to 0 and
	// typically must be less than or equal to 59. An API may allow the value 60 if
	// it allows leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hours") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hours") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeOfDay) MarshalJSON() ([]byte, error) {
	type NoMethod TimeOfDay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Transportation: Vehicles or vehicular services facilitated or owned by the
// property.
type Transportation struct {
	// AirportShuttle: Airport shuttle. The hotel provides guests with a
	// chauffeured van or bus to and from the airport. Can be free or for a fee.
	// Guests may share the vehicle with other guests unknown to them. Applies if
	// the hotel has a third-party shuttle service (office/desk etc.) within the
	// hotel. As long as hotel provides this service, it doesn't matter if it's
	// directly with them or a third party they work with. Does not apply if guest
	// has to coordinate with an entity outside/other than the hotel.
	AirportShuttle bool `json:"airportShuttle,omitempty"`
	// AirportShuttleException: Airport shuttle exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	AirportShuttleException string `json:"airportShuttleException,omitempty"`
	// CarRentalOnProperty: Car rental on property. A branch of a rental car
	// company with a processing desk in the hotel. Available cars for rent may be
	// awaiting at the hotel or in a nearby lot.
	CarRentalOnProperty bool `json:"carRentalOnProperty,omitempty"`
	// CarRentalOnPropertyException: Car rental on property exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CarRentalOnPropertyException string `json:"carRentalOnPropertyException,omitempty"`
	// FreeAirportShuttle: Free airport shuttle. Airport shuttle is free to guests.
	// Must be free to all guests without any conditions.
	FreeAirportShuttle bool `json:"freeAirportShuttle,omitempty"`
	// FreeAirportShuttleException: Free airport shuttle exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FreeAirportShuttleException string `json:"freeAirportShuttleException,omitempty"`
	// FreePrivateCarService: Free private car service. Private chauffeured car
	// service is free to guests.
	FreePrivateCarService bool `json:"freePrivateCarService,omitempty"`
	// FreePrivateCarServiceException: Free private car service exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FreePrivateCarServiceException string `json:"freePrivateCarServiceException,omitempty"`
	// LocalShuttle: Local shuttle. A car, van or bus provided by the hotel to
	// transport guests to destinations within a specified range of distance around
	// the hotel. Usually shopping and/or convention centers, downtown districts,
	// or beaches. Can be free or for a fee.
	LocalShuttle bool `json:"localShuttle,omitempty"`
	// LocalShuttleException: Local shuttle exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	LocalShuttleException string `json:"localShuttleException,omitempty"`
	// PrivateCarService: Private car service. Hotel provides a private chauffeured
	// car to transport guests to destinations. Passengers in the car are either
	// alone or are known to one another and have requested the car together.
	// Service can be free or for a fee and travel distance is usually limited to a
	// specific range. Not a taxi.
	PrivateCarService bool `json:"privateCarService,omitempty"`
	// PrivateCarServiceException: Private car service exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PrivateCarServiceException string `json:"privateCarServiceException,omitempty"`
	// Transfer: Transfer. Hotel provides a shuttle service or car service to take
	// guests to and from the nearest airport or train station. Can be free or for
	// a fee. Guests may share the vehicle with other guests unknown to them.
	Transfer bool `json:"transfer,omitempty"`
	// TransferException: Transfer exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TransferException string `json:"transferException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AirportShuttle") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AirportShuttle") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Transportation) MarshalJSON() ([]byte, error) {
	type NoMethod Transportation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ViewsFromUnit: Views available from the guest unit itself.
type ViewsFromUnit struct {
	// BeachView: Beach view. A guestroom that features a window through which
	// guests can see the beach.
	BeachView bool `json:"beachView,omitempty"`
	// BeachViewException: Beach view exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	BeachViewException string `json:"beachViewException,omitempty"`
	// CityView: City view. A guestroom that features a window through which guests
	// can see the buildings, parks and/or streets of the city.
	CityView bool `json:"cityView,omitempty"`
	// CityViewException: City view exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CityViewException string `json:"cityViewException,omitempty"`
	// GardenView: Garden view. A guestroom that features a window through which
	// guests can see a garden.
	GardenView bool `json:"gardenView,omitempty"`
	// GardenViewException: Garden view exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	GardenViewException string `json:"gardenViewException,omitempty"`
	// LakeView: Lake view.
	LakeView bool `json:"lakeView,omitempty"`
	// LakeViewException: Lake view exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	LakeViewException string `json:"lakeViewException,omitempty"`
	// LandmarkView: Landmark view. A guestroom that features a window through
	// which guests can see a landmark such as the countryside, a golf course, the
	// forest, a park, a rain forst, a mountain or a slope.
	LandmarkView bool `json:"landmarkView,omitempty"`
	// LandmarkViewException: Landmark view exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	LandmarkViewException string `json:"landmarkViewException,omitempty"`
	// OceanView: Ocean view. A guestroom that features a window through which
	// guests can see the ocean.
	OceanView bool `json:"oceanView,omitempty"`
	// OceanViewException: Ocean view exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	OceanViewException string `json:"oceanViewException,omitempty"`
	// PoolView: Pool view. A guestroom that features a window through which guests
	// can see the hotel's swimming pool.
	PoolView bool `json:"poolView,omitempty"`
	// PoolViewException: Pool view exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	PoolViewException string `json:"poolViewException,omitempty"`
	// ValleyView: Valley view. A guestroom that features a window through which
	// guests can see over a valley.
	ValleyView bool `json:"valleyView,omitempty"`
	// ValleyViewException: Valley view exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ValleyViewException string `json:"valleyViewException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BeachView") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BeachView") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ViewsFromUnit) MarshalJSON() ([]byte, error) {
	type NoMethod ViewsFromUnit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WasteReduction: Waste reduction practices implemented at the hotel.
type WasteReduction struct {
	// CompostableFoodContainersAndCutlery: Compostable food containers and
	// cutlery. 100% of food service containers and to-go cutlery are compostable,
	// and reusable utensils are offered wherever possible. Compostable materials
	// are capable of undergoing biological decomposition in a compost site, such
	// that material is not visually distinguishable and breaks down into carbon
	// dioxide, water, inorganic compounds, and biomass.
	CompostableFoodContainersAndCutlery bool `json:"compostableFoodContainersAndCutlery,omitempty"`
	// CompostableFoodContainersAndCutleryException: Compostable food containers
	// and cutlery exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CompostableFoodContainersAndCutleryException string `json:"compostableFoodContainersAndCutleryException,omitempty"`
	// CompostsExcessFood: Composts excess food. The property has a program and/or
	// policy for diverting waste from landfill by composting food and yard waste,
	// either through compost collection and off-site processing or on-site compost
	// processing.
	CompostsExcessFood bool `json:"compostsExcessFood,omitempty"`
	// CompostsExcessFoodException: Composts excess food exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	CompostsExcessFoodException string `json:"compostsExcessFoodException,omitempty"`
	// DonatesExcessFood: Donates excess food. The property has a program and/or
	// policy for diverting waste from landfill that may include efforts to donate
	// for human consumption or divert food for animal feed.
	DonatesExcessFood bool `json:"donatesExcessFood,omitempty"`
	// DonatesExcessFoodException: Donates excess food exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	DonatesExcessFoodException string `json:"donatesExcessFoodException,omitempty"`
	// FoodWasteReductionProgram: Food waste reduction program. The property has
	// established a food waste reduction and donation program, aiming to reduce
	// food waste by half. These programs typically use tools such as the Hotel
	// Kitchen Toolkit and others to track waste and measure progress.
	FoodWasteReductionProgram bool `json:"foodWasteReductionProgram,omitempty"`
	// FoodWasteReductionProgramException: Food waste reduction program exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FoodWasteReductionProgramException string `json:"foodWasteReductionProgramException,omitempty"`
	// NoSingleUsePlasticStraws: No single use plastic straws. The property bans
	// single-use plastic straws.
	NoSingleUsePlasticStraws bool `json:"noSingleUsePlasticStraws,omitempty"`
	// NoSingleUsePlasticStrawsException: No single use plastic straws exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	NoSingleUsePlasticStrawsException string `json:"noSingleUsePlasticStrawsException,omitempty"`
	// NoSingleUsePlasticWaterBottles: No single use plastic water bottles. The
	// property bans single-use plastic water bottles.
	NoSingleUsePlasticWaterBottles bool `json:"noSingleUsePlasticWaterBottles,omitempty"`
	// NoSingleUsePlasticWaterBottlesException: No single use plastic water bottles
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	NoSingleUsePlasticWaterBottlesException string `json:"noSingleUsePlasticWaterBottlesException,omitempty"`
	// NoStyrofoamFoodContainers: No styrofoam food containers. The property
	// eliminates the use of Styrofoam in disposable food service items.
	NoStyrofoamFoodContainers bool `json:"noStyrofoamFoodContainers,omitempty"`
	// NoStyrofoamFoodContainersException: No styrofoam food containers exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	NoStyrofoamFoodContainersException string `json:"noStyrofoamFoodContainersException,omitempty"`
	// RecyclingProgram: Recycling program. The property has a recycling program,
	// aligned with LEED waste requirements, and a policy outlining efforts to send
	// less than 50% of waste to landfill. The recycling program includes storage
	// locations for recyclable materials, including mixed paper, corrugated
	// cardboard, glass, plastics, and metals.
	RecyclingProgram bool `json:"recyclingProgram,omitempty"`
	// RecyclingProgramException: Recycling program exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	RecyclingProgramException string `json:"recyclingProgramException,omitempty"`
	// RefillableToiletryContainers: Refillable toiletry containers. The property
	// has replaced miniature individual containers with refillable amenity
	// dispensers for shampoo, conditioner, soap, and lotion.
	RefillableToiletryContainers bool `json:"refillableToiletryContainers,omitempty"`
	// RefillableToiletryContainersException: Refillable toiletry containers
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	RefillableToiletryContainersException string `json:"refillableToiletryContainersException,omitempty"`
	// SafelyDisposesBatteries: Safely disposes batteries. The property safely
	// stores and disposes batteries.
	SafelyDisposesBatteries bool `json:"safelyDisposesBatteries,omitempty"`
	// SafelyDisposesBatteriesException: Safely disposes batteries exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SafelyDisposesBatteriesException string `json:"safelyDisposesBatteriesException,omitempty"`
	// SafelyDisposesElectronics: Safely disposes electronics. The property has a
	// reputable recycling program that keeps hazardous electronic parts and
	// chemical compounds out of landfills, dumps and other unauthorized
	// abandonment sites, and recycles/reuses applicable materials. (e.g. certified
	// electronics recyclers).
	SafelyDisposesElectronics bool `json:"safelyDisposesElectronics,omitempty"`
	// SafelyDisposesElectronicsException: Safely disposes electronics exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SafelyDisposesElectronicsException string `json:"safelyDisposesElectronicsException,omitempty"`
	// SafelyDisposesLightbulbs: Safely disposes lightbulbs. The property safely
	// stores and disposes lightbulbs.
	SafelyDisposesLightbulbs bool `json:"safelyDisposesLightbulbs,omitempty"`
	// SafelyDisposesLightbulbsException: Safely disposes lightbulbs exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SafelyDisposesLightbulbsException string `json:"safelyDisposesLightbulbsException,omitempty"`
	// SafelyHandlesHazardousSubstances: Safely handles hazardous substances. The
	// property has a hazardous waste management program aligned wit GreenSeal and
	// LEED requirements, and meets all regulatory requirements for hazardous waste
	// disposal and recycling. Hazardous means substances that are classified as
	// "hazardous" by an authoritative body (such as OSHA or DOT), are labeled with
	// signal words such as "Danger," "Caution," "Warning," or are flammable,
	// corrosive, or ignitable. Requirements include: - The property shall maintain
	// records of the efforts it has made to replace the hazardous substances it
	// uses with less hazardous alternatives. - An inventory of the hazardous
	// materials stored on-site. - Products intended for cleaning, dishwashing,
	// laundry, and pool maintenance shall be stored in clearly labeled containers.
	// These containers shall be checked regularly for leaks, and replaced a
	// necessary. - Spill containment devices shall be installed to collect spills,
	// drips, or leaching of chemicals.
	SafelyHandlesHazardousSubstances bool `json:"safelyHandlesHazardousSubstances,omitempty"`
	// SafelyHandlesHazardousSubstancesException: Safely handles hazardous
	// substances exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SafelyHandlesHazardousSubstancesException string `json:"safelyHandlesHazardousSubstancesException,omitempty"`
	// SoapDonationProgram: Soap donation program. The property participates in a
	// soap donation program such as Clean the World or something similar.
	SoapDonationProgram bool `json:"soapDonationProgram,omitempty"`
	// SoapDonationProgramException: Soap donation program exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SoapDonationProgramException string `json:"soapDonationProgramException,omitempty"`
	// ToiletryDonationProgram: Toiletry donation program. The property
	// participates in a toiletry donation program such as Clean the World or
	// something similar.
	ToiletryDonationProgram bool `json:"toiletryDonationProgram,omitempty"`
	// ToiletryDonationProgramException: Toiletry donation program exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	ToiletryDonationProgramException string `json:"toiletryDonationProgramException,omitempty"`
	// WaterBottleFillingStations: Water bottle filling stations. The property
	// offers water stations throughout the building for guest use.
	WaterBottleFillingStations bool `json:"waterBottleFillingStations,omitempty"`
	// WaterBottleFillingStationsException: Water bottle filling stations
	// exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WaterBottleFillingStationsException string `json:"waterBottleFillingStationsException,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CompostableFoodContainersAndCutlery") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "CompostableFoodContainersAndCutlery") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s WasteReduction) MarshalJSON() ([]byte, error) {
	type NoMethod WasteReduction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WaterConservation: Water conservation practices implemented at the hotel.
type WaterConservation struct {
	// IndependentOrganizationAuditsWaterUse: Independent organization audits water
	// use. The property conducts a water conservation audit every 5 years, the
	// results of which are either verified by a third-party and/or published in
	// external communications. A water conservation audit is a detailed assessment
	// of the facility, providing recommendations to existing operations and
	// procedures to improve water efficiency, available incentives or rebates, and
	// opportunities for improvements through renovations or upgrades. Examples of
	// organizations who conduct credible third party audits include: Engie Impact,
	// and local utility providers (they often provide energy and water audits).
	IndependentOrganizationAuditsWaterUse bool `json:"independentOrganizationAuditsWaterUse,omitempty"`
	// IndependentOrganizationAuditsWaterUseException: Independent organization
	// audits water use exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	IndependentOrganizationAuditsWaterUseException string `json:"independentOrganizationAuditsWaterUseException,omitempty"`
	// LinenReuseProgram: Linen reuse program. The property offers a linen reuse
	// program.
	LinenReuseProgram bool `json:"linenReuseProgram,omitempty"`
	// LinenReuseProgramException: Linen reuse program exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	LinenReuseProgramException string `json:"linenReuseProgramException,omitempty"`
	// TowelReuseProgram: Towel reuse program. The property offers a towel reuse
	// program.
	TowelReuseProgram bool `json:"towelReuseProgram,omitempty"`
	// TowelReuseProgramException: Towel reuse program exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TowelReuseProgramException string `json:"towelReuseProgramException,omitempty"`
	// WaterSavingShowers: Water saving showers. All of the property's guest rooms
	// have shower heads that use no more than 2.0 gallons per minute (gpm).
	WaterSavingShowers bool `json:"waterSavingShowers,omitempty"`
	// WaterSavingShowersException: Water saving showers exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WaterSavingShowersException string `json:"waterSavingShowersException,omitempty"`
	// WaterSavingSinks: Water saving sinks. All of the property's guest rooms have
	// bathroom faucets that use a maximum of 1.5 gallons per minute (gpm), public
	// restroom faucets do not exceed 0.5 gpm, and kitchen faucets (excluding
	// faucets used exclusively for filling operations) do not exceed 2.2 gpm.
	WaterSavingSinks bool `json:"waterSavingSinks,omitempty"`
	// WaterSavingSinksException: Water saving sinks exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WaterSavingSinksException string `json:"waterSavingSinksException,omitempty"`
	// WaterSavingToilets: Water saving toilets. All of the property's toilets use
	// 1.6 gallons per flush, or less.
	WaterSavingToilets bool `json:"waterSavingToilets,omitempty"`
	// WaterSavingToiletsException: Water saving toilets exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WaterSavingToiletsException string `json:"waterSavingToiletsException,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "IndependentOrganizationAuditsWaterUse") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "IndependentOrganizationAuditsWaterUse") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s WaterConservation) MarshalJSON() ([]byte, error) {
	type NoMethod WaterConservation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Wellness: Guest facilities at the property to promote or maintain health,
// beauty, and fitness.
type Wellness struct {
	// DoctorOnCall: Doctor on call. The hotel has a contract with a medical
	// professional who provides services to hotel guests should they fall ill
	// during their stay. The doctor may or may not have an on-site office or be at
	// the hotel at all times.
	DoctorOnCall bool `json:"doctorOnCall,omitempty"`
	// DoctorOnCallException: Doctor on call exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	DoctorOnCallException string `json:"doctorOnCallException,omitempty"`
	// EllipticalMachine: Elliptical machine. An electric, stationary fitness
	// machine with pedals that simulates climbing, walking or running and provides
	// a user-controlled range of speeds and tensions. May not have arm-controlled
	// levers to work out the upper body as well. Commonly found in a gym, fitness
	// room, health center, or health club.
	EllipticalMachine bool `json:"ellipticalMachine,omitempty"`
	// EllipticalMachineException: Elliptical machine exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	EllipticalMachineException string `json:"ellipticalMachineException,omitempty"`
	// FitnessCenter: Fitness center. A room or building at the hotel containing
	// equipment to promote physical activity, such as treadmills, elliptical
	// machines, stationary bikes, weight machines, free weights, and/or stretching
	// mats. Use of the fitness center can be free or for a fee. May or may not be
	// staffed. May or may not offer instructor-led classes in various styles of
	// physical conditioning. May or may not be open 24/7. May or may not include
	// locker rooms and showers. Also known as health club, gym, fitness room,
	// health center.
	FitnessCenter bool `json:"fitnessCenter,omitempty"`
	// FitnessCenterException: Fitness center exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FitnessCenterException string `json:"fitnessCenterException,omitempty"`
	// FreeFitnessCenter: Free fitness center. Guests may use the fitness center
	// for free.
	FreeFitnessCenter bool `json:"freeFitnessCenter,omitempty"`
	// FreeFitnessCenterException: Free fitness center exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FreeFitnessCenterException string `json:"freeFitnessCenterException,omitempty"`
	// FreeWeights: Free weights. Individual handheld fitness equipment of varied
	// weights used for upper body strength training or bodybuilding. Also known as
	// barbells, dumbbells, or kettlebells. Often stored on a rack with the weights
	// arranged from light to heavy. Commonly found in a gym, fitness room, health
	// center, or health club.
	FreeWeights bool `json:"freeWeights,omitempty"`
	// FreeWeightsException: Free weights exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	FreeWeightsException string `json:"freeWeightsException,omitempty"`
	// Massage: Massage. A service provided by a trained massage therapist
	// involving the physical manipulation of a guest's muscles in order to achieve
	// relaxation or pain relief.
	Massage bool `json:"massage,omitempty"`
	// MassageException: Massage exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	MassageException string `json:"massageException,omitempty"`
	// Salon: Salon. A room at the hotel where professionals provide hair styling
	// services such as shampooing, blow drying, hair dos, hair cutting and hair
	// coloring. Also known as hairdresser or beauty salon.
	Salon bool `json:"salon,omitempty"`
	// SalonException: Salon exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SalonException string `json:"salonException,omitempty"`
	// Sauna: Sauna. A wood-paneled room heated to a high temperature where guests
	// sit on built-in wood benches for the purpose of perspiring and relaxing
	// their muscles. Can be dry or slightly wet heat. Not a steam room.
	Sauna bool `json:"sauna,omitempty"`
	// SaunaException: Sauna exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SaunaException string `json:"saunaException,omitempty"`
	// Spa: Spa. A designated area, room or building at the hotel offering health
	// and beauty treatment through such means as steam baths, exercise equipment,
	// and massage. May also offer facials, nail care, and hair care. Services are
	// usually available by appointment and for an additional fee. Does not apply
	// if hotel only offers a steam room; must offer other beauty and/or health
	// treatments as well.
	Spa bool `json:"spa,omitempty"`
	// SpaException: Spa exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	SpaException string `json:"spaException,omitempty"`
	// Treadmill: Treadmill. An electric stationary fitness machine that simulates
	// a moving path to promote walking or running within a range of
	// user-controlled speeds and inclines. Also known as running machine. Commonly
	// found in a gym, fitness room, health center, or health club.
	Treadmill bool `json:"treadmill,omitempty"`
	// TreadmillException: Treadmill exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	TreadmillException string `json:"treadmillException,omitempty"`
	// WeightMachine: Weight machine. Non-electronic fitness equipment designed for
	// the user to target the exertion of different muscles. Usually incorporates a
	// padded seat, a stack of flat weights and various bars and pulleys. May be
	// designed for toning a specific part of the body or may involve different
	// user-controlled settings, hardware and pulleys so as to provide an overall
	// workout in one machine. Commonly found in a gym, fitness center, fitness
	// room, or health club.
	WeightMachine bool `json:"weightMachine,omitempty"`
	// WeightMachineException: Weight machine exception.
	//
	// Possible values:
	//   "EXCEPTION_UNSPECIFIED" - Default unspecified exception. Use this only if
	// a more specific exception does not match.
	//   "UNDER_CONSTRUCTION" - Amenity or service is unavailable due to ongoing
	// work orders.
	//   "DEPENDENT_ON_SEASON" - Amenity or service availability is seasonal.
	//   "DEPENDENT_ON_DAY_OF_WEEK" - Amenity or service availability depends on
	// the day of the week.
	WeightMachineException string `json:"weightMachineException,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DoctorOnCall") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DoctorOnCall") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Wellness) MarshalJSON() ([]byte, error) {
	type NoMethod Wellness
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type LocationsGetLodgingCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetLodging: Returns the Lodging of a specific location.
//
//   - name: Google identifier for this location in the form:
//     `locations/{location_id}/lodging`.
func (r *LocationsService) GetLodging(nameid string) *LocationsGetLodgingCall {
	c := &LocationsGetLodgingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// ReadMask sets the optional parameter "readMask": Required. The specific
// fields to return. Use "*" to include all fields. Repeated field items cannot
// be individually specified.
func (c *LocationsGetLodgingCall) ReadMask(readMask string) *LocationsGetLodgingCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsGetLodgingCall) Fields(s ...googleapi.Field) *LocationsGetLodgingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsGetLodgingCall) IfNoneMatch(entityTag string) *LocationsGetLodgingCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsGetLodgingCall) Context(ctx context.Context) *LocationsGetLodgingCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsGetLodgingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsGetLodgingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "mybusinesslodging.locations.getLodging", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "mybusinesslodging.locations.getLodging" call.
// Any non-2xx status code is an error. Response headers are in either
// *Lodging.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsGetLodgingCall) Do(opts ...googleapi.CallOption) (*Lodging, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Lodging{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "mybusinesslodging.locations.getLodging", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsUpdateLodgingCall struct {
	s          *Service
	nameid     string
	lodging    *Lodging
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateLodging: Updates the Lodging of a specific location.
//
//   - name: Google identifier for this location in the form:
//     `locations/{location_id}/lodging`.
func (r *LocationsService) UpdateLodging(nameid string, lodging *Lodging) *LocationsUpdateLodgingCall {
	c := &LocationsUpdateLodgingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.lodging = lodging
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The specific
// fields to update. Use "*" to update all fields, which may include unsetting
// empty fields in the request. Repeated field items cannot be individually
// updated.
func (c *LocationsUpdateLodgingCall) UpdateMask(updateMask string) *LocationsUpdateLodgingCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsUpdateLodgingCall) Fields(s ...googleapi.Field) *LocationsUpdateLodgingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsUpdateLodgingCall) Context(ctx context.Context) *LocationsUpdateLodgingCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsUpdateLodgingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsUpdateLodgingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.lodging)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "mybusinesslodging.locations.updateLodging", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "mybusinesslodging.locations.updateLodging" call.
// Any non-2xx status code is an error. Response headers are in either
// *Lodging.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsUpdateLodgingCall) Do(opts ...googleapi.CallOption) (*Lodging, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Lodging{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "mybusinesslodging.locations.updateLodging", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsLodgingGetGoogleUpdatedCall struct {
	s            *Service
	nameid       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetGoogleUpdated: Returns the Google updated Lodging of a specific location.
//
//   - name: Google identifier for this location in the form:
//     `locations/{location_id}/lodging`.
func (r *LocationsLodgingService) GetGoogleUpdated(nameid string) *LocationsLodgingGetGoogleUpdatedCall {
	c := &LocationsLodgingGetGoogleUpdatedCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	return c
}

// ReadMask sets the optional parameter "readMask": Required. The specific
// fields to return. Use "*" to include all fields. Repeated field items cannot
// be individually specified.
func (c *LocationsLodgingGetGoogleUpdatedCall) ReadMask(readMask string) *LocationsLodgingGetGoogleUpdatedCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsLodgingGetGoogleUpdatedCall) Fields(s ...googleapi.Field) *LocationsLodgingGetGoogleUpdatedCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsLodgingGetGoogleUpdatedCall) IfNoneMatch(entityTag string) *LocationsLodgingGetGoogleUpdatedCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsLodgingGetGoogleUpdatedCall) Context(ctx context.Context) *LocationsLodgingGetGoogleUpdatedCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsLodgingGetGoogleUpdatedCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsLodgingGetGoogleUpdatedCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:getGoogleUpdated")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "mybusinesslodging.locations.lodging.getGoogleUpdated", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "mybusinesslodging.locations.lodging.getGoogleUpdated" call.
// Any non-2xx status code is an error. Response headers are in either
// *GetGoogleUpdatedLodgingResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LocationsLodgingGetGoogleUpdatedCall) Do(opts ...googleapi.CallOption) (*GetGoogleUpdatedLodgingResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GetGoogleUpdatedLodgingResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "mybusinesslodging.locations.lodging.getGoogleUpdated", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
