#include "config.h" // IWYU pragma: keep
#include <string.h>
#include "compat/include/protocols/dumprestore.h"

#include "transformation.h"

/*
 * Initialize
 */
static int
null_initialize(UNUSED(Transformation *xform), UNUSED(int enc))
{
	return 0;
}

/*
 * Shut down.
 */
static int
null_shutdown(UNUSED(Transformation *xform))
{
	return 0;
}

/*
 * Handle fork.
 */
static int
null_startNewTape(UNUSED(Transformation *xform), UNUSED(struct tapebuf *tpbin),
	UNUSED(unsigned long *destlen))
{
	return 0;
}

/*
 * Start slave process.
 */
static int
null_startDiskIOProcess(UNUSED(Transformation *xform))
{
	return 0;
}

/*
 * End slave process.
 */
static int
null_endDiskIOProcess(UNUSED(Transformation *xform))
{
	return 0;
}

/*
 * Compress a buffer.
 */
static int
null_compress(UNUSED(Transformation *xform), struct tapebuf *tpbin, unsigned long *destlen,
	const char *src, int srclen)
{
	memcpy(tpbin->buf, src, srclen);
	*destlen = srclen;

	return 1;
}

/*
 * Decompress a buffer.
 */
static int
null_decompress(UNUSED(Transformation *xform), struct tapebuf *tpbin, unsigned long *destlen,
	const char *src, int srclen, UNUSED(const char **reason))
{
	memcpy(tpbin->buf, src, srclen);
	*destlen = srclen;

	return 1;
}

/*
 *
 */
Transformation transformation_null =
{
	0,
	{0},
	"null",
	0,
	&null_initialize,
	&null_shutdown,
	&null_startNewTape,
	&null_startDiskIOProcess,
	&null_endDiskIOProcess,
	&null_compress,
	&null_decompress
};
