// Copyright 2010-2021, Google Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#ifndef MOZC_CONVERTER_ATTRIBUTE_H_
#define MOZC_CONVERTER_ATTRIBUTE_H_

namespace mozc {
namespace converter {

// This unscoped enum is used to allow implicit conversion to integer types for
// bitwise operations. This is an alternative to using an enum class and
// explicit casting.
class Attribute {
 public:
  enum {
    DEFAULT_ATTRIBUTE = 0,
    // this was the best candidate before learning
    BEST_CANDIDATE = 1 << 0,
    // this candidate was reranked by user
    RERANKED = 1 << 1,
    // don't save it in history
    NO_HISTORY_LEARNING = 1 << 2,
    // don't save it in suggestion
    NO_SUGGEST_LEARNING = 1 << 3,
    // NO_HISTORY_LEARNING | NO_SUGGEST_LEARNING
    NO_LEARNING = (1 << 2 | 1 << 3),
    // learn it with left/right context
    CONTEXT_SENSITIVE = 1 << 4,
    // has "did you mean"
    SPELLING_CORRECTION = 1 << 5,
    // No need to have full/half width expansion
    NO_VARIANTS_EXPANSION = 1 << 6,
    // No need to have extra descriptions
    NO_EXTRA_DESCRIPTION = 1 << 7,
    // was generated by real-time conversion
    REALTIME_CONVERSION = 1 << 8,
    // contains tokens in user dictionary.
    USER_DICTIONARY = 1 << 9,
    // command candidate. e.g., incognito mode.
    COMMAND_CANDIDATE = 1 << 10,
    // key characters are consumed partially.
    // Consumed size is |consumed_key_size|.
    // If not set, all the key characters are consumed.
    PARTIALLY_KEY_CONSUMED = 1 << 11,
    // Typing correction candidate.
    // - Special description should be shown when the candidate is created
    //   by a dictionary predictor.
    // - No description should be shown when the candidate is loaded from
    //   history.
    // - Otherwise following unexpected behavior can be observed.
    //   1. Type "やんしょん" and submit "マンション" (annotated with "補正").
    //   2. Type "まんしょん".
    //   3. "マンション" (annotated with "補正") is shown as a candidate
    //      regardless of a user's correct typing.
    TYPING_CORRECTION = 1 << 12,
    // Auto partial suggestion candidate.
    // - Special description should be shown when the candidate is created
    //   by a dictionary predictor.
    // - No description should be shown when the candidate is loaded from
    //   history.
    AUTO_PARTIAL_SUGGESTION = 1 << 13,
    // Predicted from user prediction history.
    USER_HISTORY_PREDICTION = 1 << 14,
    // Contains suffix dictionary.
    SUFFIX_DICTIONARY = 1 << 15,
    // Disables modification and removal in rewriters.
    NO_MODIFICATION = 1 << 16,
    // Candidate which is reranked by user segment history rewriter.
    USER_SEGMENT_HISTORY_REWRITER = 1 << 17,
    // Keys are expanded in the dictionary lookup. Usually
    // Kana-modifiers are expanded.
    KEY_EXPANDED_IN_DICTIONARY = 1 << 18,
    // No-deletable candidate.
    // User history is basically deletable, but decoder can set NO_DELETABLE
    // attribute not to allow the candidate to be deleted.
    NO_DELETABLE = 1 << 19,
  };
};
}  // namespace converter
}  // namespace mozc

#endif  // MOZC_CONVERTER_ATTRIBUTE_H_
