## RabbitMQ 4.1.6

RabbitMQ `4.1.6` is a maintenance release in the `4.1.x` [release series](https://www.rabbitmq.com/release-information).

It is **strongly recommended** that you read [4.1.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.1.0)
in detail if upgrading from a version prior to `4.1.0`.


### Minimum Supported Erlang Version

[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.1.x/release-notes).



### Core Server

#### Bug Fixes

* Enabling the `khepri_db` feature flag while the [Log Exchange](https://www.rabbitmq.com/docs/logging#log-exchange)
  was enabled could cause a RabbitMQ node to run out of memory and crash.

  GitHub issues: [#14069](https://github.com/rabbitmq/rabbitmq-server/discussions/14069), [#14796](https://github.com/rabbitmq/rabbitmq-server/pull/14796)

* Feature flag state in the registry and on disk were not consistent for a period of time during node boot.

  GitHub issue: [#14943](https://github.com/rabbitmq/rabbitmq-server/pull/14943)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl export_definitions` could incorrectly serialize policy and operator policy
   definitions.

   GitHub issue: [#14800](https://github.com/rabbitmq/rabbitmq-server/pull/14800)


### MQTT Plugin

#### Bug Fixes

 * [Resource alarm](https://www.rabbitmq.com/docs/alarms) handling now uses more context: it is aware of individual resources.
   When a cluster had multiple resource alarms (namely for memory footprint and free disk space)
   in effect, the blocking state was prematurely cleared when only one resource alarm was.

   GitHub issue: [#14795](https://github.com/rabbitmq/rabbitmq-server/pull/14795)


### STOMP Plugin

#### Bug Fixes

 * [Resource alarm](https://www.rabbitmq.com/docs/alarms) handling now uses more context: it is aware of individual resources.
   When a cluster had multiple resource alarms (namely for memory footprint and free disk space)
   in effect, the blocking state was prematurely cleared when only one resource was [cleared].

   GitHub issue: [#14795](https://github.com/rabbitmq/rabbitmq-server/pull/14795)


### Web MQTT Plugin

#### Bug Fixes

 * [Resource alarm](https://www.rabbitmq.com/docs/alarms) handling now uses more context: it is aware of individual resources.
   When a cluster had multiple resource alarms (namely for memory footprint and free disk space)
   in effect, the blocking state was prematurely cleared when only one resource was [cleared].

   GitHub issue: [#14795](https://github.com/rabbitmq/rabbitmq-server/pull/14795)
