## RabbitMQ 4.2.3

RabbitMQ `4.2.3` is a maintenance release in the `4.2.x` [release series](https://www.rabbitmq.com/release-information).

It is **strongly recommended** that you read [4.2.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.2.0)
in detail if upgrading from a version prior to `4.2.0`.

### Minimum Supported Erlang Version

[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.2.x/release-notes).

### Core Server

#### Bug Fixes

 * [Default queue type](https://www.rabbitmq.com/docs/vhosts#default-queue-type) handling is now more defensive, avoiding an issue where
   attempts to declare a queue in a virtual host without any DQT set would result
   in a `PRECONDITION_FAILED` exception instead of falling back to the classic queue type
   for DQT.

   GitHub issues: [#11541](https://github.com/rabbitmq/rabbitmq-server/issues/11541), [#12109](https://github.com/rabbitmq/rabbitmq-server/issues/12109), [#12821](https://github.com/rabbitmq/rabbitmq-server/issues/12821), [#13837](https://github.com/rabbitmq/rabbitmq-server/issues/13837)

 * Classic queue recovery on Windows could fail due to an OS-specific file locking behavior.
   Such failures are now retried in two more contexts.

   GitHub issue: [#15136](https://github.com/rabbitmq/rabbitmq-server/pull/15136)

 * Certain exchange update operations in Khepri could cause severe contention.

   GitHub issue: [#15236](https://github.com/rabbitmq/rabbitmq-server/pull/15236)

 * Topic exchange binding deletions could leave orphaned trie edges in the Khepri projection,
   potentially causing a slowly creeping memory leak.

   GitHub issue: [#15025](https://github.com/rabbitmq/rabbitmq-server/pull/15025)

 * When a client that owns an exclusive queue disconnects and immediately reconnects and redeclares the same queue
   (under the same name), RabbitMQ node could delete the new queue depending on the timing of events.

   Previously the only workaround was to use exclusive server-named queues for clients that exhibited
   this behavior. Now RabbitMQ nodes take internal owner identity into account and will remove
   the original queue but not the new one.

   GitHub issue: [#15276](https://github.com/rabbitmq/rabbitmq-server/pull/15276)

  * "Other ETS" and "Other system" memory metrics could end up being reported as negative values
    due to concurrent ETS table updates, deletion and creation on the node.

    GitHub issue: [#15289](https://github.com/rabbitmq/rabbitmq-server/pull/15289)

 * `mirrored_supervisor:child/2` could fail with a `badmatch` exception
   when a significant enough number of shovels (or federation links) was removed.

   GitHub issue: [#15229](https://github.com/rabbitmq/rabbitmq-server/pull/15229)

 * Quorum queue could run into a logging exception during node drain.

   GitHub issue: [#15212](https://github.com/rabbitmq/rabbitmq-server/pull/15212)

#### Enhancements

 * Topic binding deletion in Khepri is now significantly more efficient.

   Deleting 100k topic bindings could previously take up to 30 minutes and now takes
   some 3-4 seconds.

   GitHub issue: [#15214](https://github.com/rabbitmq/rabbitmq-server/pull/15214)

 * It is now possible to `rabbitmq-queues shrink` only a subset of quorum queues on
   a node using a pattern (a regex).

   GitHub issue: [#15021](https://github.com/rabbitmq/rabbitmq-server/pull/15021)

 * CRL (Certificate Revocation List) cache can now be configured via `rabbitmq.conf`.

   GitHub issues: [#2338](https://github.com/rabbitmq/rabbitmq-server/issues/2338), [#15160](https://github.com/rabbitmq/rabbitmq-server/pull/15160)


### Federation Plugins

#### Bug Fixes

 * Restored exchange federation compatibility in mixed 4.2.x/4.1.x multi-node clusters.

   GitHub issue: [#15252](https://github.com/rabbitmq/rabbitmq-server/pull/15252)

#### Enhancements

 * Federation links and their connections are now stopped in parallel.

   This significantly improves shutdown time for nodes with many (into thousands) federation links.

   GitHub issue: [#15271](https://github.com/rabbitmq/rabbitmq-server/pull/15271)

 * Federation links no longer restart during plugin or node shutdown.

   For nodes with hundreds or thousands of federation links, link recovery could
   significantly delay node shutdown.

   GitHub issue: [#15258](https://github.com/rabbitmq/rabbitmq-server/pull/15258)

 * Federation links use AMQP 0-9-1 connections to remote nodes (clusters).

   Previously the timeout used when those connections are closed was fixed to 10 seconds.
   Now it is configurable via `rabbitmq.conf` in milliseconds:

   ```ini
   # 3 seconds for exchange federation
   federation.exchanges.connection_close_timeout = 3000

   # 3 seconds for queue federation
   federation.queues.connection_close_timeout = 3000
   ```

   The maximum supported value is 5 seconds (5000 ms).

   GitHub issue: [#15268](https://github.com/rabbitmq/rabbitmq-server/pull/15268)


### CLI Tools

#### Enhancements

 * `rabbitmq-streams grow` and `rabbitmq-streams shrink` are new commands that mirror existing
   `rabbitmq-queues grow` and `rabbitmq-queues shrink` functionality for streams.

   GitHub issue: [#15189](https://github.com/rabbitmq/rabbitmq-server/pull/15189)


### MQTT Plugin

#### Enhancements

 * A new configuration option, `mqtt.disconnect_on_unauthorized`, controls whether
   MQTT connections are closed upon authorization failures (for example, an attempt to
   consume from a topic the client has no permission for).

   When set to `false`, the connection remains open and an appropriate protocol-level
   response is sent to the client instead.

   The default value is `true`, same as RabbitMQ MQTT implementation's historic behavior.

   GitHub issue: [#15201](https://github.com/rabbitmq/rabbitmq-server/pull/15201)


### Management Plugin

#### Bug Fixes

 * OAuth 2: `preferred_auth_mechanism` and `strict_auth_mechanism` are no longer validated
   when not used (configured).

   GitHub issue: [#15148](https://github.com/rabbitmq/rabbitmq-server/pull/15148)


### etcd Peer Discovery Plugin

#### Bug Fixes

 * When credentials were provided, the password was double-encrypted, resulting in
   etcd authentication failures.

   GitHub issue: [#15191](https://github.com/rabbitmq/rabbitmq-server/issues/15191)


### HTTP Auth Backend Plugin

#### Bug Fixes

 * The `customize_hostname_check` TLS option was unintentionally ignored.

   GitHub issue: [#15184](https://github.com/rabbitmq/rabbitmq-server/pull/15184)


### Dependency Changes

 * `khepri` was upgraded to [`0.17.4`](https://github.com/rabbitmq/khepri/releases/tag/v0.17.4)
 * `khepri_mnesia_migration` was upgraded to [`0.8.1`](https://github.com/rabbitmq/khepri_mnesia_migration/releases/tag/v0.8.1)
 * `osiris` was upgraded to [`1.10.3`](https://github.com/rabbitmq/osiris/releases/tag/v1.10.3)
