--TEST--
Test for bug #2371: Lazy proxy objects are initialised correctly
--SKIPIF--
<?php
require __DIR__ . '/../utils.inc';
check_reqs('PHP >= 8.4; dbgp');
?>
--FILE--
<?php
require 'dbgp/dbgpclient.php';
$filename = dirname(__FILE__) . '/bug02371-003.inc';

$commands = array(
	"breakpoint_set -t line -f file://{$filename} -n 18",
	"breakpoint_set -t line -f file://{$filename} -n 20",
	'run',
	'property_get -n $user',
	'run',
	'property_get -n $user',
	'detach',
);

dbgpRunFile( $filename, $commands );
?>
--EXPECTF--
<?xml version="1.0" encoding="iso-8859-1"?>
<init xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" fileuri="file://bug02371-003.inc" language="PHP" xdebug:language_version="" protocol_version="1.0" appid=""><engine version=""><![CDATA[Xdebug]]></engine><author><![CDATA[Derick Rethans]]></author><url><![CDATA[https://xdebug.org]]></url><copyright><![CDATA[Copyright (c) 2002-2099 by Derick Rethans]]></copyright></init>

-> breakpoint_set -i 1 -t line -f file://bug02371-003.inc -n 18
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="breakpoint_set" transaction_id="1" id="{{PID}}0001"></response>

-> breakpoint_set -i 2 -t line -f file://bug02371-003.inc -n 20
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="breakpoint_set" transaction_id="2" id="{{PID}}0002"></response>

-> run -i 3
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="run" transaction_id="3" status="break" reason="ok"><xdebug:message filename="file://bug02371-003.inc" lineno="18"></xdebug:message></response>

-> property_get -i 4 -n $user
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="property_get" transaction_id="4"><property name="$user" fullname="$user" facet="lazy-proxy" type="object" classname="User" children="1" numchildren="2" page="0" pagesize="32"><property name="id" fullname="$user-&gt;id" facet="public" type="int"><![CDATA[43]]></property><property name="name" fullname="$user-&gt;name" facet="public" type="string" size="5" encoding="base64"><![CDATA[Qmx1ZXk=]]></property></property></response>

-> run -i 5
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="run" transaction_id="5" status="break" reason="ok"><xdebug:message filename="file://bug02371-003.inc" lineno="20"></xdebug:message></response>

-> property_get -i 6 -n $user
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="property_get" transaction_id="6"><property name="$user" fullname="$user" facet="lazy-proxy" type="object" classname="User" children="1" numchildren="2" page="0" pagesize="32"><property name="id" fullname="$user-&gt;id" facet="public" type="int"><![CDATA[43]]></property><property name="name" fullname="$user-&gt;name" facet="public" type="string" size="5" encoding="base64"><![CDATA[Qmx1ZXk=]]></property></property></response>

-> detach -i 7
<?xml version="1.0" encoding="iso-8859-1"?>
<response xmlns="urn:debugger_protocol_v1" xmlns:xdebug="https://xdebug.org/dbgp/xdebug" command="detach" transaction_id="7" status="stopping" reason="ok"></response>
